/*
 * Decompiled with CFR 0.152.
 */
package org.piax.gtrans.raw.tcp;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import org.piax.gtrans.raw.tcp.TcpChannel;
import org.piax.gtrans.raw.tcp.TcpTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SocketAcceptor
extends Thread {
    private static final Logger logger = LoggerFactory.getLogger(SocketAcceptor.class);
    static int REQ_QUEUE_LEN = 50;
    final TcpTransport transport;
    final ServerSocket ssoc;
    private volatile boolean isTerminated;

    SocketAcceptor(TcpTransport transport, InetSocketAddress sockAddr) throws IOException {
        this.transport = transport;
        this.ssoc = new ServerSocket(sockAddr.getPort(), REQ_QUEUE_LEN, sockAddr.getAddress());
        this.isTerminated = false;
    }

    synchronized void terminate() {
        logger.trace("ENTRY:");
        if (this.isTerminated) {
            return;
        }
        this.isTerminated = true;
        try {
            this.ssoc.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        logger.trace("EXIT:");
    }

    boolean isTerminated() {
        return this.isTerminated;
    }

    @Override
    public void run() {
        logger.trace("ENTRY:");
        while (!this.isTerminated) {
            try {
                Socket soc = this.ssoc.accept();
                TcpChannel ch = this.transport.newAcceptedChannel(soc);
                if (this.transport.onAccepting(ch)) continue;
                ch.close();
            }
            catch (IOException e) {
                if (this.isTerminated) break;
                this.transport.onHangup(e);
                break;
            }
        }
        logger.trace("EXIT:");
    }
}

