/*
 * Decompiled with CFR 0.152.
 */
package org.piax.gtrans.raw.tcp;

import java.io.IOException;
import java.net.Socket;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.piax.common.PeerId;
import org.piax.gtrans.Channel;
import org.piax.gtrans.GTransConfigValues;
import org.piax.gtrans.raw.InetTransport;
import org.piax.gtrans.raw.RawChannel;
import org.piax.gtrans.raw.tcp.SocketAcceptor;
import org.piax.gtrans.raw.tcp.TcpChannel;
import org.piax.gtrans.raw.tcp.TcpLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TcpTransport
extends InetTransport<TcpLocator> {
    private static final Logger logger = LoggerFactory.getLogger(TcpTransport.class);
    static String THREAD_NAME_PREFIX = "tcp-";
    static final AtomicInteger thNum = new AtomicInteger(1);
    private final Set<TcpChannel> channels = Collections.newSetFromMap(new ConcurrentHashMap());
    private volatile SocketAcceptor acceptor = null;
    final int maxReadLen = GTransConfigValues.TCP_READ_BUF_LEN;

    public TcpTransport(PeerId peerId, TcpLocator peerLocator) throws IOException {
        super(peerId, peerLocator, true);
        this.acceptor = new SocketAcceptor(this, peerLocator.getSocketAddress());
        this.acceptor.start();
    }

    @Override
    public void fin() {
        if (this.acceptor != null) {
            this.acceptor.terminate();
            this.acceptor = null;
        }
        for (TcpChannel ch : this.channels) {
            ch.close();
        }
        super.fin();
    }

    public int getMTU() {
        return this.maxReadLen;
    }

    @Override
    public RawChannel<TcpLocator> newChannel(TcpLocator dst, boolean isDuplex, int timeout) throws IOException {
        TcpChannel ch = new TcpChannel(this, dst.getSocketAddress(), this.maxReadLen, timeout);
        new Thread((Runnable)ch, String.valueOf(THREAD_NAME_PREFIX) + thNum.getAndIncrement()).start();
        this.addChannel(ch);
        return ch;
    }

    TcpChannel newAcceptedChannel(Socket soc) throws IOException {
        TcpChannel ch = new TcpChannel(this, soc, this.maxReadLen);
        new Thread((Runnable)ch, String.valueOf(THREAD_NAME_PREFIX) + thNum.getAndIncrement()).start();
        this.addChannel(ch);
        return ch;
    }

    void onHangup(Exception cause) {
        logger.error("", (Throwable)cause);
    }

    private void addChannel(TcpChannel channel) {
        this.channels.add(channel);
    }

    void removeChannel(TcpChannel channel) {
        this.channels.remove(channel);
    }

    void onReceive(TcpChannel channel) {
        if (this.chListener != null) {
            this.chListener.onReceive((Channel)channel);
        }
    }

    boolean onAccepting(TcpChannel channel) {
        if (this.chListener != null) {
            return this.chListener.onAccepting((Channel)channel);
        }
        return false;
    }

    void onClosed(TcpChannel channel) {
        channel.close();
        if (this.chListener != null) {
            this.chListener.onClosed((Channel)channel);
        }
    }

    void onFailure(TcpChannel channel, Exception cause) {
        if (this.chListener != null) {
            this.chListener.onFailure((Channel)channel, cause);
        }
        channel.close();
    }
}

