/*
 * Decompiled with CFR 0.152.
 */
package org.piax.gtrans.raw.udp;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import org.piax.common.Endpoint;
import org.piax.common.PeerId;
import org.piax.gtrans.GTransConfigValues;
import org.piax.gtrans.NoSuchPeerException;
import org.piax.gtrans.ReceivedMessage;
import org.piax.gtrans.Transport;
import org.piax.gtrans.raw.InetTransport;
import org.piax.gtrans.raw.RawChannel;
import org.piax.gtrans.raw.udp.UdpLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UdpTransport
extends InetTransport<UdpLocator> {
    private static final Logger logger = LoggerFactory.getLogger(UdpTransport.class);
    static String THREAD_NAME_PREFIX = "udp-";
    static final AtomicInteger thNum = new AtomicInteger(1);
    private final DatagramSocket sendSoc;
    private final DatagramSocket recvSoc;
    private final SocketListener socListener;
    private volatile boolean isTerminated;

    public UdpTransport(PeerId peerId, UdpLocator peerLocator) throws IOException {
        super(peerId, peerLocator, true);
        int port = peerLocator.getPort();
        this.sendSoc = new DatagramSocket();
        this.recvSoc = new DatagramSocket(port, peerLocator.getInetAddress());
        this.sendSoc.setSendBufferSize(GTransConfigValues.SOCKET_SEND_BUF_SIZE);
        this.recvSoc.setReceiveBufferSize(GTransConfigValues.SOCKET_RECV_BUF_SIZE);
        this.isTerminated = false;
        this.socListener = new SocketListener();
        this.socListener.start();
    }

    @Override
    public void fin() {
        if (this.isTerminated) {
            return;
        }
        super.fin();
        this.isTerminated = true;
        this.sendSoc.close();
        this.recvSoc.close();
        try {
            this.socListener.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public int getMTU() {
        return GTransConfigValues.MAX_PACKET_SIZE;
    }

    void receiveBytes(UdpLocator src, byte[] msg) {
        if (msg.length > this.getMTU()) {
            logger.error("receive data over MTU:" + msg.length + "bytes");
            return;
        }
        ByteBuffer bb = ByteBuffer.wrap(msg);
        ReceivedMessage rmsg = new ReceivedMessage(null, (Endpoint)src, (Object)bb);
        if (this.listener != null) {
            this.listener.onReceive((Transport)this, rmsg);
        }
    }

    @Override
    public void send(UdpLocator toPeer, Object msg) throws IOException {
        ByteBuffer bbuf = (ByteBuffer)msg;
        int len = bbuf.remaining();
        if (len > this.getMTU()) {
            logger.error("send data over MTU:" + len + "bytes");
            return;
        }
        try {
            this.sendSoc.send(new DatagramPacket(bbuf.array(), len, toPeer.getSocketAddress()));
        }
        catch (SocketException e) {
            throw new NoSuchPeerException((Throwable)e);
        }
    }

    @Override
    public RawChannel<UdpLocator> newChannel(UdpLocator dst, boolean isDuplex, int timeout) throws IOException {
        throw new UnsupportedOperationException();
    }

    class SocketListener
    extends Thread {
        private final byte[] in;
        private DatagramPacket inPac;

        SocketListener() {
            super(String.valueOf(THREAD_NAME_PREFIX) + thNum.getAndIncrement());
            this.in = new byte[UdpTransport.this.getMTU() + 1];
            this.inPac = new DatagramPacket(this.in, this.in.length);
        }

        @Override
        public void run() {
            while (!UdpTransport.this.isTerminated) {
                try {
                    UdpTransport.this.recvSoc.receive(this.inPac);
                    int len = this.inPac.getLength();
                    UdpLocator src = new UdpLocator((InetSocketAddress)this.inPac.getSocketAddress());
                    UdpTransport.this.receiveBytes(src, Arrays.copyOf(this.in, len));
                }
                catch (IOException e) {
                    if (UdpTransport.this.isTerminated) break;
                    logger.warn("", (Throwable)e);
                }
            }
        }
    }
}

