/*
 * Decompiled with CFR 0.152.
 */
package org.piax.gtrans.tsd;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.concurrent.atomic.AtomicInteger;
import org.piax.gtrans.tsd.ServiceInfo;
import org.piax.gtrans.tsd.TSD;
import org.piax.util.ByteUtil;
import org.piax.util.SerializingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BroadcastTSD<T>
extends TSD<T>
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(BroadcastTSD.class);
    static String THREAD_NAME_PREFIX = "bTSD-";
    static final AtomicInteger thNum = new AtomicInteger(1);
    public static int PSDP_PORT = 12370;
    private static BroadcastTSD instance = null;
    private static int refCounter = 0;
    protected final DatagramSocket socket = new DatagramSocket(PSDP_PORT);
    protected boolean isTerminated;

    public static synchronized <T> BroadcastTSD<T> genTSD() throws IOException {
        if (instance != null) {
            ++refCounter;
            return instance;
        }
        instance = new BroadcastTSD<T>();
        new Thread((Runnable)instance, String.valueOf(THREAD_NAME_PREFIX) + thNum.getAndIncrement()).start();
        ++refCounter;
        return instance;
    }

    private BroadcastTSD() throws IOException {
        this.socket.setBroadcast(true);
        this.isTerminated = false;
    }

    @Override
    public synchronized void fin() {
        if (this.isTerminated) {
            return;
        }
        if (--refCounter > 0) {
            return;
        }
        this.isTerminated = true;
        refCounter = 0;
        instance = null;
        this.socket.close();
    }

    @Override
    public void run() {
        byte[] in = new byte[1400];
        DatagramPacket inPac = new DatagramPacket(in, in.length);
        while (!this.isTerminated) {
            try {
                this.socket.receive(inPac);
                int len = inPac.getLength();
                ServiceInfo info = (ServiceInfo)SerializingUtil.deserialize((byte[])in, (int)0, (int)len);
                this.found(info);
            }
            catch (IOException e) {
                if (this.isTerminated) break;
                logger.warn("", (Throwable)e);
            }
            catch (ClassNotFoundException e) {
                logger.error("", (Throwable)e);
            }
            catch (ClassCastException e) {
                logger.error("", (Throwable)e);
            }
        }
    }

    @Override
    protected void advertise(ServiceInfo<T> info) throws IOException {
        logger.debug("advertise info {}", info);
        byte[] data = SerializingUtil.serialize(info);
        InetAddress baddr = InetAddress.getByName("255.255.255.255");
        DatagramPacket outPac = new DatagramPacket(data, data.length, baddr, PSDP_PORT);
        this.socket.send(outPac);
        if (logger.isDebugEnabled()) {
            logger.debug("advertise bytes {}", (Object)ByteUtil.bytes2Hex((byte[])data));
        }
    }
}

