/*
 * Decompiled with CFR 0.152.
 */
package org.piax.gtrans.tsd;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.piax.common.ObjectId;
import org.piax.common.PeerId;
import org.piax.gtrans.tsd.ServiceInfo;
import org.piax.gtrans.tsd.TSDListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TSD<T> {
    private static final Logger logger = LoggerFactory.getLogger(TSD.class);
    protected static final Timer timer = new Timer("TSDTimer", true);
    private final List<ServiceInfo<T>> localServices = new ArrayList<ServiceInfo<T>>();
    private final Map<String, TSDListener> listenersByUpper = new ConcurrentHashMap<String, TSDListener>();
    private final Set<PeerId> usingPeers = new CopyOnWriteArraySet<PeerId>();
    private final Map<String, DiscoveryTask> discoveryTasks = new ConcurrentHashMap<String, DiscoveryTask>();

    public abstract void fin();

    private String getKey(PeerId peerId, ObjectId receiver) {
        return String.valueOf(peerId.toString()) + "/" + receiver.toString();
    }

    public void setDiscoveryListener(PeerId peerId, ObjectId receiver, TSDListener listener) {
        this.usingPeers.add(peerId);
        if (listener == null) {
            this.listenersByUpper.remove(this.getKey(peerId, receiver));
        } else {
            this.listenersByUpper.put(this.getKey(peerId, receiver), listener);
        }
    }

    public TSDListener getDiscoveryListener(PeerId peerId, ObjectId receiver) {
        return this.listenersByUpper.get(this.getKey(peerId, receiver));
    }

    protected abstract void advertise(ServiceInfo<T> var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerService(PeerId peerId, ObjectId receiver, T info) {
        ServiceInfo<T> serv = new ServiceInfo<T>(info, peerId, receiver);
        List<ServiceInfo<T>> list = this.localServices;
        synchronized (list) {
            if (this.localServices.contains(serv)) {
                return;
            }
            this.localServices.add(serv);
        }
        try {
            this.advertise(serv);
        }
        catch (IOException e) {
            logger.warn("", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterService(PeerId peerId, ObjectId receiver, T info) {
        ServiceInfo<T> serv = new ServiceInfo<T>(info, peerId, receiver);
        List<ServiceInfo<T>> list = this.localServices;
        synchronized (list) {
            this.localServices.remove(serv);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterAllServices(PeerId peerId, ObjectId receiver) {
        List<ServiceInfo<T>> list = this.localServices;
        synchronized (list) {
            Iterator<ServiceInfo<T>> it = this.localServices.iterator();
            while (it.hasNext()) {
                ServiceInfo<T> sinfo = it.next();
                if (!peerId.equals((Object)sinfo.peerId) || !receiver.equals((Object)sinfo.objId)) continue;
                it.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void advertiseAll(PeerId peerId, ObjectId receiver) {
        try {
            List<ServiceInfo<T>> list = this.localServices;
            synchronized (list) {
                for (ServiceInfo<T> sinfo : this.localServices) {
                    if (!peerId.equals((Object)sinfo.peerId) || !receiver.equals((Object)sinfo.objId)) continue;
                    this.advertise(sinfo);
                }
            }
        }
        catch (IOException e) {
            logger.warn("", (Throwable)e);
        }
    }

    public void scheduleDiscovery(PeerId peerId, ObjectId receiver, long delay, long period) {
        DiscoveryTask task = new DiscoveryTask(peerId, receiver);
        DiscoveryTask old = this.discoveryTasks.put(this.getKey(peerId, receiver), task);
        if (old != null) {
            old.cancel();
        }
        timer.schedule((TimerTask)task, delay, period);
    }

    public void cancelDiscovery(PeerId peerId, ObjectId receiver) {
        DiscoveryTask task = this.discoveryTasks.remove(this.getKey(peerId, receiver));
        if (task != null) {
            task.cancel();
        }
    }

    protected void found(ServiceInfo<T> serv) {
        for (PeerId p : this.usingPeers) {
            TSDListener listener;
            if (p.equals((Object)serv.peerId) || (listener = this.listenersByUpper.get(this.getKey(p, serv.objId))) == null) continue;
            listener.onDiscovered(serv.info);
        }
    }

    protected void checkDiscarding(PeerId peerId, ObjectId receiver) {
        TSDListener listener = this.listenersByUpper.get(this.getKey(peerId, receiver));
        if (listener != null) {
            listener.onFadeoutCheck();
        }
    }

    class DiscoveryTask
    extends TimerTask {
        final PeerId peerId;
        final ObjectId receiver;

        DiscoveryTask(PeerId peerId, ObjectId receiver) {
            this.peerId = peerId;
            this.receiver = receiver;
        }

        @Override
        public void run() {
            TSD.this.advertiseAll(this.peerId, this.receiver);
            TSD.this.checkDiscarding(this.peerId, this.receiver);
        }
    }
}

