/*
 * Decompiled with CFR 0.152.
 */
package org.piax.gtrans.util;

import java.io.IOException;
import org.piax.common.Endpoint;
import org.piax.common.ObjectId;
import org.piax.common.TransportId;
import org.piax.gtrans.IdConflictException;
import org.piax.gtrans.ProtocolUnsupportedException;
import org.piax.gtrans.ReceivedMessage;
import org.piax.gtrans.Transport;
import org.piax.gtrans.TransportListener;
import org.piax.gtrans.impl.DatagramBasedTransport;
import org.piax.gtrans.impl.NestedMessage;

public class ChannelAddOnTransport<E extends Endpoint>
extends DatagramBasedTransport<E, E> {
    public static TransportId DEFAULT_TRANSPORT_ID = new TransportId("chOn");

    public ChannelAddOnTransport(Transport<? super E> lowerTrans) throws IdConflictException {
        this(DEFAULT_TRANSPORT_ID, lowerTrans);
    }

    public ChannelAddOnTransport(TransportId transId, Transport<? super E> lowerTrans) throws IdConflictException {
        super(lowerTrans.getPeer(), transId, lowerTrans, true);
        this.getLowerTransport().setListener((ObjectId)transId, (TransportListener)this);
    }

    public E getEndpoint() {
        return (E)this.lowerTrans.getEndpoint();
    }

    public int getMTU() {
        return this.lowerTrans.getMTU();
    }

    public Transport<E> getLowerTransport() {
        Transport lower = this.lowerTrans;
        return lower;
    }

    @Override
    protected void lowerSend(E dst, NestedMessage nmsg) throws ProtocolUnsupportedException, IOException {
        this.getLowerTransport().send(this.transId, dst, (Object)nmsg);
    }

    @Override
    protected NestedMessage _preReceive(ReceivedMessage rmsg) {
        return (NestedMessage)rmsg.getMessage();
    }

    @Override
    protected boolean useReceiverThread(int numProc) {
        return false;
    }
}

