/*
 * Decompiled with CFR 0.152.
 */
package org.piax.gtrans.util;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.piax.common.Endpoint;
import org.piax.common.ObjectId;
import org.piax.common.TransportId;
import org.piax.gtrans.Channel;
import org.piax.gtrans.ChannelTransport;
import org.piax.gtrans.GTransConfigValues;
import org.piax.gtrans.IdConflictException;
import org.piax.gtrans.ProtocolUnsupportedException;
import org.piax.gtrans.ReceivedMessage;
import org.piax.gtrans.TransOptions;
import org.piax.gtrans.Transport;
import org.piax.gtrans.impl.BinaryJsonabilityException;
import org.piax.gtrans.impl.ExceededSizeException;
import org.piax.gtrans.impl.MessageBinaryJsonner;
import org.piax.gtrans.impl.NestedMessage;
import org.piax.gtrans.impl.OneToOneMappingTransport;
import org.piax.gtrans.util.Fragments;
import org.piax.util.ByteBufferUtil;
import org.piax.util.ByteUtil;
import org.piax.util.MersenneTwister;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FragmentationTransport<E extends Endpoint>
extends OneToOneMappingTransport<E> {
    private static final Logger logger = LoggerFactory.getLogger(FragmentationTransport.class);
    private static final Random rand = new MersenneTwister();
    private final Fragments frags = new Fragments();
    private int msgId = rand.nextInt(Integer.MAX_VALUE);

    public FragmentationTransport(TransportId transId, ChannelTransport<E> lowerTrans) throws IdConflictException, IOException {
        super(transId, lowerTrans);
    }

    public synchronized void fin() {
        super.fin();
        this.lowerTrans.fin();
        this.frags.fin();
    }

    @Override
    public int getMTU() {
        return GTransConfigValues.MAX_MSG_SIZE;
    }

    private synchronized int newMsgId() {
        this.msgId = this.msgId < Integer.MAX_VALUE ? ++this.msgId : 1;
        return this.msgId;
    }

    private List<byte[]> partitioning(ByteBuffer msg) {
        ArrayList<byte[]> flist = new ArrayList<byte[]>();
        int lowerMsgSize = this.lowerTrans.getMTU() - 6;
        int msgLen = msg.remaining();
        int msgId = 0;
        int pNum = 1;
        if (msgLen > lowerMsgSize) {
            msgId = this.newMsgId();
            pNum = (msgLen - 1) / lowerMsgSize + 1;
        }
        int i = 0;
        while (i < pNum) {
            int boff = msg.arrayOffset() + msg.position() + i * lowerMsgSize;
            int blen = i == pNum - 1 ? msgLen - i * lowerMsgSize : lowerMsgSize;
            byte[] pac = this.frags.newPacketBytes(msgId, i, pNum, msg.array(), boff, blen);
            if (logger.isDebugEnabled()) {
                logger.debug("fragPacket msgId:{} i:{} len:{}", new Object[]{msgId, i, pac.length});
                logger.trace("fragPacket:{}", (Object)ByteUtil.dumpBytes((byte[])pac));
            }
            flist.add(pac);
            ++i;
        }
        return flist;
    }

    @Override
    protected void lowerSend(ObjectId sender, ObjectId receiver, E dst, NestedMessage nmsg, TransOptions opts) throws ProtocolUnsupportedException, IOException {
        ByteBuffer bb;
        try {
            bb = MessageBinaryJsonner.serialize(nmsg);
        }
        catch (BinaryJsonabilityException e) {
            logger.error("", (Throwable)e);
            return;
        }
        catch (ExceededSizeException e) {
            throw new IOException(e);
        }
        IOException excep = null;
        for (byte[] _msg : this.partitioning(bb)) {
            try {
                this.getLowerTransport().send(sender, receiver, dst, (Object)_msg);
            }
            catch (IOException e) {
                excep = e;
            }
        }
        if (excep != null) {
            throw excep;
        }
    }

    @Override
    protected void lowerChSend(Channel<E> ch, NestedMessage nmsg) throws IOException {
        ByteBuffer bb;
        try {
            bb = MessageBinaryJsonner.serialize(nmsg);
        }
        catch (BinaryJsonabilityException e) {
            logger.error("", (Throwable)e);
            return;
        }
        catch (ExceededSizeException e) {
            throw new IOException(e);
        }
        for (byte[] _msg : this.partitioning(bb)) {
            ch.send((Object)_msg);
        }
    }

    protected boolean useReceiverThread(int numProc) {
        return false;
    }

    private ByteBuffer defragments(Endpoint from, byte[] pac) {
        int len = pac.length;
        Fragments.FragmentPacket fpac = new Fragments.FragmentPacket(pac, len);
        if (logger.isDebugEnabled()) {
            logger.debug("fragPacket tag:{} seq:{} len:{}", new Object[]{this.frags.getTag(from, fpac.msgId), fpac._seq, len});
            logger.trace("fragPacket:{}", (Object)ByteUtil.dumpBytes((byte[])pac, (int)0, (int)len));
        }
        ByteBuffer _msg = null;
        _msg = fpac.msgId == 0 ? ByteBufferUtil.byte2Buffer((byte[])fpac.bbuf, (int)fpac.boff, (int)fpac.blen) : this.frags.put(from, fpac);
        if (_msg != null) {
            logger.debug("defrag done: rsv bytes:{}", (Object)_msg.remaining());
        }
        return _msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onReceive(Channel<E> lowerCh) {
        OneToOneMappingTransport.OneToOneChannel<E> ch = null;
        NestedMessage nmsg = null;
        Channel<E> channel = lowerCh;
        synchronized (channel) {
            byte[] b = (byte[])lowerCh.receive();
            if (b == null) {
                logger.error("null message received");
                return;
            }
            ByteBuffer _msg = this.defragments(lowerCh.getRemote(), b);
            if (_msg == null) {
                return;
            }
            try {
                nmsg = MessageBinaryJsonner.deserialize(_msg);
                if (nmsg == null) {
                    logger.error("null message received");
                    return;
                }
                ch = super._putReceiveQueue(lowerCh, nmsg);
            }
            catch (BinaryJsonabilityException e) {
                logger.error("", (Throwable)e);
            }
        }
        if (ch != null && nmsg != null) {
            super._onReceive(ch, nmsg);
        }
    }

    @Override
    public void onReceive(Transport<E> trans, ReceivedMessage rmsg) {
        ByteBuffer _msg = this.defragments(rmsg.getSource(), (byte[])rmsg.getMessage());
        if (_msg == null) {
            return;
        }
        try {
            NestedMessage nmsg = MessageBinaryJsonner.deserialize(_msg);
            super.onReceive(trans, new ReceivedMessage(rmsg.getSender(), rmsg.getSource(), (Object)nmsg));
        }
        catch (BinaryJsonabilityException e) {
            logger.error("", (Throwable)e);
        }
    }
}

