/*
 * Decompiled with CFR 0.152.
 */
package org.piax.gtrans.util;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import org.piax.common.Endpoint;
import org.piax.util.ByteBufferUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Fragments {
    private static final Logger logger = LoggerFactory.getLogger(Fragments.class);
    private static final int DECK_EXPIRED_TIME = 180000;
    static final int PACKET_HEADER_SIZE = 6;
    public static int duplicated = 0;
    public static int skipped = 0;
    public static int losses = 0;
    private static final Timer gcTimer = new Timer("fragmentsGC", true);
    private TimerTask gcTask;
    private final Map<String, Deck> decks = new ConcurrentHashMap<String, Deck>();
    private volatile int incompleteDeckNum = 0;

    public Fragments() {
        this.gcTask = new TimerTask(){

            @Override
            public void run() {
                for (Map.Entry ent : Fragments.this.decks.entrySet()) {
                    Deck d = (Deck)ent.getValue();
                    if (!d.isExpired()) continue;
                    Fragments.this.decks.remove(ent.getKey());
                    Fragments fragments = Fragments.this;
                    fragments.incompleteDeckNum = fragments.incompleteDeckNum + 1;
                    losses += d.unprocessedNum();
                }
            }
        };
        gcTimer.schedule(this.gcTask, 90000L, 180000L);
    }

    public void fin() {
        this.gcTask.cancel();
        int remained = this.decks.size();
        if (remained > 0) {
            for (Deck d : this.decks.values()) {
                ++this.incompleteDeckNum;
                losses += d.unprocessedNum();
                logger.debug("msg:{}", (Object)d);
            }
        }
        if (this.incompleteDeckNum > 0) {
            logger.info("incomplete msgs:{}, remained msgs: {}", (Object)this.incompleteDeckNum, (Object)remained);
        }
    }

    public byte[] newPacketBytes(int msgId, int seq, int fragNum, byte[] bbuf, int boff, int blen) {
        return new FragmentPacket(msgId, seq, fragNum, bbuf, boff, blen).toBytes();
    }

    public String getTag(Endpoint src, int msgId) {
        return src + "+" + msgId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuffer put(Endpoint src, FragmentPacket fpac) {
        Deck deck;
        logger.trace("ENTRY:");
        String tag = this.getTag(src, fpac.msgId);
        Map<String, Deck> map = this.decks;
        synchronized (map) {
            deck = this.decks.get(tag);
            if (deck == null) {
                deck = new Deck();
                this.decks.put(tag, deck);
            } else if (deck.isExpired()) {
                losses += deck.unprocessedNum();
                ++this.incompleteDeckNum;
                deck = new Deck();
                this.decks.put(tag, deck);
            }
        }
        ByteBuffer b = deck.put(fpac._seq, fpac.bbuf, fpac.boff, fpac.blen);
        if (b != null) {
            this.decks.remove(tag);
        }
        return b;
    }

    static class Deck {
        final long timeStamp = System.currentTimeMillis();
        int fragLen = 0;
        int fragNum = 0;
        ByteBuffer bb = null;
        int currentSeq = -1;
        List<Integer> skippedSeqs = new ArrayList<Integer>();
        List<DeferredFragment> deferredFrags = new ArrayList<DeferredFragment>();

        Deck() {
        }

        boolean isExpired() {
            return System.currentTimeMillis() > this.timeStamp + 180000L;
        }

        synchronized ByteBuffer put(int seq, byte[] bbuf, int boff, int blen) {
            logger.trace("seq:{} len:{}", (Object)seq, (Object)blen);
            if (this.bb == null) {
                if (seq >= 0) {
                    this.deferredFrags.add(new DeferredFragment(seq, bbuf, boff, blen));
                    return null;
                }
                this.fragLen = blen;
                this.fragNum = -seq + 1;
                this.bb = ByteBufferUtil.newByteBuffer((int)0, (int)(this.fragLen * this.fragNum));
                ByteBufferUtil.copy2Buffer((byte[])bbuf, (int)boff, (int)blen, (ByteBuffer)this.bb, (int)0);
                this.currentSeq = -seq;
                ByteBuffer ret = null;
                for (DeferredFragment frag : this.deferredFrags) {
                    ret = this.put(frag.seq, frag.data, 0, frag.data.length);
                }
                return ret;
            }
            if (seq < 0) {
                ++duplicated;
                logger.debug("duplicated fragment received");
                return null;
            }
            if (seq == 0) {
                this.bb.limit((this.fragNum - 1) * this.fragLen + blen);
                logger.trace("limit set to {}", (Object)this.bb.limit());
            }
            if (this.currentSeq > seq) {
                int skippedNum = this.currentSeq - seq - 1;
                if (skippedNum > 0) {
                    skipped += skippedNum;
                    logger.debug("{} fragments skipped", (Object)skippedNum);
                    int i = this.currentSeq - 1;
                    while (i > seq) {
                        this.skippedSeqs.add(i);
                        --i;
                    }
                }
                this.currentSeq = seq;
            } else if (seq > this.currentSeq) {
                if (!this.skippedSeqs.remove(new Integer(seq))) {
                    ++duplicated;
                    logger.debug("duplicated fragment received");
                    return null;
                }
            } else {
                ++duplicated;
                logger.debug("duplicated fragment received");
                return null;
            }
            int bbOff = (this.fragNum - seq - 1) * this.fragLen;
            ByteBufferUtil.copy2Buffer((byte[])bbuf, (int)boff, (int)blen, (ByteBuffer)this.bb, (int)bbOff);
            if (this.currentSeq == 0 && this.skippedSeqs.size() == 0) {
                return this.bb;
            }
            return null;
        }

        int unprocessedNum() {
            if (this.bb == null) {
                return 1;
            }
            return this.currentSeq + this.skippedSeqs.size();
        }

        public String toString() {
            return "[timeStamp=" + new Date(this.timeStamp) + ", frags=" + this.fragNum + ", curr=" + this.currentSeq + ", skipped=" + this.skippedSeqs + ", deferred=" + this.deferredFrags.size() + "]";
        }

        static class DeferredFragment {
            int seq;
            byte[] data;

            DeferredFragment(int seq, byte[] bbuf, int boff, int blen) {
                this.seq = seq;
                this.data = new byte[blen];
                System.arraycopy(bbuf, boff, this.data, 0, blen);
            }
        }
    }

    static class FragmentPacket {
        int msgId = 0;
        short _seq = 0;
        byte[] bbuf;
        int boff;
        int blen;

        FragmentPacket(int msgId, int seq, int fragNum, byte[] bbuf, int boff, int blen) {
            this.msgId = msgId;
            this._seq = FragmentPacket.encodedSeq(seq, fragNum);
            this.bbuf = bbuf;
            this.boff = boff;
            this.blen = blen;
        }

        FragmentPacket(byte[] pac, int len) {
            ByteBuffer b = ByteBuffer.wrap(pac, 0, len);
            this.msgId = b.getInt();
            this._seq = b.getShort();
            this.bbuf = pac;
            this.boff = 6;
            this.blen = len - 6;
        }

        private static short encodedSeq(int seq, int fragNum) {
            return (short)(seq == 0 ? 1 - fragNum : fragNum - seq - 1);
        }

        private int size() {
            return 6 + this.blen;
        }

        byte[] toBytes() {
            ByteBuffer b = ByteBuffer.allocate(this.size());
            b.putInt(this.msgId);
            b.putShort(this._seq);
            b.put(this.bbuf, this.boff, this.blen);
            return b.array();
        }

        @Deprecated
        ByteBuffer toByteBuffer() {
            ByteBuffer b = ByteBufferUtil.newByteBuffer((int)0, (int)this.size());
            b.putInt(this.msgId);
            b.putShort(this._seq);
            b.put(this.bbuf, this.boff, this.blen);
            ByteBufferUtil.flip((ByteBuffer)b);
            return b;
        }
    }
}

