/*
 * Decompiled with CFR 0.152.
 */
package org.piax.util;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;

public class ClassPathUtil {
    public static File[] toFiles(String classPath) throws IllegalArgumentException {
        String[] paths = classPath.split(File.pathSeparator);
        File[] files = new File[paths.length];
        int i = 0;
        while (i < paths.length) {
            files[i] = new File(paths[i]);
            if (!files[i].exists()) {
                throw new IllegalArgumentException("Unknown path:" + paths[i]);
            }
            ++i;
        }
        return files;
    }

    public static URL[] toURLs(File[] paths) throws IllegalArgumentException {
        URL[] urls = new URL[paths.length];
        int i = 0;
        while (i < paths.length) {
            try {
                urls[i] = paths[i].toURI().toURL();
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("Invalid File:" + paths[i]);
            }
            ++i;
        }
        return urls;
    }

    public static File[] toFiles(URL[] urls) throws URISyntaxException {
        File[] files = new File[urls.length];
        int i = 0;
        while (i < urls.length) {
            files[i] = new File(urls[i].toURI());
            ++i;
        }
        return files;
    }

    public static long lastModified(File dir) {
        long mtime = 0L;
        File[] subFiles = dir.listFiles();
        if (subFiles == null) {
            return 0L;
        }
        File[] fileArray = subFiles;
        int n = subFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File sub = fileArray[n2];
            if (sub.isDirectory()) {
                mtime = Math.max(mtime, ClassPathUtil.lastModified(sub));
            } else if (sub.getName().endsWith(".class") || sub.getName().endsWith(".CLASS")) {
                mtime = Math.max(mtime, sub.lastModified());
            }
            ++n2;
        }
        return mtime;
    }

    public static long lastModified(File[] paths) {
        long mtime = 0L;
        File[] fileArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            File path = fileArray[n2];
            if (path.isDirectory()) {
                mtime = Math.max(mtime, ClassPathUtil.lastModified(path));
            } else if (path.getName().endsWith(".jar") || path.getName().endsWith(".JAR")) {
                mtime = Math.max(mtime, path.lastModified());
            }
            ++n2;
        }
        return mtime;
    }
}

