/*
 * Decompiled with CFR 0.152.
 */
package org.piax.util;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.WeakHashMap;

public class ClassUtil {
    private static WeakHashMap<SubIfsKey, Class<?>[]> cashe = new WeakHashMap();

    public static boolean isSub(Class<?> clazz1, Class<?> clazz2) {
        return clazz2.isAssignableFrom(clazz1);
    }

    private static void addIf(List<Class<?>> pool, Class<?> interfaze) {
        ListIterator<Class<?>> it = pool.listIterator();
        while (it.hasNext()) {
            Class<?> cur = it.next();
            if (ClassUtil.isSub(cur, interfaze)) {
                return;
            }
            if (!ClassUtil.isSub(interfaze, cur)) continue;
            it.remove();
        }
        it.add(interfaze);
    }

    private static <I> void gatherSubIfs0(Class<I> clazz, Class<?> superIf, List<Class<?>> pool) {
        Class<?>[] ifs;
        if (clazz.isInterface()) {
            ClassUtil.addIf(pool, clazz);
        }
        Class<?>[] classArray = ifs = clazz.getInterfaces();
        int n = ifs.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> interfaze = classArray[n2];
            if (ClassUtil.isSub(interfaze, superIf)) {
                ClassUtil.addIf(pool, interfaze);
            }
            ++n2;
        }
        Class<I> superc = clazz.getSuperclass();
        if (superc != null) {
            ClassUtil.gatherSubIfs0(superc, superIf, pool);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> Class<?>[] gatherLowerBoundSuperInterfaces(Class<T> clazz, Class<?> superIf) {
        Class<?>[] result;
        assert (clazz != null);
        assert (superIf != null);
        if (!superIf.isInterface()) {
            throw new IllegalArgumentException("superIf is not Interface");
        }
        SubIfsKey key = new SubIfsKey(clazz, superIf);
        WeakHashMap<SubIfsKey, Class<?>[]> weakHashMap = cashe;
        synchronized (weakHashMap) {
            result = cashe.get(key);
            if (result == null) {
                ArrayList pool = new ArrayList();
                ClassUtil.gatherSubIfs0(clazz, superIf, pool);
                result = new Class[pool.size()];
                pool.toArray(result);
                cashe.put(key, result);
            }
        }
        return result;
    }

    private static class SubIfsKey {
        final Class<?> clazz;
        final Class<?> superIf;

        SubIfsKey(Class<?> clazz, Class<?> superIf) {
            this.clazz = clazz;
            this.superIf = superIf;
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof SubIfsKey)) {
                return false;
            }
            SubIfsKey mkey = (SubIfsKey)o;
            return this.clazz == mkey.clazz && this.superIf == mkey.superIf;
        }

        public int hashCode() {
            return this.clazz.hashCode() ^ (this.superIf == null ? 0 : this.superIf.hashCode());
        }
    }
}

