/*
 * Decompiled with CFR 0.152.
 */
package org.piax.common;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Random;
import org.piax.util.ByteUtil;
import org.piax.util.RandomUtil;

public class Id
implements Serializable,
Comparable<Id> {
    private static final long serialVersionUID = 1L;
    private static Random rand = null;
    protected final byte[] bytes;
    protected transient String strVal;
    transient int hash;

    protected static byte[] newRandomBytes(int len) {
        if (rand == null) {
            rand = RandomUtil.newCollisionlessRandom();
        }
        return RandomUtil.newBytes(len, rand);
    }

    public static Id newId(int len) {
        return new Id(Id.newRandomBytes(len));
    }

    public Id(byte[] bytes) {
        if (bytes == null) {
            throw new IllegalArgumentException("arg should not be null");
        }
        this.strVal = null;
        this.bytes = bytes;
    }

    public Id(String str) throws IllegalArgumentException {
        if (str == null) {
            throw new IllegalArgumentException("arg should not be null");
        }
        this.strVal = str;
        byte[] b = null;
        try {
            b = str.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        if (!ByteUtil.isASCII(b)) {
            throw new IllegalArgumentException("str should be ASCII");
        }
        this.bytes = b;
    }

    public byte[] getBytes() {
        return Arrays.copyOf(this.bytes, this.bytes.length);
    }

    public byte[] _getBytes() {
        return this.bytes;
    }

    public int getByteLen() {
        return this.bytes.length;
    }

    public void setBinaryString() {
        this.strVal = ByteUtil.bytes2Binary(this.bytes);
    }

    public void setHexString() {
        this.strVal = ByteUtil.bytes2Hex(this.bytes);
    }

    public boolean testBit(int ix) {
        return ByteUtil.testBit(this.bytes, ix);
    }

    public int commonPostfixLen(Id id) {
        return ByteUtil.commonPostfixLen(this.bytes, id.bytes);
    }

    public int commonPrefixLen(Id id) {
        return ByteUtil.commonPrefixLen(this.bytes, id.bytes);
    }

    public int hashCode() {
        if (this.hash == 0) {
            this.hash = Arrays.hashCode(this.bytes);
        }
        return this.hash;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !(o instanceof Id)) {
            return false;
        }
        if (this.hashCode() != o.hashCode()) {
            return false;
        }
        Id id = (Id)o;
        return Arrays.equals(this.bytes, id.bytes);
    }

    @Override
    public int compareTo(Id id) {
        if (id == null) {
            throw new IllegalArgumentException();
        }
        return ByteUtil.compare(this.bytes, id.bytes);
    }

    public String toBinaryString() {
        return ByteUtil.bytes2Binary(this.bytes);
    }

    public String toHexString() {
        return ByteUtil.bytes2Hex(this.bytes);
    }

    public String toString() {
        if (this.strVal != null) {
            return this.strVal;
        }
        if (ByteUtil.isASCII(this.bytes)) {
            this.strVal = ByteUtil.dumpBytes(this.bytes);
            return this.strVal;
        }
        return this.toHexString();
    }
}

