/*
 * Decompiled with CFR 0.152.
 */
package org.piax.common;

import java.awt.geom.Point2D;
import org.piax.common.Key;

public class Location
extends Point2D
implements Key {
    private static final long serialVersionUID = 1L;
    private static final Location UNDEF_LOC = new Location();
    private double x = Double.NaN;
    private double y = Double.NaN;

    public static Location getUndef() {
        return UNDEF_LOC;
    }

    public static Location getLocation(String exp) {
        if (exp == null) {
            return null;
        }
        if (exp.equals("<undef>")) {
            return UNDEF_LOC;
        }
        try {
            String[] xy = exp.substring(1, exp.length() - 1).split(",");
            return new Location(Double.parseDouble(xy[0]), Double.parseDouble(xy[1]));
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    private Location() {
    }

    public Location(double x, double y) throws IllegalArgumentException {
        this.setLocation(x, y);
    }

    public boolean isUNDEF() {
        return Double.isNaN(this.x) || Double.isNaN(this.y);
    }

    @Override
    public void setLocation(double x, double y) throws IllegalArgumentException, UnsupportedOperationException {
        if (this == UNDEF_LOC) {
            throw new UnsupportedOperationException();
        }
        if (x < -180.0 || 180.0 < x || y < -90.0 || 90.0 < y) {
            throw new IllegalArgumentException("Illegal geographical coordinates: (" + x + ", " + y + ")");
        }
        this.x = x;
        this.y = y;
    }

    public double getLatitude() {
        return this.getY();
    }

    public double getLongitude() {
        return this.getX();
    }

    @Override
    public double getX() {
        return this.x;
    }

    @Override
    public double getY() {
        return this.y;
    }

    public String toString() {
        if (this.isUNDEF()) {
            return "<undef>";
        }
        return String.format("(%.2f,%.2f)", this.x, this.y);
    }
}

