/*
 * Decompiled with CFR 0.152.
 */
package org.piax.common.attribs;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.piax.common.Destination;
import org.piax.common.Id;
import org.piax.common.Key;
import org.piax.common.ObjectId;
import org.piax.common.PeerId;
import org.piax.common.TransportIdPath;
import org.piax.common.attribs.Attribute;
import org.piax.common.attribs.IncompatibleTypeException;
import org.piax.common.attribs.RowData;
import org.piax.common.dcl.VarDestinationPair;
import org.piax.gtrans.IdConflictException;
import org.piax.gtrans.ov.NoSuchOverlayException;
import org.piax.gtrans.ov.Overlay;

public class AttributeTable {
    public final PeerId peerId;
    public final ObjectId tableId;
    public RowData superRow = null;
    public Object superRowLock = new Object();
    final Map<String, Attribute> attribs = new LinkedHashMap<String, Attribute>();
    final Map<Id, RowData> rows = new LinkedHashMap<Id, RowData>();

    public AttributeTable(PeerId peerId, ObjectId tableId) {
        this.peerId = peerId;
        this.tableId = tableId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Map<Object, Object> map = this.rows;
        synchronized (map) {
            this.rows.clear();
        }
        map = this.attribs;
        synchronized (map) {
            for (Attribute attrib : this.attribs.values()) {
                attrib.clear();
            }
            this.attribs.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Attribute newAttribIfAbsent(String attribName) {
        Map<String, Attribute> map = this.attribs;
        synchronized (map) {
            Attribute attrib = this.attribs.get(attribName);
            if (attrib == null) {
                attrib = new Attribute(this, attribName);
                this.attribs.put(attribName, attrib);
            }
            return attrib;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Attribute getAttrib(String attribName) {
        Map<String, Attribute> map = this.attribs;
        synchronized (map) {
            return this.attribs.get(attribName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getDeclaredAttribNames() {
        Map<String, Attribute> map = this.attribs;
        synchronized (map) {
            return new ArrayList<String>(this.attribs.keySet());
        }
    }

    public void declareAttrib(String attribName) throws IllegalStateException {
        Attribute attrib = this.newAttribIfAbsent(attribName);
        if (attrib.isIndexable()) {
            throw new IllegalStateException("attrib already typed");
        }
    }

    public void declareAttrib(String attribName, Class<?> type) throws IllegalStateException {
        Attribute attrib = this.newAttribIfAbsent(attribName);
        attrib.setType(type);
    }

    public void bindOverlay(String attribName, TransportIdPath suffix) throws IllegalArgumentException, NoSuchOverlayException, IncompatibleTypeException {
        Attribute attrib = this.getAttrib(attribName);
        if (attrib == null) {
            throw new IllegalArgumentException("attrib not found");
        }
        attrib.bindOverlay(suffix);
    }

    public void unbindOverlay(String attribName) throws IllegalArgumentException, IllegalStateException {
        Attribute attrib = this.getAttrib(attribName);
        if (attrib == null) {
            throw new IllegalArgumentException("attrib not found");
        }
        attrib.unbindOverlay();
    }

    public Overlay<Destination, Key> getBindOverlay(String attribName) throws IllegalArgumentException {
        Attribute attrib = this.getAttrib(attribName);
        if (attrib == null) {
            throw new IllegalArgumentException("attrib not found");
        }
        return attrib.getBindOverlay();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<RowData> getMatchedRows(String attribName, Object value) throws IllegalArgumentException, IllegalStateException {
        HashSet<RowData> mrows = new HashSet<RowData>();
        Object object = this.superRowLock;
        synchronized (object) {
            if (this.superRow != null && value.equals(this.superRow.getAttribValue(attribName))) {
                for (RowData r : this.rows.values()) {
                    Object v;
                    if (r == this.superRow || (v = r.getAttribValue(attribName)) != null && !value.equals(v)) continue;
                    mrows.add(r);
                }
                return mrows;
            }
        }
        Attribute attrib = this.getAttrib(attribName);
        if (attrib == null) {
            throw new IllegalArgumentException("attrib not found");
        }
        mrows.addAll(attrib.getMatchedRows(value));
        return mrows;
    }

    public boolean satisfies(RowData row, List<VarDestinationPair> conds) {
        if (conds == null || conds.size() == 0) {
            return true;
        }
        return row.satisfies(conds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RowData setSuperRow(Id rowId) throws IdConflictException {
        Object object = this.superRowLock;
        synchronized (object) {
            RowData srow = this.newRow(rowId);
            if (this.superRow != null) {
                throw new IdConflictException();
            }
            this.superRow = srow;
            return this.superRow;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsetSuperRow() {
        Object object = this.superRowLock;
        synchronized (object) {
            this.superRow = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RowData newRow(Id rowId) throws IdConflictException {
        Map<Id, RowData> map = this.rows;
        synchronized (map) {
            if (this.rows.get(rowId) != null) {
                throw new IdConflictException();
            }
            RowData row = new RowData(this, rowId, true);
            this.rows.put(rowId, row);
            return row;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertRow(RowData row) throws IllegalStateException, IdConflictException {
        Map<Id, RowData> map = this.rows;
        synchronized (map) {
            if (row.isBoundToAttribute) {
                throw new IllegalStateException("row should be unbound");
            }
            if (this.rows.get(row.rowId) != null) {
                throw new IdConflictException();
            }
            this.rows.put(row.rowId, row);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RowData removeRow(Id rowId) {
        Id id = rowId;
        synchronized (id) {
            RowData row = this.rows.remove(rowId);
            row.unbindToAttribute();
            return row;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RowData getRow(Id rowId) {
        Map<Id, RowData> map = this.rows;
        synchronized (map) {
            return this.rows.get(rowId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RowData> getRows() {
        Map<Id, RowData> map = this.rows;
        synchronized (map) {
            return new ArrayList<RowData>(this.rows.values());
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("AttributeTable [peerId=" + this.peerId + ", tableName=" + this.tableId + "]:\n");
        sb.append("rowId");
        for (String attrib : this.getDeclaredAttribNames()) {
            sb.append(", " + attrib);
        }
        sb.append("\n");
        for (RowData row : this.getRows()) {
            sb.append(row.rowId);
            for (Object val : row.getAttribValues()) {
                sb.append(", " + val);
            }
            sb.append("\n");
        }
        return sb.toString();
    }
}

