/*
 * Decompiled with CFR 0.152.
 */
package org.piax.common.attribs;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.piax.common.ComparableKey;
import org.piax.common.Id;
import org.piax.common.Key;
import org.piax.common.attribs.Attribute;
import org.piax.common.attribs.AttributeTable;
import org.piax.common.attribs.IncompatibleTypeException;
import org.piax.common.dcl.VarDestinationPair;
import org.piax.common.subspace.KeyContainable;
import org.piax.common.wrapper.Keys;
import org.piax.common.wrapper.WrappedComparableKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RowData
implements Key {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(RowData.class);
    protected transient AttributeTable table;
    public Id rowId;
    private final Map<String, ValueEntry> values = new LinkedHashMap<String, ValueEntry>();
    protected boolean isBoundToAttribute;

    protected RowData(AttributeTable table, Id rowId, boolean isBoundToAttribute) {
        this.table = table;
        this.rowId = rowId;
        this.isBoundToAttribute = isBoundToAttribute;
    }

    public synchronized void fin() {
        this.unbindToAttribute();
        this.values.clear();
    }

    public synchronized boolean isBoundToAttribute() {
        return this.isBoundToAttribute;
    }

    public synchronized boolean bindToAttribute() {
        if (this.isBoundToAttribute) {
            return false;
        }
        for (Map.Entry<String, ValueEntry> ent : this.values.entrySet()) {
            Attribute attrib = this.table.getAttrib(ent.getKey());
            if (attrib == null) {
                logger.error("inconsistent status: \"" + ent.getKey() + "\" attribute not found");
                continue;
            }
            if (ent.getValue().indexed) {
                try {
                    attrib.indexingValue(ent.getValue().value, this);
                }
                catch (IllegalStateException e) {
                    logger.error("", (Throwable)e);
                }
                catch (IncompatibleTypeException e) {
                    logger.error("", (Throwable)e);
                }
                continue;
            }
            attrib.ref();
        }
        this.isBoundToAttribute = true;
        return true;
    }

    public synchronized boolean unbindToAttribute() {
        if (!this.isBoundToAttribute) {
            return false;
        }
        for (Map.Entry<String, ValueEntry> ent : this.values.entrySet()) {
            Attribute attrib = this.table.getAttrib(ent.getKey());
            if (attrib == null) {
                logger.error("inconsistent status: \"" + ent.getKey() + "\" attribute not found");
                continue;
            }
            if (ent.getValue().indexed) {
                try {
                    boolean ok = attrib.unindexingValue(ent.getValue().value, this);
                    if (ok) continue;
                    logger.error("inconsistent status: indexed value of \"" + ent.getKey() + "\" is not indexed");
                }
                catch (IllegalStateException e) {
                    logger.error("", (Throwable)e);
                }
                continue;
            }
            attrib.unref();
        }
        this.isBoundToAttribute = false;
        return true;
    }

    public boolean setAttrib(String name, Object value) throws IllegalArgumentException, IncompatibleTypeException {
        return this.setAttrib(name, value, true);
    }

    public synchronized boolean setAttrib(String name, Object value, boolean useIndex) throws IllegalArgumentException, IncompatibleTypeException {
        if (name == null || value == null) {
            throw new IllegalArgumentException("name and value should not be null");
        }
        if (value instanceof WrappedComparableKey) {
            throw new IllegalArgumentException("value should not be WrappedComparableKey type");
        }
        if (this.values.containsKey(name)) {
            this.removeAttrib(name);
        }
        Attribute attrib = this.table.newAttribIfAbsent(name);
        if (useIndex && attrib.isIndexable()) {
            if (this.isBoundToAttribute) {
                attrib.indexingValue(value, this);
            } else if (!attrib.isAssignable(value)) {
                throw new IncompatibleTypeException(value.getClass().getName() + " not assignable");
            }
            this.values.put(name, new ValueEntry(value, true));
            return true;
        }
        if (this.isBoundToAttribute) {
            attrib.ref();
        }
        this.values.put(name, new ValueEntry(value, false));
        return false;
    }

    public synchronized boolean removeAttrib(String name) throws IllegalStateException {
        block7: {
            ValueEntry vEnt = this.values.get(name);
            if (vEnt == null) {
                return false;
            }
            Attribute attrib = this.table.getAttrib(name);
            if (attrib == null) {
                throw new IllegalStateException("inconsistent status: \"" + name + "\" is zombi attribute?");
            }
            if (this.isBoundToAttribute) {
                if (vEnt.indexed) {
                    try {
                        boolean ok = attrib.unindexingValue(vEnt.value, this);
                        if (!ok) {
                            throw new IllegalStateException("inconsistent status: indexed value of \"" + name + "\" is not indexed");
                        }
                        break block7;
                    }
                    catch (IllegalStateException e) {
                        throw new IllegalStateException("inconsistent status: \"" + name + "\" is now type undefined");
                    }
                }
                attrib.unref();
            }
        }
        this.values.remove(name);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Object getAttribValue(String attribName) {
        ValueEntry vEnt = this.values.get(attribName);
        Object val = vEnt == null ? null : vEnt.value;
        Object object = this.table.superRowLock;
        synchronized (object) {
            if (val == null && this.table.superRow != null && this.table.superRow != this) {
                val = this.table.superRow.getAttribValue(attribName);
            }
        }
        return val;
    }

    public synchronized List<Object> getAttribValues() {
        ArrayList<Object> vals = new ArrayList<Object>();
        for (ValueEntry vEnt : this.values.values()) {
            vals.add(vEnt.value);
        }
        return vals;
    }

    public synchronized boolean isIndexed(String attribName) throws IllegalArgumentException {
        ValueEntry vEnt = this.values.get(attribName);
        if (vEnt == null) {
            throw new IllegalArgumentException("attrib not found");
        }
        return vEnt.indexed;
    }

    public synchronized List<String> getAttribNames() {
        return new ArrayList<String>(this.values.keySet());
    }

    public synchronized List<String> getIndexedAttribNames() {
        ArrayList<String> list = new ArrayList<String>();
        for (Map.Entry<String, ValueEntry> ent : this.values.entrySet()) {
            if (!ent.getValue().indexed) continue;
            list.add(ent.getKey());
        }
        return list;
    }

    public synchronized List<String> getUnindexedAttribNames() {
        ArrayList<String> list = new ArrayList<String>();
        for (Map.Entry<String, ValueEntry> ent : this.values.entrySet()) {
            if (ent.getValue().indexed) continue;
            list.add(ent.getKey());
        }
        return list;
    }

    public synchronized boolean satisfies(List<VarDestinationPair> conds) {
        for (VarDestinationPair pair : conds) {
            Object value = this.getAttribValue(pair.var);
            if (value == null) {
                return false;
            }
            Key _value = null;
            if (value instanceof ComparableKey) {
                _value = (WrappedComparableKey<Comparable>)value;
            } else if (value instanceof Comparable) {
                _value = Keys.newWrappedKey((Comparable)value);
            } else if (value instanceof Key) {
                _value = (Key)value;
            } else {
                logger.warn("{} type of value is not supperted in current DCL", (Object)value.getClass().getName());
                return false;
            }
            if (pair.destination instanceof Key) {
                return pair.destination.equals(_value);
            }
            if (pair.destination instanceof KeyContainable) {
                KeyContainable container = (KeyContainable)pair.destination;
                if (container.contains(_value)) continue;
                return false;
            }
            logger.warn("{} type of destination is not supperted in current DCL", (Object)pair.destination.getClass().getName());
            return false;
        }
        return true;
    }

    public synchronized String toString() {
        return "RowData [rowId=" + this.rowId + ", values=" + this.values + ", isBoundToAttribute=" + this.isBoundToAttribute + "]";
    }

    static class ValueEntry
    implements Serializable {
        private static final long serialVersionUID = 1L;
        final Object value;
        boolean indexed;

        ValueEntry(Object value, boolean indexed) {
            this.value = value;
            this.indexed = indexed;
        }

        public String toString() {
            return this.value + (this.indexed ? " (indexed)" : "");
        }
    }
}

