/*
 * Decompiled with CFR 0.152.
 */
package org.piax.common.dcl;

import java.awt.geom.Point2D;
import java.util.List;
import org.piax.common.ComparableKey;
import org.piax.common.Destination;
import org.piax.common.Location;
import org.piax.common.dcl.DCLFactory;
import org.piax.common.dcl.DCLParseException;
import org.piax.common.subspace.GeoRegion;
import org.piax.common.subspace.KeyRange;
import org.piax.common.subspace.KeyRanges;
import org.piax.common.subspace.Lower;
import org.piax.common.subspace.Near;
import org.piax.common.subspace.Upper;
import org.piax.common.wrapper.Keys;

public class DestinationFactory
implements DCLFactory {
    String op;
    Destination destination;

    DestinationFactory() {
    }

    void setOp(String op) {
        this.op = op;
    }

    Destination convert(Object element) {
        if (element instanceof GeoRegion) {
            return (GeoRegion)element;
        }
        if (element instanceof Near) {
            return (Near)element;
        }
        if (element instanceof Point2D.Double) {
            Point2D.Double ele = (Point2D.Double)element;
            return new Location(ele.x, ele.y);
        }
        if (element instanceof KeyRange) {
            return (KeyRange)element;
        }
        if (element instanceof Lower) {
            return (Lower)element;
        }
        if (element instanceof Upper) {
            return (Upper)element;
        }
        if (element instanceof List) {
            KeyRanges ranges = new KeyRanges((List)element);
            return ranges;
        }
        if (element instanceof ComparableKey) {
            return (ComparableKey)element;
        }
        if (element instanceof Comparable) {
            return Keys.newWrappedKey((Comparable)element);
        }
        throw new DCLParseException(element.getClass().getSimpleName() + " is not supported as Subset in this version");
    }

    @Override
    public void add(Object element) {
        this.destination = this.convert(element);
    }

    @Override
    public Object getDstCond() {
        return this.destination;
    }
}

