/*
 * Decompiled with CFR 0.152.
 */
package org.piax.common.subspace;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.piax.common.subspace.Range;
import org.piax.gtrans.ov.ddll.Node;

public class CircularRange<K extends Comparable<?>>
extends Range<K> {
    public CircularRange(K from, K to) {
        this(from, true, to, true);
    }

    public CircularRange(K key) {
        this(key, true, key, true);
    }

    public CircularRange(K from, boolean fromInclusive, K to, boolean toInclusive) {
        super(false, from, fromInclusive, to, toInclusive);
    }

    protected CircularRange<K> newInstance(K from, boolean fromInclusive, K to, boolean toInclusive) {
        return new CircularRange<K>(from, fromInclusive, to, toInclusive);
    }

    public CircularRange<K>[] split(K k) {
        if (keyComp.compare(this.from, (Comparable<?>)k) < 0 && keyComp.compare((Comparable<?>)k, this.to) < 0) {
            CircularRange<Comparable> left = this.newInstance(this.from, this.fromInclusive, k, false);
            CircularRange<Comparable> right = this.newInstance(k, true, this.to, this.toInclusive);
            return new CircularRange[]{left, right};
        }
        return new CircularRange[]{this};
    }

    public List<CircularRange<K>> retain(Range<K> r, List<? super Range<K>> intersect) {
        if (r.contains(this)) {
            if (intersect != null) {
                intersect.add(this);
            }
            return null;
        }
        if (this.isWhole()) {
            if (intersect != null) {
                intersect.add(r);
            }
            return Collections.singletonList(new CircularRange(r.to, !r.toInclusive, r.from, !r.fromInclusive));
        }
        if (this.contains((Comparable<?>)r.from) && !this.contains((Comparable<?>)r.to)) {
            this.addIfValidRange(intersect, r.from, r.fromInclusive, this.to, this.toInclusive);
            return Collections.singletonList(new CircularRange<Comparable>(this.from, this.fromInclusive, (Comparable)r.from, !r.fromInclusive));
        }
        if (!this.contains((Comparable<?>)r.from) && this.contains((Comparable<?>)r.to)) {
            this.addIfValidRange(intersect, this.from, this.fromInclusive, r.to, r.toInclusive);
            return Collections.singletonList(new CircularRange<Comparable>((Comparable)r.to, !r.toInclusive, this.to, this.toInclusive));
        }
        if (this.contains((Comparable<?>)r.from) && this.contains((Comparable<?>)r.to)) {
            if (Node.isOrdered(r.from, this.to, r.to) && !r.isSingleton() && keyComp.compare(this.to, (Comparable<?>)r.to) != 0) {
                ArrayList<CircularRange<K>> tmp = new ArrayList<CircularRange<K>>();
                this.addIfValidRange(tmp, this.from, this.fromInclusive, r.to, r.toInclusive);
                this.addIfValidRange(tmp, r.from, r.fromInclusive, this.to, this.toInclusive);
                CircularRange.merge2(tmp);
                if (intersect != null) {
                    intersect.addAll(tmp);
                }
                return Collections.singletonList(new CircularRange(r.to, !r.toInclusive, r.from, !r.fromInclusive));
            }
            if (intersect != null) {
                intersect.add(r);
            }
            ArrayList<CircularRange<K>> retain = new ArrayList<CircularRange<K>>();
            if (keyComp.compare(this.from, (Comparable<?>)r.from) != 0) {
                CircularRange<Comparable> r1 = new CircularRange<Comparable>(this.from, this.fromInclusive, (Comparable)r.from, !r.fromInclusive);
                retain.add(r1);
            }
            if (keyComp.compare((Comparable<?>)r.to, this.to) != 0) {
                CircularRange<Comparable> r2 = new CircularRange<Comparable>((Comparable)r.to, !r.toInclusive, this.to, this.toInclusive);
                retain.add(r2);
            }
            CircularRange.merge2(retain);
            return retain;
        }
        return Collections.singletonList(this);
    }

    private void addIfValidRange(List<? super CircularRange<K>> intersect, K from, boolean fromInclusive, K to, boolean toInclusive) {
        boolean valid;
        if (intersect == null) {
            return;
        }
        boolean bl = valid = keyComp.compare((Comparable<?>)from, (Comparable<?>)to) != 0 || fromInclusive && toInclusive;
        if (valid) {
            intersect.add(new CircularRange<K>(from, fromInclusive, to, toInclusive));
        }
    }

    public boolean isFollowedBy(CircularRange<K> another) {
        return keyComp.compare(this.to, another.from) == 0 && this.toInclusive ^ another.fromInclusive;
    }

    public CircularRange<K> concatenate(CircularRange<K> another) {
        if (this.isFollowedBy(another)) {
            CircularRange<Comparable> r = new CircularRange<Comparable>(this.from, this.fromInclusive, another.to, another.toInclusive);
            return r;
        }
        throw new IllegalArgumentException(this + " and " + another + "is not adjcent");
    }

    private static <K extends Comparable<?>> void merge2(List<CircularRange<K>> ranges) {
        if (ranges.size() <= 1) {
            return;
        }
        assert (ranges.size() == 2);
        CircularRange<K> r1 = ranges.get(0);
        CircularRange<K> r2 = ranges.get(1);
        if (r2.isFollowedBy(r1)) {
            CircularRange<K> r = r2.concatenate(r1);
            ranges.clear();
            ranges.add(r);
        }
    }
}

