/*
 * Decompiled with CFR 0.152.
 */
package org.piax.common.subspace;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.piax.common.Location;
import org.piax.common.subspace.GeoEllipse;

public class GeoCircle
extends GeoEllipse {
    private static final long serialVersionUID = 1L;

    public GeoCircle(double x, double y, double radius) throws IllegalArgumentException {
        super(x - radius, y - radius, radius * 2.0, radius * 2.0);
    }

    public GeoCircle(Point2D center, double radius) throws IllegalArgumentException {
        this(center.getX(), center.getY(), radius);
    }

    public void setCircle(double x, double y, double radius) throws IllegalArgumentException {
        this.setFrame(x - radius, y - radius, radius * 2.0, radius * 2.0);
    }

    public void setCircle(Location center, double radius) throws IllegalArgumentException {
        this.setFrame(center.getX() - radius, center.getY() - radius, radius * 2.0, radius * 2.0);
    }

    public double getRadius() {
        return this.getWidth() / 2.0;
    }

    public Location getCenter() {
        return new Location(this.getCenterX(), this.getCenterY());
    }

    @Override
    public double getCenterX() {
        return this.getX() + this.getWidth() / 2.0;
    }

    @Override
    public double getCenterY() {
        return this.getY() + this.getHeight() / 2.0;
    }

    @Override
    public String toString() {
        return "circle(" + this.getCenterX() + ", " + this.getCenterY() + ", " + this.getRadius() + ")";
    }

    public static void main(String[] args) throws Exception {
        GeoCircle c = new GeoCircle(0.0, 0.0, 1.0);
        System.out.println(c);
        Rectangle2D r = c.getBounds2D();
        System.out.println(r);
        Location loc = new Location(0.0, 0.0);
        System.out.println(c.contains(loc));
    }
}

