/*
 * Decompiled with CFR 0.152.
 */
package org.piax.common.subspace;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.piax.common.Location;
import org.piax.common.subspace.GeoRegion;

public class GeoRectangle
extends Rectangle2D
implements GeoRegion {
    private static final long serialVersionUID = 1L;
    private double x = 0.0;
    private double y = 0.0;
    private double width = 0.0;
    private double height = 0.0;

    static boolean checkXY(double x, double y, double w, double h) {
        return -90.0 <= y && 0.0 <= h && y + h <= 90.0 && -180.0 <= x && x <= 180.0 && 0.0 <= w && w <= 360.0;
    }

    static double normalize(double newCenter, double x) {
        if (newCenter <= 0.0) {
            if (newCenter + 180.0 < x) {
                return x - 360.0;
            }
        } else if (x < newCenter - 180.0) {
            return x + 360.0;
        }
        return x;
    }

    static double normalize(double newCenter, double x, double w) {
        if (newCenter < 0.0) {
            if (newCenter + 180.0 < x + w / 2.0) {
                return x - 360.0;
            }
        } else if (x + w / 2.0 < newCenter - 180.0) {
            return x + 360.0;
        }
        return x;
    }

    public GeoRectangle() {
    }

    public GeoRectangle(double x, double y, double width, double height) throws IllegalArgumentException {
        this.setRect(x, y, width, height);
    }

    public GeoRectangle(Point2D origin, double width, double height) throws IllegalArgumentException {
        this.setRect(origin, width, height);
    }

    public double getLatitude() {
        return this.getY();
    }

    public double getLongitude() {
        return this.getX();
    }

    @Override
    public double getX() {
        return this.x;
    }

    @Override
    public double getY() {
        return this.y;
    }

    @Override
    public double getWidth() {
        return this.width;
    }

    @Override
    public double getHeight() {
        return this.height;
    }

    @Override
    public boolean isEmpty() {
        return this.width < 0.0 || this.height < 0.0;
    }

    @Override
    public void setRect(double x, double y, double width, double height) throws IllegalArgumentException {
        if (!GeoRectangle.checkXY(x, y, width, height)) {
            throw new IllegalArgumentException("Illegal geographical parameters: (" + x + ", " + y + ", " + width + ", " + height + ")");
        }
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public void setRect(Point2D origin, double width, double height) throws IllegalArgumentException {
        this.setRect(origin.getX(), origin.getY(), width, height);
    }

    @Override
    public int outcode(double x, double y) {
        double xx = GeoRectangle.normalize(this.x + this.width / 2.0, x);
        int out = 0;
        if (this.width <= 0.0) {
            out |= 5;
        } else if (xx < this.x) {
            out |= 1;
        } else if (xx > this.x + this.width) {
            out |= 4;
        }
        if (this.height <= 0.0) {
            out |= 0xA;
        } else if (y < this.y) {
            out |= 8;
        } else if (y > this.y + this.height) {
            out |= 2;
        }
        return out;
    }

    @Override
    public void add(double x, double y) {
        double xx = GeoRectangle.normalize(this.x + this.width / 2.0, x);
        double x1 = Math.min(this.x, xx);
        double y1 = Math.min(this.y, y);
        double x2 = Math.max(this.x + this.width, xx);
        double y2 = Math.max(this.y + this.height, y);
        this.setRect(GeoRectangle.normalize(0.0, x1), y1, x2 - x1, y2 - y1);
    }

    @Override
    public void add(Rectangle2D r) {
        Rectangle2D rect = this.createUnion(r);
        this.setRect(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight());
    }

    @Override
    public Rectangle2D createIntersection(Rectangle2D r) {
        double x = r.getX();
        double y = r.getY();
        double w = r.getWidth();
        double h = r.getHeight();
        double xx = GeoRectangle.normalize(this.x + this.width / 2.0, x, w);
        if (!(xx + w >= this.x && y + h >= this.y && xx <= this.x + this.width && y <= this.y + this.height)) {
            return null;
        }
        double x1 = Math.max(this.x, xx);
        double y1 = Math.max(this.y, y);
        double x2 = Math.min(this.x + this.width, xx + w);
        double y2 = Math.min(this.y + this.height, y + h);
        return new GeoRectangle(GeoRectangle.normalize(0.0, x1), y1, x2 - x1, y2 - y1);
    }

    @Override
    public Rectangle2D createUnion(Rectangle2D r) {
        double x = r.getX();
        double y = r.getY();
        double w = r.getWidth();
        double h = r.getHeight();
        double xx = GeoRectangle.normalize(this.x + this.width / 2.0, x, w);
        double x1 = Math.min(this.x, xx);
        double y1 = Math.min(this.y, y);
        double x2 = Math.max(this.x + this.width, xx + w);
        double y2 = Math.max(this.y + this.height, y + h);
        double xx1 = GeoRectangle.normalize(0.0, x1);
        double ww = x2 - x1;
        if (ww >= 360.0) {
            xx1 = -180.0;
            ww = 360.0;
        }
        return new GeoRectangle(xx1, y1, ww, y2 - y1);
    }

    @Override
    public boolean contains(double x, double y) {
        double xx = GeoRectangle.normalize(this.x + this.width / 2.0, x);
        return xx >= this.x && y >= this.y && xx <= this.x + this.width && y <= this.y + this.height;
    }

    @Override
    public boolean contains(Location loc) {
        return this.contains(loc.getX(), loc.getY());
    }

    @Override
    public boolean contains(double x, double y, double w, double h) {
        double xx = GeoRectangle.normalize(this.x + this.width / 2.0, x, w);
        return xx >= this.x && y >= this.y && xx + w <= this.x + this.width && y + h <= this.y + this.height;
    }

    @Override
    public boolean intersects(double x, double y, double w, double h) {
        double xx = GeoRectangle.normalize(this.x + this.width / 2.0, x, w);
        return xx + w >= this.x && y + h >= this.y && xx <= this.x + this.width && y <= this.y + this.height;
    }

    public String toString() {
        return "rect(" + this.x + ", " + this.y + ", " + this.width + ", " + this.height + ")";
    }
}

