/*
 * Decompiled with CFR 0.152.
 */
package org.piax.common.subspace;

import java.io.Serializable;
import org.piax.gtrans.ov.ddll.Node;
import org.piax.util.KeyComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Range<K extends Comparable<?>>
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(Range.class);
    protected static final KeyComparator keyComp = KeyComparator.getInstance();
    public final K from;
    public final K to;
    public final boolean fromInclusive;
    public final boolean toInclusive;

    public Range(K from, K to) {
        this(from, true, to, true);
    }

    public Range(K key) {
        this(key, true, key, true);
    }

    public Range(K from, boolean fromInclusive, K to, boolean toInclusive) {
        this(true, from, fromInclusive, to, toInclusive);
    }

    protected Range(boolean checkArgs, K from, boolean fromInclusive, K to, boolean toInclusive) {
        if (checkArgs) {
            if (from == null || to == null) {
                throw new IllegalArgumentException("argument should not be null");
            }
            if (keyComp.compare((Comparable<?>)from, (Comparable<?>)to) > 0) {
                logger.warn("from:{} to:{}", from, to);
                throw new IllegalArgumentException("from > to");
            }
            if (!(keyComp.compare((Comparable<?>)from, (Comparable<?>)to) != 0 || fromInclusive && toInclusive)) {
                throw new IllegalArgumentException("invalied range, [x,x) or (x,x]");
            }
        }
        this.from = from;
        this.fromInclusive = fromInclusive;
        this.to = to;
        this.toInclusive = toInclusive;
    }

    public Range(char fromEdgeSpec, K from, K to, char toEdgeSpec) {
        this(from, fromEdgeSpec == '[', to, toEdgeSpec == ']');
        if (fromEdgeSpec != '[' && fromEdgeSpec != '(' || toEdgeSpec != ']' && toEdgeSpec != ')') {
            throw new IllegalArgumentException("invalid edge specifier");
        }
    }

    public boolean isSingleton() {
        return this.fromInclusive && this.toInclusive && keyComp.compare((Comparable<?>)this.from, (Comparable<?>)this.to) == 0;
    }

    public boolean isWhole() {
        return this.fromInclusive ^ this.toInclusive && keyComp.compare((Comparable<?>)this.from, (Comparable<?>)this.to) == 0;
    }

    public boolean contains(Comparable<?> key) {
        if (this.isWhole()) {
            return true;
        }
        if (this.isSingleton()) {
            return keyComp.compare((Comparable<?>)this.from, key) == 0;
        }
        boolean ret2 = !(!Node.isOrdered(this.from, key, this.to) || !this.fromInclusive && keyComp.compare((Comparable<?>)this.from, key) == 0 || !this.toInclusive && keyComp.compare(key, (Comparable<?>)this.to) == 0);
        logger.debug("\"{} contains {}:{}\" returns {}", new Object[]{this.toString2(), key, key.getClass().getSimpleName(), ret2});
        return ret2;
    }

    public boolean contains(Range<K> another) {
        boolean isRightIn;
        if (this.isWhole()) {
            return true;
        }
        if (another.isWhole()) {
            return false;
        }
        boolean isLeftIn = Node.isOrdered(this.from, another.from, this.to);
        if (isLeftIn && keyComp.compare((Comparable<?>)this.from, (Comparable<?>)another.from) == 0) {
            boolean bl = isLeftIn = this.fromInclusive || !another.fromInclusive;
        }
        if (isLeftIn && keyComp.compare((Comparable<?>)another.from, (Comparable<?>)this.to) == 0) {
            boolean bl = isLeftIn = this.toInclusive || !another.toInclusive;
        }
        if ((isRightIn = Node.isOrdered(this.from, another.to, this.to)) && keyComp.compare((Comparable<?>)this.to, (Comparable<?>)another.to) == 0) {
            boolean bl = isRightIn = this.toInclusive || !another.toInclusive;
        }
        if (isRightIn && keyComp.compare((Comparable<?>)another.to, (Comparable<?>)this.to) == 0) {
            boolean bl = isRightIn = this.toInclusive || !another.toInclusive;
        }
        if (isLeftIn && isRightIn) {
            if (another.isSingleton()) {
                return true;
            }
            return !Node.isOrdered(another.from, true, this.to, another.to, false);
        }
        return false;
    }

    public String toString() {
        return this.rangeString();
    }

    public String toString2() {
        String s1 = this.fromInclusive ? "[" : "(";
        String s2 = this.toInclusive ? "]" : ")";
        return String.format("%s%s:%s..%s:%s%s", s1, this.from, this.from.getClass().getSimpleName(), this.to, this.to.getClass().getSimpleName(), s2);
    }

    public String rangeString() {
        String s1 = this.fromInclusive ? "[" : "(";
        String s2 = this.toInclusive ? "]" : ")";
        return String.format("%s%s..%s%s", s1, this.from, this.to, s2);
    }

    public boolean isSameRange(Range<K> another) {
        return another.from.compareTo(this.from) == 0 && another.fromInclusive == this.fromInclusive && another.to.compareTo(this.to) == 0 && another.toInclusive == this.toInclusive;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.from == null ? 0 : this.from.hashCode());
        result = 31 * result + (this.fromInclusive ? 1231 : 1237);
        result = 31 * result + (this.to == null ? 0 : this.to.hashCode());
        result = 31 * result + (this.toInclusive ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Range other = (Range)obj;
        if (!this.from.equals(other.from)) {
            return false;
        }
        if (this.fromInclusive != other.fromInclusive) {
            return false;
        }
        if (!this.to.equals(other.to)) {
            return false;
        }
        return this.toInclusive == other.toInclusive;
    }

    public Range<K>[] split(K k) {
        if (keyComp.compare((Comparable<?>)this.from, (Comparable<?>)k) < 0 && keyComp.compare((Comparable<?>)k, (Comparable<?>)this.to) < 0) {
            Range<K> left = new Range<K>(this.from, this.fromInclusive, k, false);
            Range<K> right = new Range<K>(k, true, this.to, this.toInclusive);
            return new Range[]{left, right};
        }
        return new Range[]{this};
    }

    public Range<K> clone() {
        try {
            return (Range)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new Error(e);
        }
    }
}

