/*
 * Decompiled with CFR 0.152.
 */
package org.piax.common.wrapper;

import org.piax.common.ComparableKey;
import org.piax.common.ObjectId;

public abstract class NamedKey<K extends Comparable<?>>
implements ComparableKey<NamedKey<K>> {
    private static final long serialVersionUID = 1L;
    public final ObjectId name;
    public final K key;
    transient int hash;

    protected NamedKey(ObjectId name, K key) {
        if (name == null || key == null) {
            throw new IllegalArgumentException("should not be null");
        }
        this.name = name;
        this.key = key;
    }

    public int hashCode() {
        if (this.hash == 0) {
            this.hash = 31 * this.name.hashCode() + this.key.hashCode();
        }
        return this.hash;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        if (this.hashCode() != o.hashCode()) {
            return false;
        }
        NamedKey other = (NamedKey)o;
        if (!this.key.equals(other.key)) {
            return false;
        }
        return this.name.equals(other.name);
    }

    @Override
    public int compareTo(NamedKey<K> o) {
        if (this.name.equals(o.name)) {
            if (this.key.getClass() == o.key.getClass()) {
                K k = this.key;
                return k.compareTo(o.key);
            }
            return this.key.getClass().getName().compareTo(o.key.getClass().getName());
        }
        return this.name.compareTo(o.name);
    }

    public String toString() {
        return "NamedKey[name=" + this.name + ", key=" + this.key + "]";
    }
}

