/*
 * Decompiled with CFR 0.152.
 */
package org.piax.gtrans;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.piax.gtrans.GTransConfigValues;
import org.piax.gtrans.RemoteValue;

public class FutureQueue<E>
extends LinkedBlockingQueue<RemoteValue<E>>
implements BlockingQueue<RemoteValue<E>>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final RemoteValue<Object> eof = new RemoteValue(null);
    private int timeout = GTransConfigValues.futureQueueGetNextTimeout;
    private static FutureQueue<?> EMPTY = new FutureQueue(true);
    private volatile boolean isEmpty = false;
    private volatile boolean isReadOnly = false;

    public static <E> FutureQueue<E> emptyQueue() {
        return EMPTY;
    }

    public static <E> FutureQueue<E> singletonQueue(RemoteValue<E> rv) {
        FutureQueue<E> fq = new FutureQueue<E>();
        fq.add(rv);
        fq.setEOFuture();
        return fq;
    }

    private FutureQueue(boolean dummy) {
        this.isEmpty = true;
        this.isReadOnly = true;
    }

    public FutureQueue() {
    }

    public FutureQueue(Collection<? extends RemoteValue<E>> c) {
        super(c);
    }

    public FutureQueue(int capacity) {
        super(capacity);
    }

    public void cancel() {
    }

    public synchronized void setEOFuture() {
        if (this.isReadOnly) {
            return;
        }
        this.add(eof);
        this.isReadOnly = true;
    }

    public boolean isCompleted() {
        return this.isReadOnly;
    }

    public void setGetNextTimeout(int timeout) {
        this.timeout = timeout;
    }

    @Override
    public synchronized boolean add(RemoteValue<E> e) {
        if (this.isReadOnly) {
            throw new IllegalStateException("is read only");
        }
        boolean b = super.add(e);
        this.isEmpty = false;
        return b;
    }

    @Override
    public Iterator<RemoteValue<E>> iterator() {
        return new Itr();
    }

    public RemoteValue<?>[] getAll() {
        ArrayList<RemoteValue<E>> values = new ArrayList<RemoteValue<E>>();
        for (RemoteValue<E> v : this) {
            values.add(v);
        }
        return (RemoteValue[])values.toArray();
    }

    public Object[] getAllValues() {
        ArrayList<E> values = new ArrayList<E>();
        for (RemoteValue<E> v : this) {
            values.add(v.getValue());
        }
        return values.toArray();
    }

    private final class Itr
    implements Iterator<RemoteValue<E>> {
        private RemoteValue<E> ele;

        private Itr() {
        }

        @Override
        public boolean hasNext() {
            if (FutureQueue.this.isEmpty) {
                return false;
            }
            try {
                this.ele = (RemoteValue)FutureQueue.this.poll(FutureQueue.this.timeout, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            if (this.ele == null) {
                return false;
            }
            if (eof.equals(this.ele)) {
                while (FutureQueue.this.poll() != null) {
                }
                FutureQueue.this.isEmpty = true;
                return false;
            }
            return true;
        }

        @Override
        public RemoteValue<E> next() {
            return this.ele;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

