/*
 * Decompiled with CFR 0.152.
 */
package org.piax.gtrans;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.RejectedExecutionException;
import org.piax.common.ObjectId;
import org.piax.common.PeerId;
import org.piax.common.PeerLocator;
import org.piax.common.StatusRepo;
import org.piax.common.TransportId;
import org.piax.common.TransportIdPath;
import org.piax.gtrans.ChannelTransport;
import org.piax.gtrans.IdConflictException;
import org.piax.gtrans.RPCIf;
import org.piax.gtrans.Transport;
import org.piax.gtrans.impl.BaseTransportGenerator;
import org.piax.gtrans.impl.BaseTransportMgr;
import org.piax.gtrans.impl.IdResolver;
import org.piax.gtrans.impl.ReceiverThreadPool;
import org.piax.gtrans.impl.TransportImpl;
import org.piax.gtrans.raw.RawTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Peer {
    private static final Logger logger = LoggerFactory.getLogger(Peer.class);
    public static final String RAW = "RAW";
    public static final String WITH_FRAGMENTATION = "WITH_FRAGMENTATION";
    static final ConcurrentMap<PeerId, Peer> peers = new ConcurrentHashMap<PeerId, Peer>();
    final ConcurrentNavigableMap<TransportIdPath, Transport<?>> transports = new ConcurrentSkipListMap();
    final Set<TransportIdPath> baseOverlays = new CopyOnWriteArraySet<TransportIdPath>();
    final ConcurrentMap<ObjectId, RPCIf> rpcObjects = new ConcurrentHashMap<ObjectId, RPCIf>();
    final IdResolver idResolver;
    final BaseTransportMgr baseTransMgr;
    private StatusRepo repo = null;
    final ReceiverThreadPool threadPool;
    final PeerId peerId;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Peer getInstance(PeerId peerId) {
        ConcurrentMap<PeerId, Peer> concurrentMap = peers;
        synchronized (concurrentMap) {
            Peer peer = (Peer)peers.get(peerId);
            if (peer != null) {
                return peer;
            }
            peer = new Peer(peerId);
            peers.put(peerId, peer);
            return peer;
        }
    }

    protected Peer(PeerId peerId) {
        this.peerId = peerId;
        this.idResolver = new IdResolver(peerId);
        this.baseTransMgr = new BaseTransportMgr(this);
        this.threadPool = new ReceiverThreadPool();
        this.concatPeerId2ThreadName();
        logger.trace("EXIT:");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fin() {
        ConcurrentMap<PeerId, Peer> concurrentMap = peers;
        synchronized (concurrentMap) {
            for (Transport trans : this.transports.descendingMap().values()) {
                trans.fin();
            }
            if (this.transports.size() != 0) {
                // empty if block
            }
            if (this.repo != null) {
                this.repo.fin();
                this.repo = null;
            }
            if (peers.remove(this.peerId, this)) {
                this.threadPool.fin();
            }
        }
        logger.trace("EXIT:");
    }

    public PeerId getPeerId() {
        return this.peerId;
    }

    public StatusRepo getStatusRepo() throws IOException {
        if (this.repo != null) {
            return this.repo;
        }
        this.repo = new StatusRepo(this.peerId.toString());
        return this.repo;
    }

    public IdResolver getIdResolver() {
        return this.idResolver;
    }

    public BaseTransportMgr getBaseTransportMgr() {
        return this.baseTransMgr;
    }

    public void addBaseTransportGenerator(BaseTransportGenerator generator) {
        this.baseTransMgr.addBaseTransportGenerator(generator);
    }

    public void addFirstBaseTransportGenerator(BaseTransportGenerator generator) {
        this.baseTransMgr.addFirstBaseTransportGenerator(generator);
    }

    public <E extends PeerLocator> Transport<E> newBaseTransport(E locator) throws IOException, IdConflictException {
        return this.newBaseTransport(null, null, locator);
    }

    public <E extends PeerLocator> Transport<E> newBaseTransport(String desc, E locator) throws IOException, IdConflictException {
        return this.newBaseTransport(desc, null, locator);
    }

    public <E extends PeerLocator> Transport<E> newBaseTransport(String desc, TransportId transId, E locator) throws IOException, IdConflictException {
        return this.baseTransMgr.newBaseTransport(desc, transId, locator);
    }

    public <E extends PeerLocator> ChannelTransport<E> newBaseChannelTransport(E locator) throws IOException, IdConflictException {
        return this.newBaseChannelTransport(null, null, locator);
    }

    public <E extends PeerLocator> ChannelTransport<E> newBaseChannelTransport(String desc, E locator) throws IOException, IdConflictException {
        return this.newBaseChannelTransport(desc, null, locator);
    }

    public <E extends PeerLocator> ChannelTransport<E> newBaseChannelTransport(String desc, TransportId transId, E locator) throws IOException, IdConflictException {
        return this.baseTransMgr.newBaseChannelTransport(desc, transId, locator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerTransport(TransportIdPath transIdPath, Transport<?> trans) throws IdConflictException {
        ConcurrentNavigableMap<TransportIdPath, Transport<?>> concurrentNavigableMap = this.transports;
        synchronized (concurrentNavigableMap) {
            if (this.transports.get(transIdPath) != null) {
                throw new IdConflictException("This transport is already registered: " + transIdPath);
            }
            this.transports.put(transIdPath, trans);
        }
        logger.trace("EXIT:");
    }

    public boolean unregisterTransport(TransportIdPath transIdPath, Transport<?> trans) {
        logger.trace("EXIT:");
        return this.transports.remove(transIdPath, trans);
    }

    public List<Transport<?>> getAllTransports() {
        return new ArrayList(this.transports.values());
    }

    public Transport<?> getTransport(TransportIdPath transIdPath) {
        return (Transport)this.transports.get(transIdPath);
    }

    public List<Transport<?>> getMatchedTransport(TransportId ... suffix) {
        TransportIdPath _suffix = new TransportIdPath(suffix);
        return this.getMatchedTransport(_suffix);
    }

    public List<Transport<?>> getMatchedTransport(TransportIdPath suffix) {
        ArrayList trans = new ArrayList();
        for (Map.Entry ent : this.transports.entrySet()) {
            if (!((TransportIdPath)ent.getKey()).matches(suffix)) continue;
            trans.add((Transport<?>)ent.getValue());
        }
        return trans;
    }

    private static void addIndent(StringBuilder sb, int n) {
        for (int i = 0; i < n; ++i) {
            sb.append(' ');
        }
    }

    private void genTransportTree(int level, List<TransportTreeNode> list, TransportImpl<?> tr) {
        list.add(new TransportTreeNode(level, tr));
        for (TransportImpl<?> upper : tr.getUppers()) {
            this.genTransportTree(level + 1, list, upper);
        }
    }

    public List<TransportTreeNode> genTransportTree() {
        ArrayList<TransportTreeNode> list = new ArrayList<TransportTreeNode>();
        for (Transport<?> tr : this.getAllTransports()) {
            if (tr.getLowerTransport() != null && !(tr.getLowerTransport() instanceof RawTransport)) continue;
            logger.debug("base tr:{}", tr);
            if (!(tr instanceof TransportImpl)) {
                logger.info("{} should be instance of TransportImpl", tr);
                continue;
            }
            this.genTransportTree(0, list, (TransportImpl)tr);
        }
        return list;
    }

    public String printTransportTree() {
        StringBuilder sb = new StringBuilder();
        for (TransportTreeNode nd : this.genTransportTree()) {
            Peer.addIndent(sb, nd.level * 4);
            sb.append(nd.trans.getClass().getSimpleName());
            sb.append("{\"" + nd.trans.getTransportId() + "\"}\n");
        }
        return sb.toString();
    }

    public void registerBaseOverlay(TransportIdPath transIdPath) {
        this.baseOverlays.add(transIdPath);
        logger.trace("EXIT:");
    }

    public boolean unregisterBaseOverlay(TransportIdPath transIdPath) {
        logger.trace("EXIT:");
        return this.baseOverlays.remove(transIdPath);
    }

    public Set<TransportIdPath> getBaseOverlays() {
        return this.baseOverlays;
    }

    public void registerRPCObject(ObjectId objId, RPCIf obj) throws IdConflictException {
        if (this.rpcObjects.putIfAbsent(objId, obj) != null) {
            throw new IdConflictException("This RPC object is already registered: " + objId);
        }
        logger.trace("EXIT:");
    }

    public boolean unregisterRPCObject(ObjectId objId, RPCIf obj) {
        logger.trace("EXIT:");
        return this.rpcObjects.remove(objId, obj);
    }

    public RPCIf getRPCObject(ObjectId objId) {
        return (RPCIf)this.rpcObjects.get(objId);
    }

    public void execute(Runnable receiveTask) throws RejectedExecutionException {
        this.threadPool.execute(receiveTask);
    }

    public void concatPeerId2ThreadName() {
        String currName = Thread.currentThread().getName();
        int ix = currName.indexOf(58);
        if (ix != -1) {
            currName = currName.substring(0, ix);
        }
        Thread.currentThread().setName(currName + ':' + this.peerId);
    }

    public String toString() {
        return "Peer{peerId=" + this.peerId + ", \n    transports=" + this.getAllTransports() + ", \n    baseTransports=" + this.baseTransMgr.getBaseTransportIdPaths() + ", \n    baseOverlays=" + this.baseOverlays + ", \n    rpcObjects=" + this.rpcObjects.keySet() + "}";
    }

    public static class TransportTreeNode {
        public final int level;
        public final Transport<?> trans;

        TransportTreeNode(int level, Transport<?> trans) {
            this.level = level;
            this.trans = trans;
        }
    }
}

