/*
 * Decompiled with CFR 0.152.
 */
package org.piax.gtrans;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import org.piax.common.Endpoint;

public class RemoteValue<V>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Endpoint peer;
    private V value;
    private Throwable exception = null;
    private Object option = null;
    transient int hash;

    public RemoteValue(Endpoint peer) {
        this.peer = peer;
    }

    public RemoteValue(Endpoint peer, V value) {
        this.peer = peer;
        this.value = value;
    }

    public RemoteValue(Endpoint peer, Throwable exception) {
        this.peer = peer;
        this.value = null;
        this.exception = exception;
    }

    public RemoteValue(Endpoint peer, V value, Throwable exception) {
        this.peer = peer;
        this.value = value;
        this.exception = exception;
    }

    public Endpoint getPeer() {
        return this.peer;
    }

    public V get() throws InvocationTargetException {
        if (this.exception != null) {
            throw new InvocationTargetException(this.exception);
        }
        return this.value;
    }

    public V getValue() {
        return this.value;
    }

    public Throwable getException() {
        return this.exception;
    }

    public void setException(Throwable t) {
        this.exception = t;
    }

    public void setOption(Object option) {
        this.option = option;
    }

    public Object getOption() {
        return this.option;
    }

    private boolean equals(Object a, Object b) {
        return a == null ? b == null : a.equals(b);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !(o instanceof RemoteValue)) {
            return false;
        }
        if (this.hashCode() != o.hashCode()) {
            return false;
        }
        RemoteValue r = (RemoteValue)o;
        return this.equals(this.peer, r.peer) && this.equals(this.value, r.value) && this.equals(this.exception, r.exception);
    }

    public int hashCode() {
        if (this.hash == 0) {
            this.hash = 31 * (this.peer == null ? 0 : this.peer.hashCode()) + (this.value == null ? 0 : this.value.hashCode()) + (this.exception == null ? 0 : this.exception.hashCode());
        }
        return this.hash;
    }

    public String toString() {
        String v = this.exception == null ? " val=" + this.value : " excep=" + this.exception;
        return "[peer=" + this.peer + v + "]";
    }
}

