/*
 * Decompiled with CFR 0.152.
 */
package org.piax.gtrans;

import java.io.Serializable;

public class TransOptions
implements Serializable {
    private static final long serialVersionUID = 8743238717571271663L;
    private static final long DEFAULT_TIMEOUT = 30000L;
    private static final ResponseType DEFAULT_RESPONSE_TYPE = ResponseType.AGGREGATE;
    private static final RetransMode DEFAULT_RETRANS_MODE = RetransMode.SLOW;
    private static final DeliveryMode DEFAULT_DELIVERY_MODE = DeliveryMode.ACCEPT_ONCE;
    private static final boolean DEFAULT_INSPECT = false;
    private long timeout;
    private boolean inspect;
    private ResponseType responseType;
    private RetransMode retransMode;
    private DeliveryMode deliveryMode;

    public TransOptions() {
        this(30000L);
    }

    public TransOptions(TransOptions opts) {
        if (opts == null) {
            opts = new TransOptions();
        }
        this.setTimeout(opts.timeout);
        this.setResponseType(opts.responseType);
        this.setRetransMode(opts.retransMode);
        this.setInspect(opts.inspect);
    }

    public TransOptions(long timeout) {
        this(timeout, ResponseType.AGGREGATE);
    }

    public TransOptions(ResponseType type) {
        this(30000L, type);
    }

    public TransOptions(RetransMode mode) {
        this(30000L, DEFAULT_RESPONSE_TYPE, mode);
    }

    public TransOptions(ResponseType responseType, RetransMode retransMode) {
        this(30000L, responseType, retransMode, DEFAULT_DELIVERY_MODE);
    }

    public TransOptions(long timeout, ResponseType type) {
        this(timeout, type, RetransMode.SLOW);
    }

    public TransOptions(long timeout, RetransMode mode) {
        this(timeout, DEFAULT_RESPONSE_TYPE, mode);
    }

    public TransOptions(long timeout, ResponseType type, boolean inspect) {
        this(timeout, type, DEFAULT_RETRANS_MODE, DEFAULT_DELIVERY_MODE, inspect);
    }

    public TransOptions(long timeout, ResponseType responseType, RetransMode retransMode) {
        this(timeout, responseType, retransMode, DEFAULT_DELIVERY_MODE, false);
    }

    public TransOptions(long timeout, ResponseType responseType, RetransMode retransMode, DeliveryMode deliveryMode) {
        this(timeout, responseType, retransMode, deliveryMode, false);
    }

    public TransOptions(long timeout, ResponseType responseType, RetransMode retransMode, DeliveryMode deliveryMode, boolean inspect) {
        this.timeout = timeout;
        this.responseType = responseType;
        this.retransMode = retransMode;
        this.deliveryMode = deliveryMode;
        this.inspect = inspect;
    }

    public static long timeout(TransOptions opts) {
        if (opts == null) {
            return 30000L;
        }
        return opts.timeout;
    }

    public static ResponseType responseType(TransOptions opts) {
        if (opts == null) {
            return DEFAULT_RESPONSE_TYPE;
        }
        return opts.responseType;
    }

    public static RetransMode retransMode(TransOptions opts) {
        if (opts == null) {
            return DEFAULT_RETRANS_MODE;
        }
        return opts.retransMode;
    }

    public static DeliveryMode deliveryMode(TransOptions opts) {
        if (opts == null) {
            return DEFAULT_DELIVERY_MODE;
        }
        return opts.deliveryMode;
    }

    public static boolean inspect(TransOptions opts) {
        if (opts == null) {
            return false;
        }
        return opts.inspect;
    }

    public String toString() {
        return "{responseType=" + (Object)((Object)this.responseType) + ", retransMode=" + (Object)((Object)this.retransMode) + ", timeout=" + this.timeout + ", inspect=" + this.inspect + "}";
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public boolean isInspect() {
        return this.inspect;
    }

    public void setInspect(boolean inspect) {
        this.inspect = inspect;
    }

    public ResponseType getResponseType() {
        return this.responseType;
    }

    public void setResponseType(ResponseType responseType) {
        this.responseType = responseType;
    }

    public RetransMode getRetransMode() {
        return this.retransMode;
    }

    public void setRetransMode(RetransMode retransMode) {
        this.retransMode = retransMode;
    }

    public static enum DeliveryMode {
        ACCEPT_ONCE,
        ACCEPT_REPEATED;

    }

    public static enum RetransMode {
        NONE,
        NONE_ACK,
        FAST,
        SLOW,
        RELIABLE;

    }

    public static enum ResponseType {
        NO_RESPONSE,
        DIRECT,
        AGGREGATE;

    }
}

