/*
 * Decompiled with CFR 0.152.
 */
package org.piax.gtrans.handover;

import java.io.IOException;
import java.util.List;
import org.piax.common.PeerId;
import org.piax.common.PeerIdWithLocator;
import org.piax.common.PeerLocator;
import org.piax.common.TransportId;
import org.piax.gtrans.ChannelTransport;
import org.piax.gtrans.IdConflictException;
import org.piax.gtrans.NoSuchPeerException;
import org.piax.gtrans.Peer;
import org.piax.gtrans.ProtocolUnsupportedException;
import org.piax.gtrans.ReceivedMessage;
import org.piax.gtrans.Transport;
import org.piax.gtrans.impl.BaseTransportMgr;
import org.piax.gtrans.impl.DatagramBasedTransport;
import org.piax.gtrans.impl.IdResolver;
import org.piax.gtrans.impl.NestedMessage;
import org.piax.gtrans.raw.LocatorStatusObserver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HandoverTransport
extends DatagramBasedTransport<PeerId, PeerLocator>
implements LocatorStatusObserver {
    private static final Logger logger = LoggerFactory.getLogger(HandoverTransport.class);
    final Peer peer;
    final IdResolver idResolver;
    final BaseTransportMgr baseTransMgr;

    public HandoverTransport(Peer peer, TransportId transId) throws IdConflictException {
        super(peer, transId, null, true);
        this.peer = peer;
        this.idResolver = peer.getIdResolver();
        this.baseTransMgr = peer.getBaseTransportMgr();
    }

    @Override
    public synchronized void fin() {
        super.fin();
        this.broadcastPeerFin();
    }

    @Override
    public Transport<?> getBaseTransport() {
        return this.baseTransMgr.getRecentlyUsedTransport();
    }

    @Override
    public PeerId getEndpoint() {
        return this.peerId;
    }

    private PeerLocator selectLocator(PeerId target) {
        if (!this.idResolver.contains(target)) {
            return null;
        }
        List<PeerLocator> locs = this.idResolver.getLocators(target);
        for (PeerLocator loc : locs) {
            Transport<PeerLocator> bt = this.baseTransMgr.getApplicableBaseTransport(loc);
            if (bt == null) continue;
            return loc;
        }
        return null;
    }

    @Override
    protected void lowerSend(PeerId dst, NestedMessage nmsg) throws ProtocolUnsupportedException, IOException {
        Transport<PeerLocator> bt;
        PeerId peerId = null;
        PeerLocator loc = null;
        if (dst instanceof PeerIdWithLocator) {
            peerId = ((PeerIdWithLocator)dst).getPeerId();
            loc = ((PeerIdWithLocator)dst).getLocator();
            bt = this.baseTransMgr.getApplicableBaseTransport(loc);
        } else if (dst instanceof PeerId) {
            peerId = dst;
            loc = this.selectLocator(peerId);
            if (loc == null) {
                throw new NoSuchPeerException("No such PeerLocator could send to " + dst);
            }
            bt = this.baseTransMgr.getApplicableBaseTransport(loc);
        } else {
            bt = null;
        }
        if (bt == null) {
            throw new ProtocolUnsupportedException("No such Transport could send to " + dst);
        }
        bt.send(this.transId, loc, (Object)nmsg);
        if (peerId != null && !this.idResolver.contains(peerId)) {
            this.idResolver.set(peerId, loc);
            for (PeerLocator myLoc : this.baseTransMgr.getAvailableLocators()) {
                this.sendIdLocChange(bt, loc, myLoc, null);
            }
        }
    }

    @Override
    protected NestedMessage _preReceive(ReceivedMessage rmsg) {
        NestedMessage nmsg = (NestedMessage)rmsg.getMessage();
        this.idResolver.add(nmsg.srcPeerId, (PeerLocator)rmsg.getSource());
        if (nmsg.getInner() == null && nmsg.option instanceof PeerLocator[]) {
            if (this.peerId.equals(nmsg.srcPeerId)) {
                logger.warn("locator change command from me has no effect");
            } else {
                PeerLocator[] changes = (PeerLocator[])nmsg.option;
                PeerLocator addLoc = changes[0];
                PeerLocator removeLoc = changes[1];
                if (addLoc == null && removeLoc == null) {
                    this.idResolver.removeAll(nmsg.srcPeerId);
                } else {
                    if (addLoc != null) {
                        this.idResolver.add(nmsg.srcPeerId, addLoc);
                    }
                    if (removeLoc != null) {
                        this.idResolver.remove(nmsg.srcPeerId, removeLoc);
                    }
                }
            }
            return null;
        }
        return nmsg;
    }

    private <E extends PeerLocator> void sendIdLocChange(Transport<E> bt, E target, PeerLocator addLoc, PeerLocator removeLoc) throws ProtocolUnsupportedException, IOException {
        PeerLocator[] changes = new PeerLocator[]{addLoc, removeLoc};
        NestedMessage nmsg = new NestedMessage(null, null, this.peerId, bt.getEndpoint(), 0, changes, null);
        bt.send(this.transId, target, (Object)nmsg);
    }

    private <E extends PeerLocator> void sendIdLocChange(E target, PeerLocator addLoc, PeerLocator removeLoc) throws ProtocolUnsupportedException, IOException {
        Transport<E> bt = this.baseTransMgr.getApplicableBaseTransport(target);
        if (bt == null) {
            throw new ProtocolUnsupportedException("No such Transport could send to " + target);
        }
        this.sendIdLocChange(bt, target, addLoc, removeLoc);
    }

    private void broadcastIdLocChange(PeerLocator addLoc, PeerLocator removeLoc) {
        List<PeerId> peers = this.idResolver.getPeerIds();
        for (PeerId peer : peers) {
            PeerLocator loc = this.selectLocator(peer);
            try {
                if (loc == null) {
                    throw new NoSuchPeerException("No such PeerLocator could send to " + peer);
                }
                this.sendIdLocChange(loc, addLoc, removeLoc);
            }
            catch (IOException e) {
                logger.warn("", (Throwable)e);
            }
        }
    }

    private void broadcastLocatorChange(PeerLocator addLoc, PeerLocator removeLoc) {
        this.broadcastIdLocChange(addLoc, removeLoc);
    }

    private void broadcastPeerFin() {
        this.broadcastIdLocChange(null, null);
    }

    @Override
    public synchronized void onEnabled(PeerLocator loc, boolean isNew) {
        try {
            Transport<PeerLocator> bt = this.baseTransMgr.newBaseTransport(null, null, loc);
            bt.setListener(this.transId, this);
            if (bt instanceof ChannelTransport) {
                ((ChannelTransport)bt).setChannelListener(this.transId, this);
            }
            this.broadcastLocatorChange(loc, null);
        }
        catch (IOException e) {
            logger.warn("", (Throwable)e);
        }
        catch (IdConflictException e) {
            logger.error("", (Throwable)e);
        }
    }

    @Override
    public synchronized void onFadeout(PeerLocator loc, boolean isFin) {
        Transport<PeerLocator> bt = this.baseTransMgr.removeBaseTransport(loc);
        if (bt != null) {
            this.broadcastLocatorChange(null, loc);
        }
    }

    @Override
    public synchronized void onChanging(PeerLocator oldLoc, PeerLocator newLoc) {
        Transport<PeerLocator> oldBt = this.baseTransMgr.removeBaseTransport(oldLoc);
        if (oldBt == null) {
            this.onEnabled(newLoc, false);
            return;
        }
        try {
            Transport<PeerLocator> newBt = this.baseTransMgr.newBaseTransport(null, null, newLoc);
            newBt.setListener(this.transId, this);
            if (newBt instanceof ChannelTransport) {
                ((ChannelTransport)newBt).setChannelListener(this.transId, this);
            }
            this.broadcastLocatorChange(newLoc, oldLoc);
            return;
        }
        catch (IOException e) {
            logger.warn("", (Throwable)e);
        }
        catch (IdConflictException e) {
            logger.error("", (Throwable)e);
        }
        this.broadcastLocatorChange(null, oldLoc);
    }

    @Override
    public void onHangup(PeerLocator loc, Exception cause) {
        this.onFadeout(loc, false);
    }

    @Override
    protected boolean useReceiverThread(int numProc) {
        return false;
    }
}

