/*
 * Decompiled with CFR 0.152.
 */
package org.piax.gtrans.impl;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.piax.common.Endpoint;
import org.piax.common.PeerId;
import org.piax.gtrans.impl.ChannelImpl;

class AcceptedChannelMgr<E extends Endpoint> {
    private final ConcurrentMap<Key, ChannelImpl<E>> channelMap = new ConcurrentHashMap<Key, ChannelImpl<E>>();

    AcceptedChannelMgr() {
    }

    ChannelImpl<E> getChannel(PeerId creator, int channelNo) {
        return (ChannelImpl)this.channelMap.get(new Key(creator, channelNo));
    }

    void putChannel(PeerId creator, int channelNo, ChannelImpl<E> ch) {
        this.channelMap.put(new Key(creator, channelNo), ch);
    }

    boolean removeChannel(ChannelImpl<E> ch) {
        return this.channelMap.remove(new Key(ch.creator, ch.getChannelNo()), ch);
    }

    static class Key {
        final PeerId creator;
        final int channelNo;

        Key(PeerId creator, int channelNo) {
            this.creator = creator;
            this.channelNo = channelNo;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null || !(o instanceof Key)) {
                return false;
            }
            if (this.hashCode() != o.hashCode()) {
                return false;
            }
            Key k = (Key)o;
            return this.creator.equals(k.creator) && this.channelNo == k.channelNo;
        }

        public int hashCode() {
            int chash = this.creator == null ? 0 : this.creator.hashCode();
            return chash + this.channelNo;
        }
    }
}

