/*
 * Decompiled with CFR 0.152.
 */
package org.piax.gtrans.impl;

import java.io.IOException;
import org.piax.common.PeerLocator;
import org.piax.common.TransportId;
import org.piax.gtrans.ChannelTransport;
import org.piax.gtrans.IdConflictException;
import org.piax.gtrans.Peer;
import org.piax.gtrans.Transport;

public abstract class BaseTransportGenerator {
    private BaseTransportGenerator next = null;
    protected final Peer peer;

    protected BaseTransportGenerator(Peer peer) {
        this.peer = peer;
    }

    protected Peer getPeer() {
        return this.peer;
    }

    public final synchronized void addNext(BaseTransportGenerator gen) {
        this.next = gen;
    }

    public final synchronized void addLast(BaseTransportGenerator gen) {
        if (this.next == null) {
            this.next = gen;
        } else {
            this.next.addLast(gen);
        }
    }

    public final synchronized <E extends PeerLocator> Transport<E> newBaseTransport(String desc, TransportId transId, E loc) throws IdConflictException, IOException {
        Transport<E> trans = this._newBaseTransport(desc, transId, loc);
        if (trans != null) {
            return trans;
        }
        if (this.next == null) {
            return null;
        }
        return this.next.newBaseTransport(desc, transId, loc);
    }

    public final synchronized <E extends PeerLocator> ChannelTransport<E> newBaseChannelTransport(String desc, TransportId transId, E loc) throws IdConflictException, IOException {
        ChannelTransport<E> trans = this._newBaseChannelTransport(desc, transId, loc);
        if (trans != null) {
            return trans;
        }
        if (this.next == null) {
            return null;
        }
        return this.next.newBaseChannelTransport(desc, transId, loc);
    }

    public abstract <E extends PeerLocator> ChannelTransport<E> _newBaseChannelTransport(String var1, TransportId var2, E var3) throws IdConflictException, IOException;

    public abstract <E extends PeerLocator> Transport<E> _newBaseTransport(String var1, TransportId var2, E var3) throws IdConflictException, IOException;
}

