/*
 * Decompiled with CFR 0.152.
 */
package org.piax.gtrans.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.piax.common.Endpoint;
import org.piax.gtrans.Discoverable;
import org.piax.gtrans.DiscoveryListener;
import org.piax.gtrans.PeerInfo;

public abstract class DiscoverableImpl<E extends Endpoint>
implements Discoverable<E> {
    protected static final Timer timer = new Timer("RawDiscoveryTimer", true);
    protected final ConcurrentLinkedQueue<InfoBox<E>> availableInfoQueue = new ConcurrentLinkedQueue();
    protected final Set<DiscoveryListener<E>> listeners = Collections.newSetFromMap(new ConcurrentHashMap());
    private TimerTask task;

    @Override
    public void fin() {
        this.availableInfoQueue.clear();
        this.listeners.clear();
    }

    @Override
    public boolean addDiscoveryListener(DiscoveryListener<E> listener) {
        return this.listeners.add(listener);
    }

    @Override
    public boolean removeDiscoveryListener(DiscoveryListener<E> listener) {
        return this.listeners.remove(listener);
    }

    protected abstract TimerTask getDiscoveryTask();

    @Override
    public synchronized void scheduleDiscovery(long delay, long period) {
        if (this.task != null) {
            this.task.cancel();
        }
        this.task = this.getDiscoveryTask();
        timer.schedule(this.task, delay, period);
    }

    @Override
    public synchronized void cancelDiscovery() {
        if (this.task != null) {
            this.task.cancel();
            this.task = null;
        }
    }

    @Override
    public List<PeerInfo<E>> getAvailablePeerInfos() {
        ArrayList avail = new ArrayList();
        for (InfoBox<E> infoBox : this.availableInfoQueue) {
            avail.add(infoBox.info);
        }
        return avail;
    }

    protected void found(PeerInfo<E> info) {
        InfoBox<E> infoBox = new InfoBox<E>(info);
        boolean isNew = !this.availableInfoQueue.remove(infoBox);
        this.availableInfoQueue.offer(infoBox);
        for (DiscoveryListener<E> listener : this.listeners) {
            listener.onDiscovered(info, isNew);
        }
    }

    protected void discardOldInfos(long period) {
        InfoBox<E> infoBox;
        long past = System.currentTimeMillis() - period;
        while ((infoBox = this.availableInfoQueue.peek()) != null && past >= infoBox.lastObserved) {
            this.availableInfoQueue.poll();
            for (DiscoveryListener listener : this.listeners) {
                listener.onFadeout(infoBox.info);
            }
        }
    }

    static class InfoBox<E extends Endpoint> {
        final PeerInfo<E> info;
        final long lastObserved;

        InfoBox(PeerInfo<E> info) {
            this.info = info;
            this.lastObserved = System.currentTimeMillis();
        }

        public int hashCode() {
            return this.info == null ? 0 : this.info.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || !(obj instanceof InfoBox)) {
                return false;
            }
            InfoBox _obj = (InfoBox)obj;
            return this.info == null ? _obj.info == null : this.info.equals(_obj.info);
        }
    }
}

