/*
 * Decompiled with CFR 0.152.
 */
package org.piax.gtrans.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.piax.common.PeerId;
import org.piax.common.PeerLocator;
import org.piax.util.Register;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdResolver {
    private static final Logger logger = LoggerFactory.getLogger(IdResolver.class);
    final PeerId myId;
    private final Register<PeerId, PeerLocator> map;

    public IdResolver(PeerId myId) {
        this.myId = myId;
        this.map = new Register();
    }

    public synchronized boolean contains(PeerId peerId) {
        return this.map.containsKey(peerId);
    }

    public synchronized void set(PeerId peerId, PeerLocator ... locs) {
        if (this.myId.equals(peerId)) {
            logger.info("specified peerId is mine: set");
            return;
        }
        this.map.remove(peerId);
        for (PeerLocator loc : locs) {
            this.map.add(peerId, loc);
        }
    }

    public synchronized boolean add(PeerId peerId, PeerLocator loc) {
        if (this.myId.equals(peerId)) {
            logger.info("specified peerId is mine: add");
            return false;
        }
        return this.map.add(peerId, loc);
    }

    public synchronized boolean remove(PeerId peerId, PeerLocator loc) {
        if (this.myId.equals(peerId)) {
            logger.info("specified peerId is mine: remove");
            return false;
        }
        return this.map.remove(peerId, loc);
    }

    public synchronized void putAll(Map<? extends PeerId, ? extends PeerLocator> map) {
        for (Map.Entry<? extends PeerId, ? extends PeerLocator> entry : map.entrySet()) {
            this.set(entry.getKey(), entry.getValue());
        }
    }

    public synchronized void removeAll(PeerId peerId) {
        this.map.remove(peerId);
    }

    public synchronized List<PeerId> getPeerIds() {
        return new ArrayList<PeerId>(this.map.keySet());
    }

    public synchronized List<PeerLocator> getLocators(PeerId peerId) {
        return new ArrayList<PeerLocator>(this.map.getValues(peerId));
    }

    public synchronized String toString() {
        return this.map.toString();
    }
}

