/*
 * Decompiled with CFR 0.152.
 */
package org.piax.gtrans.impl;

import java.io.Serializable;
import org.piax.common.PeerId;

public class MessageId
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static long _msgNo = 0L;
    public final PeerId origin;
    public final long msgNo;

    public static synchronized MessageId newMessageId(PeerId origin) {
        if (origin == null) {
            throw new IllegalArgumentException("origin PeerId should not be null");
        }
        return new MessageId(origin, _msgNo++);
    }

    private MessageId(PeerId origin, long msgNo) {
        this.origin = origin;
        this.msgNo = msgNo;
    }

    public int hashCode() {
        return this.origin.hashCode() ^ (int)this.msgNo;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof MessageId)) {
            return false;
        }
        MessageId _obj = (MessageId)obj;
        return this.origin.equals(_obj.origin) && this.msgNo == _obj.msgNo;
    }

    public String toString() {
        return this.origin + "#" + this.msgNo;
    }
}

