/*
 * Decompiled with CFR 0.152.
 */
package org.piax.gtrans.impl;

import java.io.Serializable;
import java.nio.ByteBuffer;
import org.piax.common.Endpoint;
import org.piax.common.ObjectId;
import org.piax.common.PeerId;
import org.piax.gtrans.GTransConfigValues;
import org.piax.gtrans.impl.ExceededSizeException;
import org.piax.gtrans.impl.InvalidMessageException;
import org.piax.gtrans.impl.NotEnoughMessageException;
import org.piax.util.BinaryJsonabilityException;
import org.piax.util.BinaryJsonner;
import org.piax.util.ByteBufferUtil;
import org.piax.util.ByteUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NestedMessage
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(NestedMessage.class);
    public static final short PIAX_MAGIC = -275;
    public static final byte isMsgBody = 0;
    public static final byte isNested = 1;
    static int initialBufSize = 32000;
    public final ObjectId sender;
    public final ObjectId receiver;
    public final PeerId srcPeerId;
    public final Endpoint src;
    public final int channelNo;
    public final Object option;
    public final Object inner;
    public Object passthrough;

    public static int checkAndGetMessageLen(ByteBuffer bbuf) throws NotEnoughMessageException, InvalidMessageException {
        int len = bbuf.remaining();
        if (len < 6) {
            throw new NotEnoughMessageException("data is not enouth: current size=" + len);
        }
        short magic = bbuf.getShort(bbuf.position());
        if (magic != -275) {
            throw new InvalidMessageException("invalid PIAX magic");
        }
        return bbuf.getInt(bbuf.position() + 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NestedMessage deserialize(ByteBuffer bb) throws BinaryJsonabilityException {
        logger.trace("ENTRY:");
        try {
            short magic;
            int bbLen = bb.remaining();
            if (logger.isDebugEnabled()) {
                logger.debug("out {}", (Object)ByteUtil.dumpBytes(bb));
            }
            if ((magic = bb.getShort()) != -275) {
                throw new BinaryJsonabilityException("invalid PIAX magic");
            }
            int len = bb.getInt();
            if (bbLen != len) {
                logger.error("msg length and header peerId mismatched");
                logger.debug("len in msg {}", (Object)len);
                logger.debug("len of bbuf {}", (Object)bbLen);
            }
            NestedMessage nmsg = NestedMessage.deserialize0(bb);
            if (bb.remaining() != 0) {
                logger.warn("len of bbuf remaining {}", (Object)bb.remaining());
            }
            logger.debug("msg {}", (Object)nmsg);
            NestedMessage nestedMessage = nmsg;
            return nestedMessage;
        }
        finally {
            logger.trace("EXIT:");
        }
    }

    private static NestedMessage deserialize0(ByteBuffer bb) throws BinaryJsonabilityException {
        ObjectId sender = (ObjectId)BinaryJsonner.deserialize(bb);
        ObjectId receiver = (ObjectId)BinaryJsonner.deserialize(bb);
        PeerId srcPeerId = (PeerId)BinaryJsonner.deserialize(bb);
        Endpoint src = (Endpoint)BinaryJsonner.deserialize(bb);
        int channelNo = bb.getInt();
        Serializable option = BinaryJsonner.deserialize(bb);
        Serializable passthrough = BinaryJsonner.deserialize(bb);
        byte delim = bb.get();
        Serializable inner = delim == 0 ? BinaryJsonner.deserialize(bb) : NestedMessage.deserialize0(bb);
        NestedMessage nmsg = new NestedMessage(sender, receiver, srcPeerId, src, channelNo, option, inner);
        nmsg.setPassthrough(passthrough);
        return nmsg;
    }

    public NestedMessage(ObjectId sender, ObjectId receiver, PeerId srcPeerId, Endpoint src, Object inner) {
        this(sender, receiver, srcPeerId, src, 0, null, inner);
    }

    public NestedMessage(ObjectId sender, ObjectId receiver, PeerId srcPeerId, Endpoint src, int channelNo, Object option, Object inner) {
        this.sender = sender;
        this.receiver = receiver;
        this.srcPeerId = srcPeerId;
        this.src = src;
        this.channelNo = channelNo;
        this.option = option;
        this.inner = inner;
        if (inner instanceof NestedMessage) {
            NestedMessage _inner = (NestedMessage)inner;
            this.passthrough = _inner.passthrough;
            _inner.passthrough = null;
        }
    }

    public NestedMessage(NestedMessage nmsg, Object newInner) {
        this(nmsg.sender, nmsg.receiver, nmsg.srcPeerId, nmsg.src, nmsg.channelNo, nmsg.option, newInner);
        this.passthrough = nmsg.passthrough;
    }

    public void setPassthrough(Object obj) {
        this.passthrough = obj;
    }

    public Object getInner() {
        if (this.inner instanceof NestedMessage) {
            NestedMessage _inner = (NestedMessage)this.inner;
            _inner.passthrough = this.passthrough;
        }
        return this.inner;
    }

    public ByteBuffer serialize() throws BinaryJsonabilityException, ExceededSizeException {
        logger.trace("ENTRY:");
        ByteBuffer bb = ByteBufferUtil.newByteBuffer(0, initialBufSize);
        bb.putShort((short)-275);
        bb.putInt(0);
        bb = this.serialize0(bb);
        bb.flip();
        int len = bb.remaining();
        if (len > GTransConfigValues.MAX_MSG_SIZE) {
            throw new ExceededSizeException("message exceeds decided size: " + len);
        }
        bb.putInt(2, len);
        if (logger.isDebugEnabled()) {
            logger.debug("out {}", (Object)ByteUtil.dumpBytes(bb));
        }
        logger.trace("EXIT:");
        return bb;
    }

    private ByteBuffer serialize0(ByteBuffer bbuf) throws BinaryJsonabilityException {
        ByteBuffer bb = bbuf;
        bb = BinaryJsonner.serialize(bb, this.sender);
        bb = BinaryJsonner.serialize(bb, this.receiver);
        bb = BinaryJsonner.serialize(bb, this.srcPeerId);
        bb = BinaryJsonner.serialize(bb, this.src);
        bb.putInt(this.channelNo);
        bb = BinaryJsonner.serialize(bb, (Serializable)this.option);
        bb = BinaryJsonner.serialize(bb, (Serializable)this.passthrough);
        if (this.inner instanceof NestedMessage) {
            bb.put((byte)1);
            bb = ((NestedMessage)this.inner).serialize0(bb);
        } else {
            bb.put((byte)0);
            bb = BinaryJsonner.serialize(bb, (Serializable)this.inner);
        }
        return bb;
    }

    public String toString() {
        return "NestedMessage [sender=" + this.sender + ", receiver=" + this.receiver + ", srcPeerId=" + this.srcPeerId + ", src=" + this.src + ", channelNo=" + this.channelNo + ", option=" + this.option + ", passthrough=" + this.passthrough + ", inner=" + this.inner + "]";
    }
}

