/*
 * Decompiled with CFR 0.152.
 */
package org.piax.gtrans.impl;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.piax.common.Endpoint;
import org.piax.common.ObjectId;
import org.piax.common.PeerId;
import org.piax.common.TransportId;
import org.piax.gtrans.Channel;
import org.piax.gtrans.ChannelListener;
import org.piax.gtrans.ChannelTransport;
import org.piax.gtrans.IdConflictException;
import org.piax.gtrans.ProtocolUnsupportedException;
import org.piax.gtrans.ReceivedMessage;
import org.piax.gtrans.Transport;
import org.piax.gtrans.TransportListener;
import org.piax.gtrans.impl.ChannelImpl;
import org.piax.gtrans.impl.ChannelTransportImpl;
import org.piax.gtrans.impl.NestedMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class OneToOneMappingTransport<E extends Endpoint>
extends ChannelTransportImpl<E>
implements TransportListener<E>,
ChannelListener<E> {
    private static final Logger logger = LoggerFactory.getLogger(OneToOneMappingTransport.class);
    private final Map<Channel<E>, OneToOneChannel<E>> relatedChMap = new HashMap<Channel<E>, OneToOneChannel<E>>();

    protected OneToOneMappingTransport(TransportId transId, ChannelTransport<E> lowerTrans) throws IdConflictException {
        super(lowerTrans.getPeer(), transId, lowerTrans, lowerTrans.supportsDuplex());
        lowerTrans.setListener(transId, this);
        lowerTrans.setChannelListener(transId, this);
    }

    @Override
    public E getEndpoint() {
        return this.getLowerTransport().getEndpoint();
    }

    @Override
    public int getMTU() {
        return this.lowerTrans.getMTU();
    }

    @Override
    public ChannelTransport<E> getLowerTransport() {
        ChannelTransport lower = (ChannelTransport)this.lowerTrans;
        return lower;
    }

    @Override
    public Channel<E> newChannel(ObjectId sender, ObjectId receiver, E dst, boolean isDuplex, int timeout) throws ProtocolUnsupportedException, IOException {
        Channel<E> lowerCh = this.getLowerTransport().newChannel(this.transId, dst, isDuplex, timeout);
        OneToOneChannel<E> ch = new OneToOneChannel<E>(lowerCh, this, sender, receiver, dst);
        if (lowerCh instanceof ChannelImpl) {
            ch.setChannelNo(lowerCh.getChannelNo());
        }
        this.putCh(lowerCh, ch);
        return ch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OneToOneChannel<E> putCh(Channel<E> lowerCh, OneToOneChannel<E> ch) {
        Map<Channel<E>, OneToOneChannel<E>> map = this.relatedChMap;
        synchronized (map) {
            return this.relatedChMap.put(lowerCh, ch);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeCh(Channel<E> lowerCh) {
        Map<Channel<E>, OneToOneChannel<E>> map = this.relatedChMap;
        synchronized (map) {
            this.relatedChMap.remove(lowerCh);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OneToOneChannel<E> getCh(Channel<E> lowerCh) {
        Map<Channel<E>, OneToOneChannel<E>> map = this.relatedChMap;
        synchronized (map) {
            return this.relatedChMap.get(lowerCh);
        }
    }

    @Override
    public boolean onAccepting(Channel<E> lowerCh) {
        this.peer.concatPeerId2ThreadName();
        if (!this.isActive) {
            logger.info("receive event purged");
            return false;
        }
        return true;
    }

    @Override
    public void onClosed(Channel<E> lowerCh) {
        ChannelListener<E> listener;
        this.peer.concatPeerId2ThreadName();
        if (!this.isActive) {
            logger.info("receive event purged");
            return;
        }
        OneToOneChannel<E> ch = this.getCh(lowerCh);
        if (ch == null) {
            return;
        }
        ((ChannelImpl)ch).close();
        if (!ch.remoteObjectId.equals(this.transId) && (listener = this.getChannelListener(ch.localObjectId)) != null) {
            listener.onClosed(ch);
        }
    }

    @Override
    public void onFailure(Channel<E> lowerCh, Exception cause) {
        ChannelListener<E> listener;
        this.peer.concatPeerId2ThreadName();
        if (!this.isActive) {
            logger.info("receive event purged");
            return;
        }
        OneToOneChannel<E> ch = this.getCh(lowerCh);
        if (ch == null) {
            return;
        }
        if (!ch.remoteObjectId.equals(this.transId) && (listener = this.getChannelListener(ch.localObjectId)) != null) {
            listener.onFailure(ch, cause);
        }
    }

    protected Object _preSend(ObjectId sender, ObjectId receiver, E dst, Object msg) throws IOException {
        return msg;
    }

    protected void lowerSend(ObjectId sender, ObjectId receiver, E dst, NestedMessage nmsg) throws ProtocolUnsupportedException, IOException {
        ChannelTransport lower = (ChannelTransport)this.lowerTrans;
        lower.send(sender, receiver, dst, nmsg);
    }

    protected void lowerChSend(Channel<E> ch, NestedMessage nmsg) throws IOException {
        ch.send(nmsg);
    }

    @Override
    public void send(ObjectId sender, ObjectId receiver, E dst, Object msg) throws ProtocolUnsupportedException, IOException {
        logger.trace("ENTRY:");
        Object _msg = this._preSend(sender, receiver, dst, msg);
        if (_msg == null) {
            return;
        }
        NestedMessage nmsg = new NestedMessage(sender, receiver, null, (Endpoint)this.getEndpoint(), _msg);
        this.lowerSend(this.transId, this.transId, dst, nmsg);
    }

    protected void chSend(OneToOneChannel<E> ch, Object msg) throws IOException {
        logger.trace("ENTRY:");
        Object _msg = this._preSend(ch.localObjectId, ch.remoteObjectId, ch.remote, msg);
        if (_msg == null) {
            return;
        }
        NestedMessage nmsg = new NestedMessage(ch.localObjectId, ch.remoteObjectId, this.getPeerId(), (Endpoint)this.getEndpoint(), _msg);
        this.lowerChSend(ch.lowerCh, nmsg);
    }

    protected Object _postReceive(ObjectId sender, ObjectId receiver, E src, Object msg) {
        return msg;
    }

    private OneToOneChannel<E> newAcceptCh(Channel<E> lowerCh, NestedMessage nmsg) {
        OneToOneChannel<Endpoint> ch = new OneToOneChannel<Endpoint>(lowerCh, nmsg.srcPeerId, this, nmsg.receiver, nmsg.sender, nmsg.src);
        ch.setChannelNo(lowerCh.getChannelNo());
        if (this.putCh(lowerCh, ch) != null) {
            logger.error("invaild lower channel accepted");
        }
        return ch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onReceive(Channel<E> lowerCh) {
        this.peer.concatPeerId2ThreadName();
        if (!this.isActive) {
            logger.info("receive msg purged");
            return;
        }
        NestedMessage nmsg = null;
        OneToOneChannel<E> ch = null;
        Channel<E> channel = lowerCh;
        synchronized (channel) {
            if (lowerCh.isClosed()) {
                return;
            }
            nmsg = (NestedMessage)lowerCh.receive();
            if (nmsg == null) {
                logger.error("null message received");
                return;
            }
            ch = this._putReceiveQueue(lowerCh, nmsg);
        }
        if (ch != null && nmsg != null) {
            this._onReceive(ch, nmsg);
        }
    }

    protected OneToOneChannel<E> _putReceiveQueue(Channel<E> lowerCh, NestedMessage nmsg) {
        logger.trace("ENTRY:");
        OneToOneChannel<E> ch = this.getCh(lowerCh);
        if (ch == null) {
            ch = this.newAcceptCh(lowerCh, nmsg);
            ChannelListener<E> listener = this.getChannelListener(nmsg.receiver);
            if (listener != null && !listener.onAccepting(ch)) {
                this.removeCh(lowerCh);
                return null;
            }
        }
        if (lowerCh.isClosed()) {
            return null;
        }
        Object _msg = this._postReceive(nmsg.sender, nmsg.receiver, nmsg.src, nmsg.getInner());
        if (_msg == null) {
            return null;
        }
        ch.putReceiveQueue(_msg);
        return ch;
    }

    protected void _onReceive(Channel<E> ch, NestedMessage nmsg) {
        ChannelListener<E> listener;
        if (ch != null && (listener = this.getChannelListener(nmsg.receiver)) != null) {
            listener.onReceive(ch);
        }
    }

    @Override
    public void onReceive(Transport<E> lowerTrans, ReceivedMessage rmsg) {
        this.peer.concatPeerId2ThreadName();
        if (!this.isActive) {
            logger.info("received msg purged {}", (Object)rmsg);
            return;
        }
        NestedMessage nmsg = (NestedMessage)rmsg.getMessage();
        this._onReceive(lowerTrans, nmsg);
    }

    protected void _onReceive(Transport<E> lowerTrans, NestedMessage nmsg) {
        logger.trace("ENTRY:");
        Object _msg = this._postReceive(nmsg.sender, nmsg.receiver, nmsg.src, nmsg.getInner());
        if (_msg == null) {
            return;
        }
        TransportListener listener = this.getListener(nmsg.receiver);
        if (listener != null) {
            listener.onReceive(this, new ReceivedMessage(nmsg.sender, nmsg.src, _msg));
        }
    }

    protected static class OneToOneChannel<E extends Endpoint>
    extends ChannelImpl<E> {
        final Channel<E> lowerCh;

        OneToOneChannel(Channel<E> lowerCh, ChannelTransport<E> mother, ObjectId localObjId, ObjectId remoteObjId, E remote) {
            super(mother, localObjId, remoteObjId, remote, true);
            this.lowerCh = lowerCh;
        }

        OneToOneChannel(Channel<E> lowerCh, PeerId creator, ChannelTransport<E> mother, ObjectId localObjId, ObjectId remoteObjId, E remote) {
            super(creator, mother, localObjId, remoteObjId, remote, true);
            this.lowerCh = lowerCh;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            Channel<E> channel = this.lowerCh;
            synchronized (channel) {
                super.close();
                ((OneToOneMappingTransport)this.mother).removeCh(this.lowerCh);
                this.lowerCh.close();
            }
        }

        @Override
        public void send(Object msg) throws IOException {
            ((OneToOneMappingTransport)this.mother).chSend(this, msg);
        }
    }
}

