/*
 * Decompiled with CFR 0.152.
 */
package org.piax.gtrans.impl;

import java.io.IOException;
import java.io.Serializable;
import org.piax.common.Destination;
import org.piax.common.ObjectId;
import org.piax.common.TransportId;
import org.piax.gtrans.FutureQueue;
import org.piax.gtrans.IdConflictException;
import org.piax.gtrans.Peer;
import org.piax.gtrans.ProtocolUnsupportedException;
import org.piax.gtrans.ReceivedMessage;
import org.piax.gtrans.RequestTransport;
import org.piax.gtrans.RequestTransportListener;
import org.piax.gtrans.TransOptions;
import org.piax.gtrans.Transport;
import org.piax.gtrans.TransportListener;
import org.piax.gtrans.impl.NestedMessage;
import org.piax.gtrans.impl.TransportImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RequestTransportImpl<D extends Destination>
extends TransportImpl<D>
implements RequestTransport<D> {
    private static final Logger logger = LoggerFactory.getLogger(RequestTransportImpl.class);
    protected static final Object NON = new Object();

    protected RequestTransportImpl(Peer peer, TransportId transId, Transport<?> lowerTrans) throws IdConflictException {
        super(peer, transId, lowerTrans);
    }

    protected TransportListener<D> getListener0(ObjectId upper) {
        return super.getListener(upper);
    }

    @Override
    public FutureQueue<?> request(ObjectId appId, D dst, Object msg) throws ProtocolUnsupportedException, IOException {
        return this.request(appId, appId, dst, msg);
    }

    @Override
    public FutureQueue<?> request(ObjectId appId, D dst, Object msg, TransOptions opts) throws ProtocolUnsupportedException, IOException {
        return this.request(appId, appId, dst, msg, opts);
    }

    @Override
    public FutureQueue<?> request(D dst, Object msg) throws ProtocolUnsupportedException, IOException {
        return this.request(this.getDefaultAppId(), dst, msg);
    }

    @Override
    public FutureQueue<?> request(D dst, Object msg, TransOptions opts) throws ProtocolUnsupportedException, IOException {
        return this.request(this.getDefaultAppId(), dst, msg, opts);
    }

    @Override
    public FutureQueue<?> request(D dst, Object msg, int timeout) throws ProtocolUnsupportedException, IOException {
        return this.request(this.getDefaultAppId(), this.getDefaultAppId(), dst, msg, timeout);
    }

    @Override
    public FutureQueue<?> request(ObjectId sender, ObjectId receiver, D dst, Object msg) throws ProtocolUnsupportedException, IOException {
        return this.request(sender, receiver, dst, msg, null);
    }

    @Override
    public FutureQueue<?> request(ObjectId sender, ObjectId receiver, D dst, Object msg, int timeout) throws ProtocolUnsupportedException, IOException {
        return this.request(sender, receiver, dst, msg, new TransOptions(timeout));
    }

    @Override
    public FutureQueue<?> request(TransportId upperTrans, D dst, Object msg, int timeout) throws ProtocolUnsupportedException, IOException {
        return this.request((ObjectId)upperTrans, (ObjectId)upperTrans, dst, msg, timeout);
    }

    @Override
    public FutureQueue<?> request(TransportId upperTrans, D dst, Object msg) throws ProtocolUnsupportedException, IOException {
        return this.request((ObjectId)upperTrans, (ObjectId)upperTrans, dst, msg, null);
    }

    @Override
    public FutureQueue<?> request(TransportId upperTrans, D dst, Object msg, TransOptions opts) throws ProtocolUnsupportedException, IOException {
        return this.request((ObjectId)upperTrans, (ObjectId)upperTrans, dst, msg, opts);
    }

    @Override
    public void send(ObjectId sender, ObjectId receiver, D dst, Object msg, TransOptions opts) throws ProtocolUnsupportedException, IOException {
        logger.trace("ENTRY:");
        TransOptions newOpts = new TransOptions(opts);
        newOpts.setResponseType(TransOptions.ResponseType.NO_RESPONSE);
        this.request(sender, receiver, dst, (Object)new IsEasySend(msg), newOpts);
    }

    @Override
    public void send(ObjectId sender, ObjectId receiver, D dst, Object msg) throws ProtocolUnsupportedException, IOException {
        this.send(sender, receiver, dst, msg, null);
    }

    protected Object checkAndClearIsEasySend(Object msg) {
        if (msg instanceof IsEasySend) {
            return ((IsEasySend)msg).msg;
        }
        if (msg instanceof NestedMessage) {
            NestedMessage nmsg = (NestedMessage)msg;
            Object inn = this.checkAndClearIsEasySend(nmsg.getInner());
            if (NON == inn) {
                return NON;
            }
            return new NestedMessage(nmsg, inn);
        }
        return NON;
    }

    protected FutureQueue<?> selectOnReceive(RequestTransportListener<D> listener, RequestTransport<D> trans, ReceivedMessage rmsg) {
        logger.trace("ENTRY:");
        Object msg = rmsg.getMessage();
        logger.debug("msg {}", msg);
        Object inn = this.checkAndClearIsEasySend(msg);
        if (NON != inn) {
            rmsg.setMessage(inn);
            logger.debug("select onReceive: trans:{}", (Object)trans.getTransportId());
            listener.onReceive(trans, rmsg);
            return FutureQueue.emptyQueue();
        }
        return listener.onReceiveRequest(trans, rmsg);
    }

    static class IsEasySend
    implements Serializable {
        private static final long serialVersionUID = 1L;
        final Object msg;

        public IsEasySend(Object msg) {
            this.msg = msg;
        }
    }
}

