/*
 * Decompiled with CFR 0.152.
 */
package org.piax.gtrans.netty.nat;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import org.piax.common.Id;
import org.piax.gtrans.ProtocolUnsupportedException;
import org.piax.gtrans.netty.NettyChannelTransport;
import org.piax.gtrans.netty.NettyLocator;

public class NettyNATLocator
extends NettyLocator {
    private static final long serialVersionUID = -5284816579679286212L;
    public static final int NAT_NODE_ID_LENGTH = 24;
    Id id;
    List<NettyLocator> rawChannelLocators;

    private void init() {
        this.id = Id.newId(24);
        this.rawChannelLocators = new ArrayList<NettyLocator>();
    }

    public NettyNATLocator(InetSocketAddress addr) {
        super(addr);
        this.init();
    }

    public NettyNATLocator(String host, int port) {
        super(host, port);
        this.init();
    }

    public NettyNATLocator(String spec) throws ProtocolUnsupportedException {
        super(spec);
        this.init();
    }

    public void updateRawChannelLocators(NettyChannelTransport trans) {
        this.rawChannelLocators = trans.getRawChannelLocators();
    }

    public void updateRawChannelLocators(NettyNATLocator locator) {
        this.rawChannelLocators = locator.getRawChannelLocators();
    }

    public List<NettyLocator> getRawChannelLocators() {
        return this.rawChannelLocators;
    }

    public NettyLocator.TYPE getType() {
        return NettyLocator.TYPE.TCP;
    }

    public String getKeyString() {
        return "nat:" + this.id.toHexString();
    }

    public boolean equals(Object o) {
        if (o instanceof NettyNATLocator) {
            NettyNATLocator l = (NettyNATLocator)((Object)o);
            return this.id.equals(l.id);
        }
        return false;
    }

    public String toString() {
        String ret = String.valueOf(this.getKeyString()) + ":";
        for (NettyLocator loc : this.rawChannelLocators) {
            ret = String.valueOf(ret) + loc + ";";
        }
        return ret;
    }
}

