/*
 * Decompiled with CFR 0.152.
 */
package org.piax.gtrans.ov.ddll;

import java.io.Serializable;
import org.piax.util.KeyComparator;
import org.piax.util.UniqId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DdllKey
implements Comparable<DdllKey>,
Serializable,
Cloneable {
    private static final Logger logger = LoggerFactory.getLogger(DdllKey.class);
    private static final long serialVersionUID = 1L;
    private static KeyComparator keyComp = KeyComparator.getInstance();
    final Comparable<?> primaryKey;
    final UniqId uniqId;
    final String id;
    public final Object appData;
    private final int hash;

    public DdllKey(Comparable<?> key, UniqId uniqId, String id, Object appData) {
        this.primaryKey = key;
        this.uniqId = uniqId;
        this.id = id;
        int h = this.primaryKey.hashCode();
        if (uniqId != null) {
            h ^= uniqId.hashCode();
        }
        this.hash = h;
        this.appData = appData;
    }

    public DdllKey(Comparable<?> key, UniqId uniqId) {
        this(key, uniqId, "", null);
    }

    public Comparable<?> getPrimaryKey() {
        return this.primaryKey;
    }

    public UniqId getUniqId() {
        return this.uniqId;
    }

    public String getId() {
        return this.id;
    }

    @Override
    public int compareTo(DdllKey o) {
        int cmp = keyComp.compare(this.primaryKey, o.primaryKey);
        if (cmp != 0) {
            if (logger.isDebugEnabled()) {
                logger.debug("compareTo: " + this + ", " + o + " = " + cmp);
            }
            return cmp;
        }
        cmp = this.uniqId.compareTo(o.uniqId);
        if (cmp != 0) {
            if (logger.isDebugEnabled()) {
                logger.debug("compareTo: " + this + ", " + o + " = " + cmp);
            }
            return cmp;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("compareTo: " + this + ", " + o + " = 0");
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DdllKey)) {
            return false;
        }
        DdllKey o = (DdllKey)obj;
        if (!this.primaryKey.equals(o.primaryKey)) {
            return false;
        }
        if (!this.uniqId.equals(o.uniqId)) {
            return false;
        }
        return this.id.equals(o.id);
    }

    public boolean equals2(DdllKey o) {
        if (!this.primaryKey.equals(o.primaryKey)) {
            return false;
        }
        return this.uniqId.equals(o.uniqId);
    }

    public int hashCode() {
        return this.hash ^ this.id.hashCode();
    }

    public int hashCode2() {
        return this.hash;
    }

    public String toString() {
        String s = "null";
        if (this.uniqId != null && (s = this.uniqId.toString()).length() > 4) {
            s = s.substring(0, 4);
        }
        return this.primaryKey.toString() + "!" + s + (this.id.equals("") ? "" : "." + this.id);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new Error(e);
        }
    }

    public DdllKey getIdChangedKey(String id) {
        return new DdllKey(this.primaryKey, this.uniqId, id, this.appData);
    }
}

