/*
 * Decompiled with CFR 0.152.
 */
package org.piax.gtrans.ov.ddll;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FutureValues {
    private static final Logger logger = LoggerFactory.getLogger(FutureValues.class);
    private int no = 0;
    private final Map<Integer, ValueLatch> latches = new ConcurrentHashMap<Integer, ValueLatch>();

    public synchronized int newFuture() {
        if (++this.no == 0) {
            ++this.no;
        }
        this.latches.put(this.no, new ValueLatch(1));
        return this.no;
    }

    public void discardFuture(int n) {
        this.latches.remove(n);
    }

    public void set(int n) {
        this.set(n, null);
    }

    public void set(int n, Object value) {
        ValueLatch la = this.latches.get(n);
        if (la == null) {
            logger.info(n + "th future expired");
            return;
        }
        la.value = value;
        la.countDown();
    }

    public Object get(int n, long timeout) throws TimeoutException {
        try {
            ValueLatch vl = this.latches.get(n);
            boolean t = vl.await(timeout, TimeUnit.MILLISECONDS);
            this.discardFuture(n);
            if (!t) {
                throw new TimeoutException();
            }
            return vl.value;
        }
        catch (InterruptedException e) {
            return null;
        }
    }

    public boolean expired(int n) {
        return this.latches.get(n) == null;
    }

    private static class ValueLatch
    extends CountDownLatch {
        Object value = null;

        ValueLatch(int count) {
            super(count);
        }
    }
}

