/*
 * Decompiled with CFR 0.152.
 */
package org.piax.gtrans.ov.ddll;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.piax.common.Endpoint;
import org.piax.gtrans.RPCException;
import org.piax.gtrans.ov.ddll.DdllKey;
import org.piax.gtrans.ov.ddll.FutureValues;
import org.piax.gtrans.ov.ddll.Link;
import org.piax.gtrans.ov.ddll.LinkNum;
import org.piax.gtrans.ov.ddll.NeighborSet;
import org.piax.gtrans.ov.ddll.NodeManager;
import org.piax.gtrans.ov.ddll.NodeManagerIf;
import org.piax.gtrans.ov.ddll.NodeObserver;
import org.piax.gtrans.ov.ddll.OfflineSendException;
import org.piax.gtrans.ov.ddll.Stat;
import org.piax.util.KeyComparator;
import org.piax.util.UniqId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Node {
    private static final Logger logger = LoggerFactory.getLogger(Node.class);
    static String THREAD_NAME_PREFIX = "ddll-";
    static final AtomicInteger thNum = new AtomicInteger(1);
    private static final int FIXREQNO = 0;
    public static int DEFAULT_TIMEOUT;
    public static int SETR_TIMEOUT;
    public static int DELETE_OP_TIMEOUT;
    public static int SEARCH_OP_TIMEOUT;
    public static int GETSTAT_OP_TIMEOUT;
    public static final int INS_DEL_RETRY_INTERVAL_BASE = 200;
    public static int MIN_FIX_INTERVAL;
    public static int DEFAULT_CHECK_PERIOD;
    private static KeyComparator keyComp;
    final NodeManager manager;
    final NodeObserver observer;
    boolean isOnline = true;
    final Link me;
    final DdllKey key;
    volatile Mode mode = Mode.OUT;
    volatile Link left;
    volatile LinkNum lNum;
    volatile Link right;
    volatile LinkNum rNum;
    volatile int ref = 0;
    volatile boolean sendLastUnrefL = true;
    int currentReqNo;
    boolean expectDelayedResponse = false;
    private final ReentrantReadWriteLock protoLock = new ReentrantReadWriteLock();
    private Condition protoCond = this.protoLock.writeLock().newCondition();
    private final FutureValues futures = new FutureValues();
    private final Timer stabilizeTimer;
    private volatile FIX_STATE fixState = FIX_STATE.WAITING;
    private TimerTask fixTask;
    private int checkPeriod = DEFAULT_CHECK_PERIOD;
    final NeighborSet leftNbrs;
    private static final boolean TOSTRING_EMBED_NBRS = true;
    private AtomicInteger fixCount = new AtomicInteger(0);
    private volatile long lastFix = 0L;

    Node(NodeManager manager, NodeObserver observer, String id, Comparable<?> key, Object appData, Timer timer) {
        this(manager, observer, new DdllKey(key, new UniqId(manager.peerId), id, appData), timer);
    }

    Node(NodeManager manager, NodeObserver observer, DdllKey ddllKey, Timer timer) {
        this.manager = manager;
        this.observer = observer;
        this.key = ddllKey;
        this.me = new Link(manager.getLocator(), this.key);
        this.setLeftNum(new LinkNum(0, 0));
        this.leftNbrs = new NeighborSet(this.me, manager);
        this.stabilizeTimer = timer;
        this.online();
    }

    public void online() {
        this.isOnline = true;
    }

    public void offline() {
        this.protoLock.writeLock().lock();
        this.isOnline = false;
        this.fixState = FIX_STATE.WAITING;
        if (this.fixTask != null) {
            this.fixTask.cancel();
        }
        this.protoLock.writeLock().unlock();
    }

    public boolean isOnline() {
        return this.isOnline;
    }

    public void fin() {
        this.protoLock.writeLock().lock();
        try {
            this.offline();
            if (this.left != null) {
                this.manager.monitor.unregisterNode(this.left, this);
            }
        }
        finally {
            this.protoLock.writeLock().unlock();
        }
    }

    public Link getMyLink() {
        return (Link)this.me.clone();
    }

    public DdllKey getKey() {
        return this.key;
    }

    public Mode getMode() {
        return this.mode;
    }

    protected void setMode(Mode mode) {
        this.mode = mode;
    }

    public void setCheckPeriod(int period) {
        this.checkPeriod = period;
    }

    protected void setLeft(Link left) {
        if (this.left != null) {
            this.manager.monitor.unregisterNode(this.left, this);
        }
        this.left = left;
        if (left != null) {
            this.manager.monitor.registerNode(left, this, this.checkPeriod);
        }
    }

    protected void setLeftNum(LinkNum lNum) {
        this.lNum = lNum;
    }

    public Link getLeft() {
        this.protoLock.readLock().lock();
        try {
            if (this.left == null) {
                Link link = null;
                return link;
            }
            Link link = (Link)this.left.clone();
            return link;
        }
        finally {
            this.protoLock.readLock().unlock();
        }
    }

    public Link getRight() {
        this.protoLock.readLock().lock();
        try {
            if (this.right == null) {
                Link link = null;
                return link;
            }
            Link link = (Link)this.right.clone();
            return link;
        }
        finally {
            this.protoLock.readLock().unlock();
        }
    }

    protected void setRight(Link right) {
        this.right = right;
    }

    protected void setRightNum(LinkNum rNum) {
        this.rNum = rNum;
    }

    protected void setRef(int r) {
        this.ref = r;
    }

    public List<Link> getNeighborSet() {
        ArrayList<Link> lst = new ArrayList<Link>(this.leftNbrs.getNeighbors());
        return lst;
    }

    public String toString() {
        String s = "Node[key=" + this.key + ", left=" + this.left + ", right=" + this.right + ", lNum=" + this.lNum + ", rNum=" + this.rNum + ", " + (Object)((Object)this.mode) + ", " + (Object)((Object)this.fixState) + "]";
        return s + ": lnbr=" + this.leftNbrs;
    }

    public void reset() {
        this.protoLock.writeLock().lock();
        try {
            this.setMode(Mode.OUT);
            this.setLeft(null);
            this.setRight(null);
            if (this.fixTask != null) {
                this.fixTask.cancel();
            }
            this.manager.unregisterNode(this.key);
        }
        finally {
            this.protoLock.writeLock().unlock();
        }
    }

    public void lock() {
        this.protoLock.readLock().lock();
    }

    public void unlock() {
        this.protoLock.readLock().unlock();
    }

    private NodeManagerIf getStub(Endpoint loc) throws OfflineSendException {
        if (this.isOnline()) {
            return (NodeManagerIf)this.manager.getStub(loc);
        }
        throw new OfflineSendException();
    }

    public static boolean isOrdered(Comparable<?> a, Comparable<?> b, Comparable<?> c) {
        return keyComp.isOrdered(a, b, c);
    }

    public static boolean isOrdered(Comparable<?> from, boolean fromInclusive, Comparable<?> val, Comparable<?> to, boolean toInclusive) {
        boolean rc = keyComp.isOrdered(from, val, to);
        if (rc && keyComp.compare(from, val) == 0) {
            rc = fromInclusive;
        }
        if (rc && keyComp.compare(val, to) == 0) {
            rc = toInclusive;
        }
        return rc;
    }

    public boolean isBetween(DdllKey a, DdllKey c) {
        return keyComp.isOrdered(a, this.key, c);
    }

    public void insertAsInitialNode() {
        logger.trace("ENTRY:");
        this.setLeft(this.me);
        this.setRight(this.me);
        this.setRightNum(new LinkNum(0, 0));
        this.setMode(Mode.IN);
        this.setRef(1);
        this.manager.registerNode(this);
        logger.trace("EXIT:");
    }

    public static void initializeConnectedNodes(List<Node> list) {
        logger.trace("ENTRY:");
        logger.debug("List = {}", list);
        for (int i = 0; i < list.size(); ++i) {
            Node p = list.get(i);
            Node q = list.get((i + 1) % list.size());
            p.setRight(q.me);
            p.setRightNum(new LinkNum(0, 0));
            q.setLeft(p.me);
            p.setMode(Mode.IN);
            p.setRef(1);
            p.manager.registerNode(p);
        }
        logger.trace("EXIT:");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InsertionResult insert(Link introducer, int maxRetry) throws IllegalStateException {
        if (this.mode != Mode.OUT) {
            throw new IllegalStateException("already inserted");
        }
        this.manager.registerNode(this);
        InsertionResult insres = InsertionResult.getFailureInstance();
        try {
            for (int i = 0; i < maxRetry; ++i) {
                InsertPoint p;
                if (i != 0) {
                    this.sleepForRetry(i);
                }
                try {
                    p = this.findInsertPoint(introducer, this.key, 50);
                }
                catch (OfflineSendException e) {
                    logger.info("insert: findInsertPoint failed as offline while inserting {}", (Object)this.key);
                    InsertionResult insertionResult = InsertionResult.getFailureInstance();
                    if (insres != null && !insres.success) {
                        this.reset();
                    }
                    return insertionResult;
                }
                if (p == null) {
                    logger.info("insert: could not find the insertion point for inserting {}, seed={}", (Object)this.key, (Object)introducer);
                    InsertionResult insertionResult = InsertionResult.getFailureInstance();
                    return insertionResult;
                }
                insres = this.insert0(p);
                if (insres.success) {
                    InsertionResult insertionResult = insres;
                    return insertionResult;
                }
                logger.debug("insertion failed for some reason. retry!: {}", (Object)this);
            }
        }
        finally {
            if (insres != null && !insres.success) {
                this.reset();
            }
        }
        return insres;
    }

    public InsertionResult insert(InsertPoint pos) throws IllegalStateException {
        if (this.mode != Mode.OUT) {
            throw new IllegalStateException("already inserted");
        }
        InsertionResult rc = null;
        this.manager.registerNode(this);
        try {
            rc = this.insert0(pos);
        }
        finally {
            if (rc == null || !rc.success) {
                this.reset();
            }
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InsertionResult insert0(InsertPoint p) {
        logger.trace("ENTRY:");
        logger.debug("insert0: InsertPoint={}", (Object)p);
        this.expectDelayedResponse = false;
        try {
            InsertionResult insertionResult;
            int reqNo;
            if (p.left.equals(this.me)) {
                logger.warn("it seems that i'm unknowningly inserted!");
                this.askRemoteNodeToRemoveMe(p.right);
                InsertionResult insertionResult2 = InsertionResult.getFailureInstance();
                return insertionResult2;
            }
            this.protoLock.writeLock().lock();
            try {
                this.setLeft(p.left);
                this.setRight(p.right);
                this.setRightNum(null);
                this.setMode(Mode.INS);
            }
            finally {
                this.protoLock.writeLock().unlock();
            }
            logger.debug("insert0: {} inserts between {}", (Object)this.key, (Object)p);
            this.currentReqNo = reqNo = this.futures.newFuture();
            try {
                NodeManagerIf stub = this.getStub(this.left.addr);
                stub.setR(this.left.key, this.me, reqNo, this.me, this.right, this.lNum, 0, null);
            }
            catch (RPCException e) {
                this.futures.discardFuture(reqNo);
                logger.error("", e.getCause());
                InsertionResult insertionResult3 = InsertionResult.getFailureInstance();
                logger.trace("EXIT:");
                return insertionResult3;
            }
            Link curR = null;
            try {
                Object obj = this.futures.get(reqNo, SETR_TIMEOUT);
                if (obj instanceof Link) {
                    curR = (Link)obj;
                }
            }
            catch (TimeoutException e) {
                logger.info("{}: insertion timed-out", (Object)this.key);
            }
            this.protoLock.writeLock().lock();
            switch (this.mode) {
                case IN: {
                    this.protoLock.writeLock().unlock();
                    insertionResult = InsertionResult.getSuccessInstance();
                    return insertionResult;
                }
                case OUT: 
                case INS: {
                    this.setMode(Mode.OUT);
                    this.setLeftNum(this.lNum.gnext());
                    this.protoLock.writeLock().unlock();
                    this.askRemoteNodeToRemoveMe(this.right);
                    break;
                }
                default: {
                    this.protoLock.writeLock().unlock();
                }
            }
            if (curR != null) {
                insertionResult = new InsertionResult(false, new InsertPoint(p.left, curR));
                return insertionResult;
            }
            insertionResult = InsertionResult.getFailureInstance();
            return insertionResult;
        }
        finally {
            logger.trace("EXIT:");
        }
    }

    private void askRemoteNodeToRemoveMe(Link remote) {
        logger.debug("ask {} to remove me", (Object)remote);
        try {
            NodeManagerIf stub = this.getStub(remote.addr);
            stub.startFix(remote.key, this.me, true);
        }
        catch (RPCException e) {
            logger.error("", e.getCause());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delete(int maxRetry) throws IllegalStateException {
        if (this.mode != Mode.IN) {
            throw new IllegalStateException("already deleted");
        }
        boolean rc = false;
        try {
            for (int i = 0; i < maxRetry; ++i) {
                if (i != 0) {
                    this.sleepForRetry(i);
                }
                logger.debug("trying to delete {}, i={}", (Object)this, (Object)i);
                rc = this.delete0();
                if (!rc) continue;
                break;
            }
        }
        catch (OfflineSendException e) {
            logger.info("delete failed as offline");
        }
        finally {
            this.reset();
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean delete0() throws OfflineSendException {
        logger.trace("ENTRY:");
        this.protoLock.writeLock().lock();
        try {
            NodeManagerIf stub;
            int reqNo;
            if (this.me.equals(this.right) && this.me.equals(this.left)) {
                this.reset();
                boolean bl = true;
                return bl;
            }
            if (this.mode != Mode.DEL) {
                this.setMode(Mode.DEL);
            }
            this.currentReqNo = reqNo = this.futures.newFuture();
            try {
                stub = this.getStub(this.left.addr);
                stub.setR(this.left.key, this.me, reqNo, this.right, this.me, this.rNum.next(), 0, null);
            }
            catch (RPCException e) {
                this.futures.discardFuture(reqNo);
                if (e instanceof OfflineSendException) {
                    throw (OfflineSendException)e;
                }
                logger.error("", e.getCause());
                boolean bl = false;
                this.protoLock.writeLock().unlock();
                logger.trace("EXIT:");
                return bl;
            }
            logger.debug("waiting, reqNo={}", (Object)reqNo);
            this.protoLock.writeLock().unlock();
            try {
                this.futures.get(reqNo, SETR_TIMEOUT);
            }
            catch (TimeoutException e) {
                logger.info("waiting for SetRAck/Nak timed-out: {}", (Object)this.key);
            }
            this.protoLock.writeLock().lock();
            switch (this.mode) {
                case OUT: {
                    boolean e = true;
                    return e;
                }
                case GRACE: {
                    if (this.ref != 0) break;
                    this.setMode(Mode.OUT);
                    logger.debug("ref is already 0. send unrefL to {}", (Object)this.left);
                    try {
                        stub = this.getStub(this.left.addr);
                        stub.unrefL(this.left.key, this.me);
                    }
                    catch (RPCException e) {
                        if (e instanceof OfflineSendException) {
                            throw (OfflineSendException)e;
                        }
                        logger.error("", e.getCause());
                    }
                    boolean e = true;
                    return e;
                }
                case DELWAIT: {
                    boolean e = false;
                    return e;
                }
                case DEL: {
                    try {
                        this.sendSetL(this.right, this.left, this.rNum.next(), this.me, false);
                    }
                    catch (RPCException e2) {
                        if (e2 instanceof OfflineSendException) {
                            throw (OfflineSendException)e2;
                        }
                        logger.error("", e2.getCause());
                    }
                    this.setMode(Mode.GRACE);
                    break;
                }
            }
            logger.debug("waiting for unrefL");
            try {
                this.protoCond.await(DELETE_OP_TIMEOUT, TimeUnit.MILLISECONDS);
                logger.debug("condwait done, mode={}", (Object)this.mode);
            }
            catch (InterruptedException e1) {
                logger.debug("condwait interrupted {}", (Object)this.mode);
            }
            if (this.mode != Mode.OUT) {
                this.setMode(Mode.OUT);
                logger.debug("unrefL timed-out. send unrefL to {}", (Object)this.left);
                try {
                    stub = this.getStub(this.left.addr);
                    stub.unrefL(this.left.key, this.me);
                }
                catch (RPCException e) {
                    if (e instanceof OfflineSendException) {
                        throw (OfflineSendException)e;
                    }
                    logger.error("", e.getCause());
                }
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.protoLock.writeLock().unlock();
            logger.trace("EXIT:");
        }
    }

    private void sleepForRetry(int n) {
        this.protoLock.writeLock().lock();
        try {
            long t = (long)(((double)n + Math.random() * 0.1) * 200.0);
            logger.debug("{}th retry after {}ms", (Object)n, (Object)t);
            this.protoCond.await(t, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.protoLock.writeLock().unlock();
    }

    private InsertPoint findInsertPoint(Link introducer, DdllKey searchKey, int maxHops) throws OfflineSendException {
        Link next = introducer;
        Link prevKey = null;
        for (int i = 0; i < maxHops; ++i) {
            logger.debug("findInsertPoint: [{}]: i = {}, next = {}", new Object[]{this.key, i, next});
            int reqNo = this.futures.newFuture();
            try {
                NodeManagerIf stub = this.getStub(next.addr);
                stub.findNearest(next.key, this.me, reqNo, searchKey, prevKey);
            }
            catch (RPCException e) {
                this.futures.discardFuture(reqNo);
                if (e instanceof OfflineSendException) {
                    throw (OfflineSendException)e;
                }
                logger.error("", e.getCause());
                return null;
            }
            try {
                Object result = this.futures.get(reqNo, SEARCH_OP_TIMEOUT);
                if (result instanceof InsertPoint) {
                    InsertPoint rc = (InsertPoint)result;
                    if (rc.left == null) {
                        logger.debug("findInsertPoint: remote node is out: {}", (Object)next);
                        return null;
                    }
                    return rc;
                }
                if (!(result instanceof Object[])) {
                    logger.error("illegal result");
                    return null;
                }
                next = (Link)((Object[])result)[0];
                prevKey = (Link)((Object[])result)[1];
                continue;
            }
            catch (TimeoutException e) {
                logger.warn("{}: no response from {} for findNearest request", (Object)this, (Object)next);
                return null;
            }
        }
        logger.warn("over max hops");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setR(Link sender, int reqNo, Link rNew, Link rCur, LinkNum rNewNum, int type, Object payload) {
        block22: {
            this.protoLock.writeLock().lock();
            logger.trace("ENTRY:");
            logger.debug("receive SetR(rNew={}, rCur={}, rNewNum={}, type={}, payload={})", new Object[]{rNew, rCur, rNewNum, type, payload});
            logger.debug("node status {}", (Object)this);
            try {
                NodeManagerIf stub;
                if (this.mode == Mode.OUT) {
                    logger.warn("setR received while mode is OUT, ignored");
                    return;
                }
                if (this.mode != Mode.IN && this.mode != Mode.DELWAIT || !this.right.equals(rCur)) {
                    try {
                        NodeManagerIf stub2 = this.getStub(sender.addr);
                        Link r = this.mode != Mode.IN && this.mode != Mode.DELWAIT ? null : this.right;
                        stub2.setRNak(sender.key, this.me, reqNo, r);
                    }
                    catch (Throwable e) {
                        this.handleRPCException("setR", "setRNak", e);
                    }
                    break block22;
                }
                Link prevRight = this.right;
                LinkNum oldNum = this.rNum;
                this.setRight(rNew);
                this.setRightNum(rNewNum);
                if (type != 1) {
                    this.setRef(this.ref + 1);
                }
                boolean forInsertion = sender.equals(rNew);
                if (type != 0) {
                    this.leftNbrs.removeNode(rCur);
                    this.leftNbrs.add(rNew);
                } else if (forInsertion) {
                    this.leftNbrs.add(rNew);
                } else {
                    this.leftNbrs.removeNode(rCur);
                }
                Set<Link> nset = this.leftNbrs.computeNSForRight(rNew);
                this.leftNbrs.setPrevRightSet(rNew, nset);
                try {
                    stub = this.getStub(sender.addr);
                    stub.setRAck(sender.key, this.me, reqNo, oldNum, nset);
                }
                catch (Throwable e) {
                    this.handleRPCException("setR", "setRAck", e);
                }
                try {
                    if (forInsertion) {
                        if (type != 1) {
                            stub = this.getStub(prevRight.addr);
                            Set<Link> nset2 = this.leftNbrs.computeNSForRight(prevRight);
                            logger.debug("sending SetL nset2={}", nset2);
                            stub.setL(prevRight.key, rNew, oldNum.next(), this.me, nset2);
                        }
                    } else {
                        logger.debug("sending SetL nset={}", nset);
                        stub = this.getStub(rNew.addr);
                        stub.setL(rNew.key, this.me, rNewNum, prevRight, nset);
                    }
                }
                catch (Throwable e) {
                    this.handleRPCException("setR", "setL", e);
                }
                if (this.observer != null) {
                    this.protoLock.writeLock().unlock();
                    this.observer.onRightNodeChange(rCur, rNew, payload);
                }
            }
            finally {
                logger.trace("EXIT:");
                if (this.protoLock.isWriteLockedByCurrentThread()) {
                    this.protoLock.writeLock().unlock();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setRAck(Link sender, int reqNo, LinkNum zNum, Set<Link> nbrs) {
        this.protoLock.writeLock().lock();
        logger.trace("ENTRY:");
        logger.debug("receive SetRAck(sender={}, reqNo={}, zNum={}, nbrs={}) from {}", new Object[]{sender, reqNo, zNum, nbrs, sender});
        try {
            if (!sender.equals(this.left)) {
                logger.info("sender node is not current left node, mode {}", (Object)this.mode);
            }
            if (reqNo == 0) {
                if (this.fixState == FIX_STATE.FIXING_BOTH || this.fixState == FIX_STATE.FIXING_LEFTONLY) {
                    logger.info("setRAck received from {}, fixState={}", (Object)sender, (Object)this.fixState);
                    if (this.fixState == FIX_STATE.FIXING_BOTH) {
                        this.setRightNum(zNum.next());
                        this.setRef(1);
                    }
                    this.fixDone();
                    this.leftNbrs.set(nbrs);
                    this.leftNbrs.add(this.left);
                    this.leftNbrs.sendRight(this.key, this.right, sender.key);
                    return;
                } else {
                    logger.debug("staled setRAck for recovery. dropped");
                }
                return;
            }
            if (this.futures.expired(reqNo)) {
                logger.info("reqNo {} has been expired", (Object)reqNo);
                return;
            }
            if (reqNo != this.currentReqNo) {
                logger.debug("staled setRAck (reqNo={}, current={}). dropped", (Object)reqNo, (Object)this.currentReqNo);
                return;
            }
            switch (this.mode) {
                case INS: {
                    this.setMode(Mode.IN);
                    this.setRightNum(zNum.next());
                    this.setRef(1);
                    this.leftNbrs.set(nbrs);
                    this.leftNbrs.add(this.left);
                    this.futures.set(reqNo);
                    return;
                }
                case DEL: {
                    this.setMode(Mode.GRACE);
                    this.futures.set(reqNo);
                    return;
                }
                default: {
                    if (this.expectDelayedResponse) {
                        logger.debug("maybe received a delayed SetRAck");
                        return;
                    } else {
                        logger.warn("mode={} when SetRAck is received", (Object)this.mode);
                    }
                    return;
                }
            }
        }
        finally {
            logger.trace("EXIT:");
            this.protoLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setRNak(Link sender, int reqNo, Link curR) {
        this.protoLock.writeLock().lock();
        logger.trace("ENTRY:");
        logger.debug("receive SetRNak(sender={}, reqNo={})", (Object)sender, (Object)reqNo);
        try {
            if (reqNo != 0 && this.futures.expired(reqNo)) {
                logger.info("setR is expired in setRNak");
                return;
            }
            if (this.fixState == FIX_STATE.FIXING_BOTH || this.fixState == FIX_STATE.FIXING_LEFTONLY) {
                logger.info("setRNak received from {}, fixState={}", (Object)sender, (Object)this.fixState);
                this.fixDone();
                return;
            }
            switch (this.mode) {
                case INS: {
                    if (!sender.equals(this.left)) {
                        logger.warn("received SetRNak from unexpected sender {}, ignored", (Object)sender);
                        return;
                    } else {
                        this.setMode(Mode.INSWAIT);
                        if (reqNo == 0) return;
                        this.futures.set(reqNo, curR);
                        return;
                    }
                }
                case DEL: {
                    this.setMode(Mode.DELWAIT);
                    if (reqNo != 0) {
                        this.futures.set(reqNo);
                    }
                    this.protoCond.signalAll();
                    return;
                }
                default: {
                    if (this.expectDelayedResponse) {
                        logger.debug("maybe received a delayed SetRNak");
                        return;
                    } else {
                        logger.warn("illegal mode: {} in setRNak", (Object)this.mode);
                    }
                    return;
                }
            }
        }
        finally {
            logger.trace("EXIT:");
            this.protoLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setL(Link lNew, LinkNum lNewNum, Link prevL, Set<Link> nbrs) {
        this.protoLock.writeLock().lock();
        logger.trace("ENTRY:");
        logger.debug("receive SetL(lNew={}, lNewNum={}, prevL={}, nbrs={})", new Object[]{lNew, lNewNum, prevL, nbrs});
        try {
            if (this.mode == Mode.OUT) {
                logger.warn("mode is OUT in setL");
                return;
            }
            boolean leftChanged = false;
            if (this.lNum.compareTo(lNewNum) < 0) {
                this.setLeft(lNew);
                this.setLeftNum(lNewNum);
                leftChanged = true;
            } else {
                logger.info("SetL ignored (lNum={}, lNewNum={})", (Object)this.lNum, (Object)lNewNum);
            }
            try {
                NodeManagerIf stub = this.getStub(prevL.addr);
                stub.unrefL(prevL.key, this.me);
            }
            catch (Throwable e) {
                this.handleRPCException("setL", "unrefL", e);
            }
            if (!leftChanged) {
                return;
            }
            nbrs.add(lNew);
            this.leftNbrs.set(nbrs);
            if (Node.isOrdered(prevL.key, lNew.key, this.key)) {
                this.leftNbrs.sendRight(this.key, this.right, prevL.key);
            } else {
                this.leftNbrs.sendRight(this.key, this.right, lNew.key);
            }
            if (this.mode == Mode.INSWAIT || this.mode == Mode.DELWAIT) {
                logger.debug("wakeup insert or delete thread");
                this.protoCond.signalAll();
            }
            if (this.mode == Mode.DEL) {
                if (this.me.equals(this.right) && this.me.equals(this.left)) {
                    logger.info("SetL received while mode=DEL, case l=u=r");
                    this.setMode(Mode.OUT);
                    this.setLeft(null);
                    this.setRight(null);
                    this.futures.set(this.currentReqNo);
                    this.expectDelayedResponse = true;
                    this.protoCond.signalAll();
                } else if (this.me.equals(this.left)) {
                    logger.info("SetL received while mode is DEL (l == u)");
                    this.setMode(Mode.GRACE);
                    this.futures.set(this.currentReqNo);
                    this.expectDelayedResponse = true;
                    this.protoCond.signalAll();
                    try {
                        this.sendSetL(this.right, this.left, this.rNum.next(), this.me, true);
                    }
                    catch (Throwable e) {
                        this.handleRPCException("setL", "setL", e);
                    }
                } else {
                    logger.info("SetL received while mode is DEL (l != u)");
                    this.setMode(Mode.DELWAIT);
                    this.futures.set(this.currentReqNo);
                    this.expectDelayedResponse = true;
                    this.protoCond.signalAll();
                }
            }
        }
        finally {
            logger.debug("SetL() finished: {}", (Object)this);
            logger.trace("EXIT:");
            this.protoLock.writeLock().unlock();
        }
    }

    public void unrefL(Link sender) {
        block11: {
            this.protoLock.writeLock().lock();
            logger.trace("ENTRY:");
            logger.debug("receives UnrefL from {}", (Object)sender);
            try {
                if (this.ref > 0) {
                    this.setRef(this.ref - 1);
                }
                logger.debug("ref={}, mode={}", (Object)this.ref, (Object)this.mode);
                if (this.ref != 0) break block11;
                if (this.mode == Mode.DEL) {
                    return;
                }
                if (this.mode != Mode.GRACE) {
                    logger.warn("ref = 0 but mode != {DEL, GRACE}");
                    return;
                }
                if (this.sendLastUnrefL) {
                    logger.debug("send the last unrefL to {}", (Object)this.left);
                    try {
                        NodeManagerIf stub = this.getStub(this.left.addr);
                        stub.unrefL(this.left.key, this.me);
                    }
                    catch (Throwable e) {
                        this.handleRPCException("unrefL", "unrefL", e);
                    }
                }
                this.setMode(Mode.OUT);
                this.setLeft(null);
                this.setRight(null);
                this.protoCond.signalAll();
            }
            finally {
                logger.trace("EXIT:");
                this.protoLock.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFindResult(int reqNo, Link left, Link right) {
        this.protoLock.readLock().lock();
        try {
            this.futures.set(reqNo, new InsertPoint(left, right));
        }
        finally {
            this.protoLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFindNext(int reqNo, Link next, Link prevKey) {
        this.protoLock.readLock().lock();
        try {
            this.futures.set(reqNo, new Object[]{next, prevKey});
        }
        finally {
            this.protoLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void findNearest(Link sender, int reqNo, DdllKey searchKey, Link prevKey) {
        this.protoLock.readLock().lock();
        logger.trace("ENTRY:");
        logger.debug("receive findNearest(sender={}, reqNo={}, searchKey={}, prevKey={})", new Object[]{sender, reqNo, searchKey, prevKey});
        try {
            if (this.mode == Mode.OUT) {
                logger.warn("mode is OUT in findNearest ({}->{})", (Object)sender, (Object)this.me);
                try {
                    NodeManagerIf stub = this.getStub(sender.addr);
                    stub.setFindResult(sender.key, reqNo, null, null);
                }
                catch (Throwable e) {
                    this.handleRPCException("findNearest", "setFindResult", e);
                }
                return;
            }
            if (prevKey == null) {
                Link link = prevKey = keyComp.compare(this.key, searchKey) < 0 ? this.left : this.right;
            }
            if (this.mode != Mode.GRACE && Node.isOrdered(this.key, searchKey, this.right.key)) {
                try {
                    NodeManagerIf stub = this.getStub(sender.addr);
                    stub.setFindResult(sender.key, reqNo, this.me, this.right);
                }
                catch (Throwable e) {
                    this.handleRPCException("findNearest", "setFindResult", e);
                }
            } else if (this.mode != Mode.GRACE && Node.isOrdered(this.key, searchKey, prevKey.key)) {
                try {
                    NodeManagerIf stub = this.getStub(sender.addr);
                    stub.setFindNext(sender.key, reqNo, this.right, prevKey);
                }
                catch (Throwable e) {
                    this.handleRPCException("findNearest", "setFindNext", e);
                }
            } else {
                try {
                    NodeManagerIf stub = this.getStub(sender.addr);
                    stub.setFindNext(sender.key, reqNo, this.left, this.me);
                }
                catch (Throwable e) {
                    this.handleRPCException("findNearest", "setFindNext", e);
                }
            }
        }
        finally {
            logger.trace("EXIT:");
            this.protoLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getStat(Link sender, int reqNo) {
        this.protoLock.readLock().lock();
        try {
            if (this.mode == Mode.OUT) {
                logger.warn("mode is OUT in getStat ({}->{})", (Object)sender, (Object)this.me);
                return;
            }
            if (this.mode == Mode.IN && (this.left == null || this.right == null)) {
                logger.warn("getStat: something wrong: {}", (Object)this.me);
            }
            try {
                NodeManagerIf stub = this.getStub(sender.addr);
                stub.setStat(sender.key, reqNo, new Stat(this.mode, this.me, this.left, this.right, this.rNum));
            }
            catch (Throwable e) {
                this.handleRPCException("getStat", "setStat", e);
            }
        }
        finally {
            this.protoLock.readLock().unlock();
        }
    }

    Stat getStatNew() {
        this.protoLock.readLock().lock();
        try {
            Stat stat = new Stat(this.mode, this.me, this.left, this.right, this.rNum);
            return stat;
        }
        finally {
            this.protoLock.readLock().unlock();
        }
    }

    void setStat(int reqNo, Stat stat) {
        this.protoLock.readLock().lock();
        try {
            this.futures.set(reqNo, stat);
        }
        finally {
            this.protoLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void propagateNeighbors(DdllKey src, Set<Link> newset, DdllKey limit) {
        this.protoLock.readLock().lock();
        logger.trace("ENTRY:");
        logger.debug("receive propagateNeighbors(src={}, newset={}, limit={})", new Object[]{src, newset, limit});
        try {
            this.leftNbrs.receiveNeighbors(src, newset, this.right, limit);
        }
        finally {
            this.protoLock.readLock().unlock();
        }
    }

    void sendSetL(Link dest, Link lNew, LinkNum lNewNum, Link lPrev, boolean isInserted) throws RPCException {
        Set<Link> nset = this.leftNbrs.computeNSForRight(dest);
        this.leftNbrs.setPrevRightSet(dest, nset);
        NodeManagerIf stub = this.getStub(dest.addr);
        stub.setL(dest.key, lNew, lNewNum, lPrev, nset);
    }

    void onNodeFailure(Collection<Link> failedLinks) {
        this.protoLock.readLock().lock();
        try {
            if (this.mode != Mode.IN && this.mode != Mode.DELWAIT) {
                logger.debug("onNodeFailure: not inserted");
                return;
            }
        }
        finally {
            this.protoLock.readLock().unlock();
        }
        if (this.observer != null) {
            boolean rc = this.observer.onNodeFailure(failedLinks);
            if (rc) {
                this.startFix(failedLinks);
            }
        } else {
            this.startFix(failedLinks);
        }
    }

    public void startFix(Link failed, boolean force) {
        this.startfix(Collections.singleton(failed), null, force);
    }

    public void startFix(Link failed) {
        this.startFix(failed, false);
    }

    public void startFix(Collection<Link> failedLinks) {
        this.startfix(failedLinks, null, false);
    }

    public void startfix(Collection<Link> failedLinks, Object payload) {
        this.startfix(failedLinks, payload, false);
    }

    public void startfix(final Collection<Link> failedLinks, final Object payload, boolean force) {
        Link left = this.getLeft();
        if (left == null || !force && !failedLinks.contains(left)) {
            logger.debug("startfix: no fix: {}", failedLinks);
            if (this.observer != null && payload != null) {
                this.observer.payloadNotSent(payload);
            }
            return;
        }
        this.leftNbrs.removeNodes(failedLinks);
        Thread th = new Thread(THREAD_NAME_PREFIX + thNum.getAndIncrement()){

            @Override
            public void run() {
                try {
                    logger.debug("start fixing (failedKeys = {})", (Object)failedLinks);
                    Node.this.fix(failedLinks, payload);
                }
                catch (OfflineSendException offlineSendException) {
                    // empty catch block
                }
            }
        };
        int num = this.fixCount.getAndIncrement();
        th.setName("FIX" + this.key + "(fail=" + failedLinks + ")#" + num);
        th.start();
    }

    void statReceived(Stat s) {
        this.protoLock.readLock().lock();
        if ((this.mode == Mode.IN || this.mode == Mode.DELWAIT) && this.getLeft().equals(s.me)) {
            if (this.me.equals(s.right)) {
                logger.trace("ENTRY:");
            } else {
                logger.debug("statReceived: mismatch with left node: {}", (Object)s);
                Thread th = new Thread(THREAD_NAME_PREFIX + thNum.getAndIncrement()){

                    @Override
                    public void run() {
                        try {
                            Node.this.fix(null, null);
                        }
                        catch (OfflineSendException offlineSendException) {
                            // empty catch block
                        }
                    }
                };
                th.setName("FIX" + this.key + "(mismatch)" + thNum.getAndIncrement());
                th.start();
            }
        } else {
            logger.debug("statReceived: ignore: {}", (Object)s);
        }
        this.protoLock.readLock().unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fix(final Collection<Link> failed, Object payload) throws OfflineSendException {
        logger.debug("fix(failed={})", failed);
        logger.debug("node status: {}", (Object)this);
        boolean callObserver = false;
        this.protoLock.writeLock().lock();
        if (this.fixState != FIX_STATE.WAITING) {
            block38: {
                try {
                    logger.debug("another thread is fixing: {}", (Object)this.fixState);
                    if (this.observer == null || payload == null) break block38;
                    while (this.fixState != FIX_STATE.WAITING) {
                        logger.debug("waiting (fixState = {})", (Object)this.fixState);
                        try {
                            this.protoCond.await();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        logger.debug("waiting done");
                    }
                    callObserver = true;
                }
                finally {
                    this.protoLock.writeLock().unlock();
                }
            }
            if (callObserver) {
                this.observer.payloadNotSent(payload);
            }
            return;
        }
        try {
            int type;
            Stat v;
            this.fixState = FIX_STATE.CHECKING;
            if (this.mode != Mode.IN && this.mode != Mode.DELWAIT && this.mode != Mode.GRACE) {
                logger.debug("node is not fully inserted (1)");
                return;
            }
            this.protoLock.writeLock().unlock();
            if (System.currentTimeMillis() - this.lastFix < (long)MIN_FIX_INTERVAL) {
                logger.debug("delay {}ms", (Object)MIN_FIX_INTERVAL);
                try {
                    Thread.sleep(MIN_FIX_INTERVAL);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            logger.debug("searching new left node candidates");
            try {
                v = this.findLiveLeft(failed);
                logger.debug("fix(): findLiveLeft returns: {}", (Object)v);
                if (v == null) {
                    if (this.mode == Mode.IN || this.mode == Mode.DELWAIT) {
                        logger.warn("could not find any live node: {}", (Object)this.leftNbrs);
                    }
                    return;
                }
            }
            finally {
                this.protoLock.writeLock().lock();
            }
            logger.debug("status: {}", (Object)this);
            if (this.mode != Mode.IN && this.mode != Mode.DELWAIT && this.mode != Mode.GRACE) {
                logger.debug("node is not fully inserted (2)");
                return;
            }
            if (this.mode == Mode.GRACE) {
                if (!this.left.equals(v.me)) {
                    this.setLeft(v.me);
                    this.sendLastUnrefL = false;
                }
                return;
            }
            if (v.me.equals(this.left) && v.right.equals(this.me) && this.lNum.equals(v.rNum)) {
                if (payload != null) {
                    callObserver = true;
                    logger.debug("SetR not send payload");
                }
                return;
            }
            this.setLeft(v.me);
            this.setLeftNum(this.lNum.gnext());
            if (Node.isOrdered(v.me.key, this.key, v.right.key)) {
                this.fixState = FIX_STATE.FIXING_BOTH;
                type = 2;
                this.setRight(v.right);
                logger.debug("fix between {} and {}", (Object)v.me, (Object)v.right);
            } else {
                this.fixState = FIX_STATE.FIXING_LEFTONLY;
                type = 1;
                logger.debug("fix left link only");
            }
            logger.info("send SetR to {} for recovery", (Object)this.left);
            try {
                NodeManagerIf stub = this.getStub(this.left.addr);
                stub.setR(this.left.key, this.me, 0, this.me, v.right, this.lNum, type, payload);
            }
            catch (RPCException e) {
                if (e instanceof OfflineSendException) {
                    throw (OfflineSendException)e;
                }
                logger.error("", e.getCause());
            }
            this.fixTask = new TimerTask(){

                @Override
                public void run() {
                    logger.debug("fixTask#run");
                    boolean retry = false;
                    Node.this.protoLock.writeLock().lock();
                    if (Node.this.fixState == FIX_STATE.FIXING_BOTH || Node.this.fixState == FIX_STATE.FIXING_LEFTONLY) {
                        logger.debug("no SetRAck/SetRNak is received within SETR_TIMEOUT");
                        Node.this.fixTask = null;
                        retry = true;
                        Node.this.fixDone();
                    }
                    Node.this.protoLock.writeLock().unlock();
                    if (retry) {
                        HashSet<Link> f = new HashSet<Link>();
                        if (failed != null) {
                            f.addAll(failed);
                        }
                        f.add(Node.this.left);
                        Node.this.startFix(f);
                    }
                }
            };
            this.stabilizeTimer.schedule(this.fixTask, SETR_TIMEOUT);
        }
        finally {
            if (this.fixState == FIX_STATE.CHECKING) {
                this.fixDone();
                assert (this.fixState == FIX_STATE.WAITING);
            }
            this.lastFix = System.currentTimeMillis();
            this.protoLock.writeLock().unlock();
            if (callObserver && this.observer != null && payload != null) {
                this.observer.payloadNotSent(payload);
            }
            logger.debug("fix() finished");
        }
    }

    private void fixDone() {
        assert (this.protoLock.isWriteLockedByCurrentThread());
        this.fixState = FIX_STATE.WAITING;
        logger.debug("fixDone: {}", (Object)this);
        this.protoCond.signalAll();
    }

    private Stat findLiveLeft(Collection<Link> failedLinks) throws OfflineSendException {
        Stat s = this.findLiveLeft0(failedLinks);
        logger.debug("findLiveLeft1 returns {}", (Object)s);
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Stat findLiveLeft0(Collection<Link> failedLinks) throws OfflineSendException {
        List<Link> ext;
        HashMap<Link, Stat> stats = new HashMap<Link, Stat>();
        if (failedLinks != null) {
            for (Link failed : failedLinks) {
                stats.put(failed, null);
            }
        }
        NeighborSet cands = new NeighborSet(this.me, this.manager, Integer.MAX_VALUE);
        cands.addAll(this.leftNbrs.getNeighbors());
        cands.add(this.me);
        cands.add(this.right);
        Set<Link> others = this.manager.getAllLinksById(this.key.id);
        others.remove(this.me);
        if (others.size() > 0) {
            logger.debug("add other keys: {}", others);
            cands.addAll(others);
        }
        if (this.observer != null && (ext = this.observer.suppplyLeftCandidatesForFix()) != null) {
            logger.debug("add external keys: {}", others);
            cands.addAll(ext);
        }
        logger.info("stock left nodes: {}", (Object)cands);
        ArrayList<Link> nbrs = new ArrayList<Link>(cands.getNeighbors());
        Link n = null;
        for (Link node : nbrs) {
            logger.debug("checking {}", (Object)node);
            if (node.key.primaryKey.equals(this.me.key.primaryKey) && node.addr.equals(this.me.addr) && !node.equals(this.me)) continue;
            Stat s = this.callGetStat(node);
            stats.put(node, s);
            logger.debug("results from {} is {}", (Object)node, (Object)s);
            if (s == null) {
                this.leftNbrs.removeNode(node);
                continue;
            }
            logger.debug("{}: findLiveLeft: got stat {}", (Object)this.me, (Object)s);
            if (s.mode != Mode.IN && s.mode != Mode.DELWAIT) continue;
            n = node;
            break;
        }
        if (n == null) {
            if (nbrs.size() > 0) {
                logger.warn("{}: findLiveLeft could not find any IN nor DELWAIT node. (nbrs={})", (Object)this.me, nbrs);
            }
            this.protoLock.readLock().lock();
            try {
                if (this.mode != Mode.IN && this.mode != Mode.DELWAIT) {
                    logger.debug("{}: findLiveLeft1: noticed i've left", (Object)this.me);
                    Iterator iterator = null;
                    return iterator;
                }
                n = this.me;
                stats.put(n, new Stat(this.mode, this.me, this.left, this.right, this.rNum));
            }
            finally {
                this.protoLock.readLock().unlock();
            }
        }
        logger.debug("traversing rightward from {}", n);
        while (true) {
            Stat nstat = (Stat)stats.get(n);
            Link nr = nstat.right;
            if (nr.key.compareTo(this.key) == 0) {
                return nstat;
            }
            if (n.key.compareTo(this.key) != 0 && Node.isOrdered(n.key, this.key, nr.key)) {
                return nstat;
            }
            if (stats.containsKey(nr)) {
                if (stats.get(nr) == null) {
                    return (Stat)stats.get(n);
                }
                n = nr;
                continue;
            }
            logger.info("{}: findLiveLeft found new node {}", (Object)this.me, (Object)nr);
            Stat nrstat = this.callGetStat(nr);
            if (nrstat == null) {
                return (Stat)stats.get(n);
            }
            logger.info("{}: findLiveLeft new node stat {}", (Object)this.me, (Object)nrstat);
            stats.put(nr, nrstat);
            this.leftNbrs.add(nr);
            n = nr;
        }
    }

    private void handleRPCException(String method, String rpc, Throwable e) {
        if (e instanceof OfflineSendException) {
            logger.warn("{}: calling RPC({}) failed (I'm offline)", (Object)method, (Object)rpc);
        } else if (e instanceof RPCException) {
            logger.error("", e.getCause());
        } else {
            logger.error("", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Stat callGetStat(Link node) throws OfflineSendException {
        logger.trace("ENTRY:");
        try {
            int reqNo = this.futures.newFuture();
            try {
                logger.debug("calling getStat() on node {}", (Object)node);
                NodeManagerIf stub = this.getStub(node.addr);
                stub.getStat(node.key, this.me, reqNo);
            }
            catch (RPCException e) {
                logger.debug("got RPCException {}", (Object)e.toString());
                this.futures.discardFuture(reqNo);
                if (e instanceof OfflineSendException) {
                    throw (OfflineSendException)e;
                }
                logger.error("", e.getCause());
                Stat stat = null;
                logger.trace("EXIT:");
                return stat;
            }
            logger.debug("waiting on reqNo {}", (Object)reqNo);
            Object result = this.futures.get(reqNo, GETSTAT_OP_TIMEOUT);
            logger.debug("got result {}", result);
            if (result instanceof Stat) {
                Stat stat = (Stat)result;
                return stat;
            }
            logger.error("illegal result");
            Stat stat = null;
            return stat;
        }
        finally {
            logger.trace("EXIT:");
        }
    }

    static {
        SETR_TIMEOUT = DEFAULT_TIMEOUT = 5000;
        DELETE_OP_TIMEOUT = DEFAULT_TIMEOUT;
        SEARCH_OP_TIMEOUT = DEFAULT_TIMEOUT;
        GETSTAT_OP_TIMEOUT = DEFAULT_TIMEOUT;
        MIN_FIX_INTERVAL = 500;
        DEFAULT_CHECK_PERIOD = 10000;
        keyComp = KeyComparator.getInstance();
    }

    public static class InsertionResult {
        public final boolean success;
        public final InsertPoint hint;
        private static InsertionResult successInstance = new InsertionResult(true);
        private static InsertionResult failureInstance = new InsertionResult(false);

        public static InsertionResult getSuccessInstance() {
            return successInstance;
        }

        public static InsertionResult getFailureInstance() {
            return failureInstance;
        }

        private InsertionResult(boolean success) {
            this(success, null);
        }

        public InsertionResult(boolean success, InsertPoint hint) {
            this.success = success;
            this.hint = hint;
        }

        public String toString() {
            return "[" + this.success + ", hint=" + this.hint + "]";
        }
    }

    public static class InsertPoint
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public final Link left;
        public final Link right;

        public InsertPoint(Link left, Link right) {
            this.left = left;
            this.right = right;
        }

        public String toString() {
            return "[" + this.left + ", " + this.right + "]";
        }
    }

    static enum FIX_STATE {
        WAITING,
        CHECKING,
        FIXING_BOTH,
        FIXING_LEFTONLY;

    }

    public static enum Mode {
        OUT,
        INS,
        INSWAIT,
        IN,
        DEL,
        DELWAIT,
        GRACE;

    }
}

