/*
 * Decompiled with CFR 0.152.
 */
package org.piax.gtrans.ov.ddll;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import org.piax.common.Endpoint;
import org.piax.gtrans.RPCException;
import org.piax.gtrans.ov.ddll.DdllKey;
import org.piax.gtrans.ov.ddll.Link;
import org.piax.gtrans.ov.ddll.Node;
import org.piax.gtrans.ov.ddll.NodeManager;
import org.piax.gtrans.ov.ddll.NodeManagerIf;
import org.piax.gtrans.ov.ddll.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeMonitor {
    private static final Logger logger = LoggerFactory.getLogger(NodeMonitor.class);
    public static int PING_TIMEOUT = 20000;
    final NodeManager manager;
    final Endpoint myLocator;
    final Timer timer;
    final Map<Endpoint, NodeMon> map = new HashMap<Endpoint, NodeMon>();

    public NodeMonitor(NodeManager manager, Timer timer) {
        this.manager = manager;
        this.timer = timer;
        this.myLocator = manager.getLocator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder buf = new StringBuilder("NodeMonitor at " + this.myLocator + "\n");
        for (Map.Entry<Endpoint, NodeMon> ent : this.map.entrySet()) {
            NodeMon mon;
            NodeMon nodeMon = mon = ent.getValue();
            synchronized (nodeMon) {
                buf.append(ent.getKey() + ": " + ent.getValue());
                if (mon.task != null) {
                    buf.append(": sched " + (mon.task.scheduledExecutionTime() - System.currentTimeMillis()));
                }
                buf.append("\n");
            }
        }
        return buf.toString();
    }

    synchronized void registerNode(Link remote, Node listener, int checkPeriod) {
        logger.debug("{}: register remote={}, node={}", new Object[]{this.myLocator, remote, listener});
        NodeMon mon = this.map.get(remote.addr);
        if (mon == null) {
            mon = new NodeMon(remote.addr);
            this.map.put(remote.addr, mon);
        }
        mon.add(remote.key, listener, checkPeriod);
        logger.trace("registerNode\n{}\n{}", (Object)this, (Object)mon);
    }

    synchronized void unregisterNode(Link remote, Node listener) {
        logger.debug("NodeMonitor: {}: unregister remote={}, node={}", new Object[]{this.myLocator, remote, listener});
        NodeMon mon = this.map.get(remote.addr);
        if (mon == null) {
            throw new Error("unregister failed");
        }
        mon.remove(remote.key, listener);
        if (mon.keylisteners.size() == 0) {
            this.map.remove(remote.addr);
        }
        logger.trace("unregisterNode\n{}\n{}", (Object)this, (Object)mon);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setStatMulti(Endpoint sender, Stat[] stats) {
        NodeMon mon;
        logger.debug("setStatMutlti@{} is called from {}", (Object)this.myLocator, (Object)sender);
        NodeMonitor nodeMonitor = this;
        synchronized (nodeMonitor) {
            mon = this.map.get(sender);
        }
        if (mon != null) {
            mon.statReceived(stats);
        }
    }

    class NodeMon {
        final Endpoint locator;
        final NodeManagerIf stub;
        final ConcurrentHashMap<DdllKey, Set<NodeAndPeriod>> keylisteners = new ConcurrentHashMap();
        State state = State.INIT;
        TimerTask task;
        boolean first = true;

        NodeMon(Endpoint locator) {
            this.locator = locator;
            this.stub = (NodeManagerIf)NodeMonitor.this.manager.getStub(locator);
        }

        public String toString() {
            return "NodeMon: " + this.keylisteners.toString();
        }

        synchronized void add(DdllKey key, Node listener, int checkPeriod) {
            Set<NodeAndPeriod> listeners = this.keylisteners.get(key);
            if (listeners == null) {
                listeners = new HashSet<NodeAndPeriod>();
                this.keylisteners.put(key, listeners);
            }
            listeners.add(new NodeAndPeriod(listener, checkPeriod));
            if (this.state == State.INIT) {
                this.state = State.WAITING;
                this.schedulePing();
            }
            logger.debug("add: {}: {}", (Object)NodeMonitor.this.myLocator, this.keylisteners);
        }

        synchronized void remove(DdllKey key, Node listener) {
            Set<NodeAndPeriod> listeners = this.keylisteners.get(key);
            if (listeners == null) {
                throw new Error("listeners is null");
            }
            listeners.remove(new NodeAndPeriod(listener, 0));
            if (listeners.size() == 0) {
                this.keylisteners.remove(key);
                if (this.keylisteners.size() == 0 && this.task != null) {
                    this.task.cancel();
                }
            }
            logger.debug("remove:{}: {}", (Object)NodeMonitor.this.myLocator, this.keylisteners);
        }

        int getPeriod() {
            int p = Integer.MAX_VALUE;
            for (Map.Entry<DdllKey, Set<NodeAndPeriod>> k : this.keylisteners.entrySet()) {
                for (NodeAndPeriod np : k.getValue()) {
                    if (np.period >= p) continue;
                    p = np.period;
                }
            }
            return p;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void ping() {
            logger.debug("ping from {} to {}", (Object)NodeMonitor.this.manager.getLocator(), (Object)this.locator);
            NodeMon nodeMon = this;
            synchronized (nodeMon) {
                this.state = State.PINGSENT;
                if (this.task != null) {
                    this.task.cancel();
                }
                this.task = new TimerTask(){

                    @Override
                    public void run() {
                        NodeMon.this.pingTimedOut();
                    }
                };
                NodeMonitor.this.timer.schedule(this.task, PING_TIMEOUT);
            }
            try {
                this.stub.getStatMulti(NodeMonitor.this.manager.getLocator(), ((ConcurrentHashMap.CollectionView)((Object)this.keylisteners.keySet())).toArray(new DdllKey[0]));
            }
            catch (RPCException e) {
                NodeMon nodeMon2 = this;
                synchronized (nodeMon2) {
                    this.state = State.WAITING;
                    if (this.task != null) {
                        this.task.cancel();
                    }
                }
                Throwable cause = e.getCause();
                if (cause != null && cause instanceof IOException) {
                    this.pingTimedOut();
                } else {
                    this.schedulePing();
                }
                return;
            }
            catch (IllegalStateException e) {
                NodeMon nodeMon3 = this;
                synchronized (nodeMon3) {
                    this.state = State.WAITING;
                    if (this.task != null) {
                        this.task.cancel();
                    }
                }
                logger.debug("ping: alreay finished");
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void pingTimedOut() {
            HashSet keySet;
            logger.warn("pingTimedOut: {} timeout", (Object)this.locator);
            NodeMon nodeMon = this;
            synchronized (nodeMon) {
                keySet = new HashSet(this.keylisteners.keySet());
            }
            for (DdllKey key : keySet) {
                this.nodeFailure(key);
            }
            this.schedulePing();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void nodeFailure(DdllKey key) {
            Set<NodeAndPeriod> set;
            logger.debug("nodeFailure: key={}", (Object)key);
            NodeMon nodeMon = this;
            synchronized (nodeMon) {
                set = this.keylisteners.get(key);
            }
            if (set == null) {
                logger.debug("nodeFailure: key does not exist");
            } else {
                for (NodeAndPeriod listener : set) {
                    listener.node.onNodeFailure(Collections.singleton(new Link(this.locator, key)));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        void statReceived(Stat[] stats) {
            Stat[] statArray = this;
            // MONITORENTER : this
            if (this.task != null) {
                this.task.cancel();
            }
            logger.debug("statReceived: from {}", (Object)this.locator);
            this.state = State.WAITING;
            // MONITOREXIT : statArray
            statArray = stats;
            int n = statArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    super.schedulePing();
                    return;
                }
                Stat s = statArray[n2];
                if (s.me == null) {
                    logger.debug("statReceived: remote node does not have {}", (Object)s.key);
                    super.nodeFailure(s.key);
                } else {
                    Set<NodeAndPeriod> listeners = this.keylisteners.get(s.me.key);
                    if (listeners != null) {
                        Stat[] statArray2 = this;
                        // MONITORENTER : this
                        ArrayList<NodeAndPeriod> coListeners = new ArrayList<NodeAndPeriod>(listeners);
                        // MONITOREXIT : statArray2
                        for (NodeAndPeriod listener : coListeners) {
                            logger.debug("statReceived: node={}, remote={}", (Object)listener.node, (Object)s);
                            listener.node.statReceived(s);
                        }
                    }
                }
                ++n2;
            }
        }

        private synchronized void schedulePing() {
            if (this.task != null) {
                this.task.cancel();
            }
            this.task = new TimerTask(){

                @Override
                public void run() {
                    NodeMon.this.ping();
                }
            };
            int period = this.getPeriod();
            int delay = (int)((this.first ? Math.random() : 1.0) * (double)period);
            NodeMonitor.this.timer.schedule(this.task, delay);
            this.first = false;
            logger.trace("schedule ping from {} to {} after {} msec", new Object[]{NodeMonitor.this.myLocator, this.locator, period});
        }
    }

    static class NodeAndPeriod {
        Node node;
        int period;

        public NodeAndPeriod(Node node, int period) {
            this.node = node;
            this.period = period;
        }

        public boolean equals(Object obj) {
            return this.node.equals(((NodeAndPeriod)obj).node);
        }

        public int hashCode() {
            return this.node.hashCode();
        }

        public String toString() {
            return this.node.getKey() + "(" + this.period + ")";
        }
    }

    static enum State {
        INIT,
        WAITING,
        PINGSENT;

    }
}

