/*
 * Decompiled with CFR 0.152.
 */
package org.piax.gtrans.ov.dolr;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.piax.common.Endpoint;
import org.piax.common.Key;
import org.piax.common.ObjectId;
import org.piax.common.TransportId;
import org.piax.common.wrapper.ConvertedComparableKey;
import org.piax.gtrans.FutureQueue;
import org.piax.gtrans.IdConflictException;
import org.piax.gtrans.ProtocolUnsupportedException;
import org.piax.gtrans.ReceivedMessage;
import org.piax.gtrans.RequestTransport;
import org.piax.gtrans.TransOptions;
import org.piax.gtrans.Transport;
import org.piax.gtrans.TransportListener;
import org.piax.gtrans.impl.NestedMessage;
import org.piax.gtrans.ov.Overlay;
import org.piax.gtrans.ov.OverlayListener;
import org.piax.gtrans.ov.OverlayReceivedMessage;
import org.piax.gtrans.ov.compound.CompoundOverlay;
import org.piax.gtrans.ov.impl.OverlayImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DOLR<K extends Key>
extends OverlayImpl<K, K>
implements OverlayListener<ConvertedComparableKey<K>, ConvertedComparableKey<K>> {
    private static final Logger logger = LoggerFactory.getLogger(DOLR.class);
    public static TransportId DEFAULT_TRANSPORT_ID = new TransportId("dolr");
    final Overlay<ConvertedComparableKey<K>, ConvertedComparableKey<K>> sg;

    public DOLR(Overlay<? super ConvertedComparableKey<K>, ? super ConvertedComparableKey<K>> sg) throws IdConflictException, IOException {
        this(DEFAULT_TRANSPORT_ID, sg);
    }

    public DOLR(TransportId transId, Overlay<? super ConvertedComparableKey<K>, ? super ConvertedComparableKey<K>> sg) throws IdConflictException, IOException {
        super(sg.getPeer(), transId, sg);
        this.sg = sg;
        this.sg.setListener((ObjectId)transId, this);
    }

    @Override
    public synchronized void fin() {
        this.sg.setListener((ObjectId)this.transId, null);
        super.fin();
    }

    @Override
    public Endpoint getEndpoint() {
        return this.sg.getEndpoint();
    }

    @Override
    public Class<?> getAvailableKeyType() {
        return Comparable.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FutureQueue<?> request(ObjectId sender, ObjectId receiver, K dst, Object msg, TransOptions opts) throws ProtocolUnsupportedException, IOException {
        logger.trace("ENTRY:");
        logger.debug("peer:{} dst:{} msg:{}", new Object[]{this.peerId, dst, msg});
        try {
            if (!(dst instanceof Key)) {
                throw new ProtocolUnsupportedException("DOLR only supports Key destination");
            }
            NestedMessage nmsg = new NestedMessage(sender, receiver, null, this.getEndpoint(), msg);
            FutureQueue<?> futureQueue = this.sg.request(this.transId, new ConvertedComparableKey<K>(dst), (Object)nmsg, opts);
            return futureQueue;
        }
        finally {
            logger.trace("EXIT:");
        }
    }

    @Override
    public void onReceive(Overlay<ConvertedComparableKey<K>, ConvertedComparableKey<K>> trans, OverlayReceivedMessage<ConvertedComparableKey<K>> rmsg) {
        logger.trace("ENTRY:");
        HashSet matched = new HashSet();
        for (ConvertedComparableKey<K> k : rmsg.getMatchedKeys()) {
            matched.add(k.key);
        }
        NestedMessage nmsg = (NestedMessage)rmsg.getMessage();
        logger.debug("matchedKeys:{} nmsg:{}", matched, (Object)nmsg);
        Set keys = this.getKeys(nmsg.receiver);
        keys.retainAll(matched);
        if (keys.isEmpty() && nmsg.passthrough != CompoundOverlay.SpecialKey.WILDCARD) {
            return;
        }
        TransportListener ovl = this.getListener(nmsg.receiver);
        if (ovl == null) {
            logger.info("onReceiveRequest data purged as no such listener");
            return;
        }
        OverlayReceivedMessage rcvMsg = new OverlayReceivedMessage(nmsg.sender, nmsg.src, keys, nmsg.getInner());
        ovl.onReceive(this, rcvMsg);
    }

    @Override
    public FutureQueue<?> onReceiveRequest(Overlay<ConvertedComparableKey<K>, ConvertedComparableKey<K>> trans, OverlayReceivedMessage<ConvertedComparableKey<K>> rmsg) {
        logger.trace("ENTRY:");
        HashSet matched = new HashSet();
        for (ConvertedComparableKey<K> k : rmsg.getMatchedKeys()) {
            matched.add(k.key);
        }
        NestedMessage nmsg = (NestedMessage)rmsg.getMessage();
        logger.debug("matchedKeys:{} nmsg:{}", matched, (Object)nmsg);
        Set keys = this.getKeys(nmsg.receiver);
        keys.retainAll(matched);
        if (keys.isEmpty() && nmsg.passthrough != CompoundOverlay.SpecialKey.WILDCARD) {
            return FutureQueue.emptyQueue();
        }
        TransportListener ovl = this.getListener(nmsg.receiver);
        if (ovl == null) {
            logger.info("onReceiveRequest data purged as no such listener");
            return FutureQueue.emptyQueue();
        }
        OverlayReceivedMessage rcvMsg = new OverlayReceivedMessage(nmsg.sender, nmsg.src, keys, nmsg.getInner());
        return ovl.onReceiveRequest(this, rcvMsg);
    }

    @Override
    public boolean join(Collection<? extends Endpoint> seeds) throws IOException {
        logger.trace("ENTRY:");
        if (this.sg.isJoined()) {
            return true;
        }
        return this.sg.join(seeds);
    }

    @Override
    public boolean leave() throws IOException {
        logger.trace("ENTRY:");
        if (!this.sg.isJoined()) {
            return true;
        }
        return this.sg.leave();
    }

    @Override
    public boolean isJoined() {
        return this.sg.isJoined();
    }

    @Override
    protected void lowerAddKey(K key) throws IOException {
        logger.debug("lower addKey:{}", key);
        this.sg.addKey(this.transId, new ConvertedComparableKey<K>(key));
    }

    @Override
    protected void lowerRemoveKey(K key) throws IOException {
        logger.debug("lower removeKey:{}", key);
        this.sg.removeKey(this.transId, new ConvertedComparableKey<K>(key));
    }

    public Overlay<ConvertedComparableKey<K>, ConvertedComparableKey<K>> getLowerTransport() {
        return this.sg;
    }

    @Override
    public void onReceive(Transport<ConvertedComparableKey<K>> trans, ReceivedMessage rmsg) {
    }

    @Override
    public void onReceive(RequestTransport<ConvertedComparableKey<K>> trans, ReceivedMessage rmsg) {
    }

    public FutureQueue<?> onReceiveRequest(RequestTransport<ConvertedComparableKey<K>> trans, ReceivedMessage rmsg) {
        return null;
    }
}

