/*
 * Decompiled with CFR 0.152.
 */
package org.piax.gtrans.ov.llnet;

import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.piax.common.Endpoint;
import org.piax.common.Location;
import org.piax.common.ObjectId;
import org.piax.common.TransportId;
import org.piax.common.subspace.GeoEllipse;
import org.piax.common.subspace.GeoRectangle;
import org.piax.common.subspace.GeoRegion;
import org.piax.common.subspace.KeyRange;
import org.piax.common.subspace.KeyRanges;
import org.piax.gtrans.FutureQueue;
import org.piax.gtrans.IdConflictException;
import org.piax.gtrans.ProtocolUnsupportedException;
import org.piax.gtrans.ReceivedMessage;
import org.piax.gtrans.RequestTransport;
import org.piax.gtrans.TransOptions;
import org.piax.gtrans.Transport;
import org.piax.gtrans.TransportListener;
import org.piax.gtrans.impl.NestedMessage;
import org.piax.gtrans.ov.Overlay;
import org.piax.gtrans.ov.OverlayListener;
import org.piax.gtrans.ov.OverlayReceivedMessage;
import org.piax.gtrans.ov.compound.CompoundOverlay;
import org.piax.gtrans.ov.impl.OverlayImpl;
import org.piax.gtrans.ov.llnet.AreaId;
import org.piax.gtrans.ov.llnet.LocationId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LLNet
extends OverlayImpl<GeoRegion, Location>
implements OverlayListener<KeyRanges<LocationId>, LocationId> {
    private static final Logger logger = LoggerFactory.getLogger(LLNet.class);
    public static TransportId DEFAULT_TRANSPORT_ID = new TransportId("llnet");
    final Overlay<KeyRanges<LocationId>, LocationId> sg;

    public LLNet(Overlay<? super KeyRanges<LocationId>, ? super LocationId> sg) throws IdConflictException, IOException {
        this(DEFAULT_TRANSPORT_ID, sg);
    }

    public LLNet(TransportId transId, Overlay<? super KeyRanges<LocationId>, ? super LocationId> sg) throws IdConflictException, IOException {
        super(sg.getPeer(), transId, sg);
        this.sg = sg;
        this.sg.setListener((ObjectId)transId, this);
    }

    @Override
    public synchronized void fin() {
        this.sg.setListener((ObjectId)this.transId, (OverlayListener<KeyRanges<LocationId>, LocationId>)null);
        super.fin();
    }

    @Override
    public Endpoint getEndpoint() {
        return this.sg.getEndpoint();
    }

    @Override
    public Class<?> getAvailableKeyType() {
        return Location.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FutureQueue<?> request(ObjectId sender, ObjectId receiver, GeoRegion dst, Object msg, TransOptions opts) throws ProtocolUnsupportedException, IOException {
        logger.trace("ENTRY:");
        logger.debug("peer:{} dst:{} msg:{}", new Object[]{this.peerId, dst, msg});
        try {
            GeoRectangle rect = null;
            if (dst instanceof GeoRectangle) {
                rect = (GeoRectangle)dst;
            } else if (dst instanceof GeoEllipse) {
                Rectangle2D r = ((GeoEllipse)dst).getBounds2D();
                rect = new GeoRectangle(r.getX(), r.getY(), r.getWidth(), r.getHeight());
            } else {
                throw new ProtocolUnsupportedException("LLNet only supports GeoRegion");
            }
            AreaId[] areaIds = AreaId.getAreaIds(rect);
            ArrayList<KeyRange<LocationId>> llranges = new ArrayList<KeyRange<LocationId>>();
            for (int i = 0; i < areaIds.length; ++i) {
                llranges.add(new KeyRange<LocationId>(areaIds[i].startLocId(), areaIds[i].endLocId()));
            }
            NestedMessage nmsg = new NestedMessage(sender, receiver, null, this.getEndpoint(), 0, dst, msg);
            FutureQueue<?> futureQueue = this.sg.request(this.transId, new KeyRanges(llranges), (Object)nmsg, opts);
            return futureQueue;
        }
        finally {
            logger.trace("EXIT:");
        }
    }

    @Override
    public void onReceive(Overlay<KeyRanges<LocationId>, LocationId> trans, OverlayReceivedMessage<LocationId> rmsg) {
        logger.trace("ENTRY:");
        Collection<LocationId> matchedKeys = rmsg.getMatchedKeys();
        NestedMessage nmsg = (NestedMessage)rmsg.getMessage();
        logger.debug("matchedKeys:{} nmsg:{}", matchedKeys, (Object)nmsg);
        GeoRegion region = (GeoRegion)nmsg.option;
        Set registerKeys = this.getKeys(nmsg.receiver);
        HashSet<Location> matchedLocs = new HashSet<Location>();
        for (Location loc : registerKeys) {
            if (!region.contains(loc) || !matchedKeys.contains(new LocationId(loc))) continue;
            matchedLocs.add(loc);
        }
        if (matchedLocs.isEmpty() && nmsg.passthrough != CompoundOverlay.SpecialKey.WILDCARD) {
            return;
        }
        TransportListener ovl = this.getListener(nmsg.receiver);
        if (ovl == null) {
            logger.info("onReceiveRequest data purged as no such listener");
            return;
        }
        OverlayReceivedMessage rcvMsg = new OverlayReceivedMessage(nmsg.sender, nmsg.src, matchedLocs, nmsg.getInner());
        ovl.onReceive(this, rcvMsg);
    }

    @Override
    public FutureQueue<?> onReceiveRequest(Overlay<KeyRanges<LocationId>, LocationId> trans, OverlayReceivedMessage<LocationId> rmsg) {
        logger.trace("ENTRY:");
        Collection<LocationId> matchedKeys = rmsg.getMatchedKeys();
        NestedMessage nmsg = (NestedMessage)rmsg.getMessage();
        logger.debug("matchedKeys:{} nmsg:{}", matchedKeys, (Object)nmsg);
        GeoRegion region = (GeoRegion)nmsg.option;
        Set registerKeys = this.getKeys(nmsg.receiver);
        HashSet<Location> matchedLocs = new HashSet<Location>();
        for (Location loc : registerKeys) {
            if (!region.contains(loc) || !matchedKeys.contains(new LocationId(loc))) continue;
            matchedLocs.add(loc);
        }
        logger.debug("matchedLocs:{}", matchedLocs);
        if (matchedLocs.isEmpty() && nmsg.passthrough != CompoundOverlay.SpecialKey.WILDCARD) {
            return FutureQueue.emptyQueue();
        }
        TransportListener ovl = this.getListener(nmsg.receiver);
        if (ovl == null) {
            logger.info("onReceiveRequest data purged as no such listener");
            return FutureQueue.emptyQueue();
        }
        OverlayReceivedMessage rcvMsg = new OverlayReceivedMessage(nmsg.sender, nmsg.src, matchedLocs, nmsg.getInner());
        return ovl.onReceiveRequest(this, rcvMsg);
    }

    @Override
    public boolean join(Collection<? extends Endpoint> seeds) throws IOException {
        if (this.sg.isJoined()) {
            return true;
        }
        return this.sg.join(seeds);
    }

    @Override
    public boolean leave() throws IOException {
        if (!this.sg.isJoined()) {
            return true;
        }
        return this.sg.leave();
    }

    @Override
    protected void lowerAddKey(Location key) throws IOException {
        logger.debug("lower addKey:{}", (Object)key);
        this.sg.addKey(this.transId, new LocationId(key));
    }

    @Override
    protected void lowerRemoveKey(Location key) throws IOException {
        logger.debug("lower removeKey:{}", (Object)key);
        this.sg.removeKey(this.transId, new LocationId(key));
    }

    @Override
    public boolean isJoined() {
        return this.sg.isJoined();
    }

    public Overlay<KeyRanges<LocationId>, LocationId> getLowerTransport() {
        return this.sg;
    }

    @Override
    public void onReceive(Transport<KeyRanges<LocationId>> trans, ReceivedMessage rmsg) {
    }

    @Override
    public void onReceive(RequestTransport<KeyRanges<LocationId>> trans, ReceivedMessage rmsg) {
    }

    public FutureQueue<?> onReceiveRequest(RequestTransport<KeyRanges<LocationId>> trans, ReceivedMessage rmsg) {
        return null;
    }
}

