/*
 * Decompiled with CFR 0.152.
 */
package org.piax.gtrans.ov.ring;

import java.util.TimerTask;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class MyThreadPool {
    private ScheduledExecutorService pool;

    public MyThreadPool(int nthreads, final String name1, final String name2) {
        this.pool = Executors.newScheduledThreadPool(nthreads, new ThreadFactory(){
            int count = 1;

            @Override
            public Thread newThread(Runnable r) {
                Thread th = new Thread(r);
                th.setDaemon(true);
                th.setName(name1 + "-" + this.count + "@" + name2);
                ++this.count;
                return th;
            }
        });
    }

    @Deprecated
    public void schedule(TimerTask task, long delay) {
        throw new UnsupportedOperationException();
    }

    public ScheduledFuture<?> schedule(Runnable task, long delay) {
        ScheduledFuture<?> fs = this.pool.schedule(task, delay, TimeUnit.MILLISECONDS);
        return fs;
    }

    @Deprecated
    public void schedule(TimerTask task, long delay, long period) {
        throw new UnsupportedOperationException();
    }

    public ScheduledFuture<?> schedule(Runnable task, long delay, long period) {
        ScheduledFuture<?> fs = this.pool.scheduleWithFixedDelay(task, delay, period, TimeUnit.MILLISECONDS);
        return fs;
    }

    public void shutdown() {
        this.pool.shutdownNow();
    }
}

