/*
 * Decompiled with CFR 0.152.
 */
package org.piax.gtrans.ov.ring;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Random;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.piax.common.Endpoint;
import org.piax.common.PeerId;
import org.piax.common.TransportId;
import org.piax.common.subspace.CircularRange;
import org.piax.gtrans.ChannelTransport;
import org.piax.gtrans.IdConflictException;
import org.piax.gtrans.RPCException;
import org.piax.gtrans.RPCInvoker;
import org.piax.gtrans.RemoteValue;
import org.piax.gtrans.TransOptions;
import org.piax.gtrans.ov.ddll.DdllKey;
import org.piax.gtrans.ov.ddll.Link;
import org.piax.gtrans.ov.ddll.Node;
import org.piax.gtrans.ov.ddll.NodeManager;
import org.piax.gtrans.ov.ring.AckMessage;
import org.piax.gtrans.ov.ring.MessagingFramework;
import org.piax.gtrans.ov.ring.MyThreadPool;
import org.piax.gtrans.ov.ring.ReplyMessage;
import org.piax.gtrans.ov.ring.RequestMessage;
import org.piax.gtrans.ov.ring.RingIf;
import org.piax.gtrans.ov.ring.RingVNode;
import org.piax.gtrans.ov.ring.StatManager;
import org.piax.gtrans.ov.ring.TemporaryIOException;
import org.piax.gtrans.ov.ring.UnavailableException;
import org.piax.gtrans.ov.ring.rq.RQMessage;
import org.piax.util.KeyComparator;
import org.piax.util.MersenneTwister;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RingManager<E extends Endpoint>
extends RPCInvoker<RingIf, E>
implements RingIf {
    protected static final Logger logger = LoggerFactory.getLogger(RingManager.class);
    public static TransportId DEFAULT_TRANSPORT_ID = new TransportId("ring");
    public final TransportId transId;
    protected static final KeyComparator keyComp = KeyComparator.getInstance();
    protected NodeManager manager;
    protected E myLocator;
    protected final PeerId peerId;
    private ReentrantReadWriteLock rtlock = new ReentrantReadWriteLock();
    protected NavigableMap<Comparable<?>, RingVNode<E>> keyHash = new ConcurrentSkipListMap(keyComp);
    protected Random rand = new MersenneTwister();
    protected final MessagingFramework msgframe;
    protected final StatManager statman;
    private static final int NTHREADS_IN_POOL = 2;
    private final MyThreadPool pool;
    public static int DDLL_CHECK_PERIOD_L0 = 10000;
    public static int RPC_TIMEOUT = 20000;

    public RingManager(TransportId transId, ChannelTransport<E> trans) throws IdConflictException, IOException {
        super(transId, trans);
        this.transId = transId;
        this.myLocator = trans.getEndpoint();
        this.peerId = trans.getPeerId();
        this.pool = new MyThreadPool(2, "RingPool", this.getPeerId().toString());
        this.manager = new NodeManager(new TransportId(transId.toString() + "-ddll"), trans);
        this.msgframe = new MessagingFramework(this);
        this.statman = new StatManager(this);
        logger.debug("DdllRing: transId={}", (Object)trans.getTransportId());
    }

    @Override
    public synchronized void online() {
        if (this.isOnline()) {
            return;
        }
        super.online();
        this.manager.online();
    }

    @Override
    public synchronized void offline() {
        if (!this.isOnline()) {
            return;
        }
        this.manager.offline();
        super.offline();
    }

    @Override
    public synchronized void fin() {
        this.manager.fin();
        this.pool.shutdown();
        super.fin();
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void rtLockR() {
        this.rtlock.readLock().lock();
    }

    public void rtUnlockR() {
        this.rtlock.readLock().unlock();
    }

    public void rtLockW() {
        this.rtlock.writeLock().lock();
    }

    public void rtUnlockW() {
        this.rtlock.writeLock().unlock();
    }

    public Condition newCondition() {
        return this.rtlock.writeLock().newCondition();
    }

    public void checkLocked() {
        assert (this.rtlock.getReadLockCount() > 0 || this.rtlock.isWriteLockedByCurrentThread());
    }

    @Override
    public RingIf getStub(E addr, int rpcTimeout) {
        return (RingIf)super.getStub(addr, rpcTimeout);
    }

    @Override
    public RingIf getStub(Endpoint dst) {
        return (RingIf)super.getStub(dst);
    }

    @Deprecated
    public void schedule(TimerTask task, long delay) {
        throw new UnsupportedOperationException();
    }

    public ScheduledFuture<?> schedule(Runnable task, long delay) {
        return this.pool.schedule(task, delay);
    }

    @Deprecated
    public void schedule(TimerTask task, long delay, long period) {
        throw new UnsupportedOperationException();
    }

    public ScheduledFuture<?> schedule(Runnable task, long delay, long period) {
        return this.pool.schedule(task, delay, period);
    }

    public PeerId getPeerId() {
        return this.peerId;
    }

    public Collection<? extends RingVNode<E>> allVNodes() {
        return this.keyHash.values();
    }

    public List<? extends RingVNode<E>> allValidVNodes() {
        ArrayList<RingVNode> rc = new ArrayList<RingVNode>();
        for (RingVNode vn : this.keyHash.values()) {
            if (!vn.isInserted()) continue;
            rc.add(vn);
        }
        return rc;
    }

    public RingVNode<E> getVNode(Comparable<?> rawkey) {
        RingVNode snode = (RingVNode)this.keyHash.get(rawkey);
        return snode;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("PeerId: " + this.peerId + "\n");
        for (RingVNode snode : this.keyHash.values()) {
            buf.append(snode);
        }
        return buf.toString();
    }

    public String toStringShort() {
        return this.keyHash.keySet().toString();
    }

    protected RingVNode<E> newVNode(Comparable<?> rawkey, Object ... params) {
        return new RingVNode(this, rawkey);
    }

    public String showTable() {
        return this.toString();
    }

    protected NavigableMap<DdllKey, Link> getAvailableLinks() {
        this.checkLocked();
        ConcurrentSkipListMap<DdllKey, Link> allLinks = new ConcurrentSkipListMap<DdllKey, Link>();
        for (RingVNode n : this.keyHash.values()) {
            for (Link link : n.getAllLinks()) {
                allLinks.put(link.key, link);
            }
        }
        return allLinks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Link[] getLocalLinks() {
        ArrayList<Link> list = new ArrayList<Link>();
        this.rtLockR();
        try {
            for (RingVNode snode : this.keyHash.values()) {
                if (!snode.isInserted()) continue;
                Link link = snode.getLocalLink();
                list.add(link);
            }
        }
        finally {
            this.rtUnlockR();
        }
        Link[] links = list.toArray(new Link[list.size()]);
        return links;
    }

    protected boolean addKey(Comparable<?> rawkey) throws IOException, UnavailableException {
        return this.addKey(null, rawkey);
    }

    public boolean addKey(E introducer, Comparable<?> rawkey) throws UnavailableException, IOException {
        return this.addKey(introducer, rawkey, null);
    }

    protected synchronized boolean addKey(E introducer, Comparable<?> rawkey, Object ... vnodeParams) throws UnavailableException, IOException {
        if (this.myLocator.equals(introducer)) {
            introducer = null;
        }
        this.rtLockW();
        if (this.keyHash.containsKey(rawkey)) {
            this.rtUnlockW();
            logger.debug("addKey: already registered: {}", rawkey);
            return false;
        }
        RingVNode<E> n = this.newVNode(rawkey, vnodeParams);
        this.keyHash.put(rawkey, n);
        this.rtUnlockW();
        try {
            boolean rc = n.addKey(introducer);
            if (!rc) {
                logger.error("addKey failed for {}", rawkey);
                this.rtLockW();
                this.keyHash.remove(rawkey);
                this.rtUnlockW();
                return false;
            }
            return rc;
        }
        catch (UnavailableException e) {
            this.rtLockW();
            this.keyHash.remove(rawkey);
            this.rtUnlockW();
            throw e;
        }
        catch (IOException e) {
            this.rtLockW();
            this.keyHash.remove(rawkey);
            this.rtUnlockW();
            throw e;
        }
    }

    public boolean removeKey(Comparable<?> rawkey) throws IOException {
        logger.debug("removeKey key={}\n{}", rawkey, (Object)this);
        RingVNode snode = (RingVNode)this.keyHash.get(rawkey);
        if (snode == null) {
            return false;
        }
        boolean rc = snode.removeKey();
        if (rc) {
            this.rtLockW();
            this.keyHash.remove(rawkey);
            this.rtUnlockW();
        }
        return rc;
    }

    public Node.InsertPoint find(E introducer, DdllKey key, boolean accurate, Object query, TransOptions opts) throws UnavailableException, IOException {
        Node.InsertPoint insp = null;
        try {
            logger.debug("query={}", query);
            insp = this.findImmedNeighbors(introducer, key, query, opts);
        }
        catch (TemporaryIOException e) {
            throw new IOException(e.getCause());
        }
        return insp;
    }

    public Node.InsertPoint findImmedNeighbors(E introducer, DdllKey key, Object query, TransOptions opts) throws UnavailableException, IOException {
        Object p = introducer;
        if (p == null) {
            p = this.myLocator;
            if (this.getLocalLinks().length == 0) {
                logger.debug("findImmedNeighbors: no local links are available");
                return null;
            }
        }
        while (true) {
            RingIf stub = this.getStub((Endpoint)p);
            try {
                Object[] links = stub.getClosestLinks(key);
                logger.debug("getClosestLinks({}) at {} returns {}", new Object[]{key, p, Arrays.toString(links)});
                if (((Link)links[0]).addr.equals(p)) {
                    Node.InsertPoint ins = new Node.InsertPoint((Link)links[0], (Link)links[1]);
                    return ins;
                }
                p = ((Link)links[0]).addr;
            }
            catch (RPCException e) {
                throw new IOException(e.getCause());
            }
            catch (UnavailableException e) {
                throw e;
            }
        }
    }

    @Override
    public Link[] getClosestLinks(DdllKey key) throws UnavailableException {
        logger.debug("getClosestLinks({}) is called", (Object)key);
        this.rtLockR();
        NavigableMap<DdllKey, Link> allLinks = this.getAvailableLinks();
        this.rtUnlockR();
        Map.Entry<DdllKey, Link> lent = allLinks.floorEntry(key);
        if (lent == null && (lent = allLinks.lastEntry()) == null) {
            throw new UnavailableException("Peer " + this.peerId + " has no key");
        }
        Map.Entry<DdllKey, Link> rent = allLinks.ceilingEntry(key);
        if (rent == null && (rent = allLinks.firstEntry()) == null) {
            throw new UnavailableException("Peer " + this.peerId + " has no key");
        }
        Link[] links = new Link[]{lent.getValue(), rent.getValue()};
        logger.debug("getClosestLinks({}) returns [{}, {}]", new Object[]{key, links[0], links[1]});
        return links;
    }

    public Link findLeftLink(DdllKey key) throws UnavailableException {
        logger.debug("findLeftLink({}) is called", (Object)key);
        Link[] links = this.getClosestLinks(key);
        return links[0];
    }

    public void fixRoutingTables(Collection<Link> failedNodes, RQMessage parentMsg, Collection<CircularRange<DdllKey>> ranges) {
        logger.debug("fixRoutingTables: failedNodes={}, parentMsg={}, ranges={}", new Object[]{failedNodes, parentMsg, ranges});
    }

    public RequestMessage getRequestMessageById(int replyId) {
        return this.msgframe.getRequestMessageById(replyId);
    }

    @Override
    public void requestMsgReceived(RequestMessage sgMessage) {
        this.msgframe.requestMsgReceived(sgMessage);
    }

    @Override
    public void replyMsgReceived(ReplyMessage sgReplyMessage) {
        this.msgframe.replyMsgReceived(sgReplyMessage);
    }

    @Override
    public void ackReceived(int msgId, AckMessage ackMessage) {
        this.msgframe.ackMsgReceived(msgId, ackMessage);
    }

    public static class RightNodeMismatch
    extends Exception {
        public Link curRight;

        public RightNodeMismatch(Link curRight) {
            this.curRight = curRight;
        }

        @Override
        public String toString() {
            return "RightNodeMismatch(curRight=" + this.curRight + ")";
        }
    }

    public static class ExecQueryReturn
    implements Serializable {
        public RemoteValue<?> key;
        public Link left;
        public Link right;

        public String toString() {
            return "ExecQueryReturn[" + this.key + ", left=" + this.left + ", right=" + this.right + "]";
        }
    }

    public static class LinkContainer
    implements Serializable {
        public final Link link;
        public final Link rightLink;
        public final boolean isImmedPred;

        public LinkContainer(Link link, Link rightLink, boolean isImmedPred) {
            this.link = link;
            this.rightLink = rightLink;
            this.isImmedPred = isImmedPred;
        }

        public String toString() {
            return "BestLink(link=" + this.link + ", right=" + this.rightLink + ", " + this.isImmedPred + ")";
        }
    }
}

