/*
 * Decompiled with CFR 0.152.
 */
package org.piax.gtrans.ov.ring.rq;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class FlexibleArray<T>
implements Serializable {
    private final int minIndex;
    private ArrayList<T> list = new ArrayList();

    public FlexibleArray() {
        this(0);
    }

    public FlexibleArray(int minIndex) {
        this.minIndex = minIndex;
    }

    public void set(int index, T value) {
        this.checkRange(index);
        int actualIndex = index - this.minIndex;
        if (actualIndex < this.list.size()) {
            this.list.set(actualIndex, value);
        } else {
            for (int i = this.list.size(); i < actualIndex; ++i) {
                this.list.add(i, null);
            }
            this.list.add(actualIndex, value);
        }
    }

    public T get(int index) {
        int actualIndex = index - this.minIndex;
        if (this.size() <= actualIndex) {
            return null;
        }
        return this.list.get(actualIndex);
    }

    public int size() {
        return this.list.size();
    }

    public int minIndex() {
        return this.minIndex;
    }

    public int maxIndexPlus1() {
        return this.size() + this.minIndex;
    }

    public void shrink(int maxplus1) {
        this.checkRange(maxplus1);
        for (int i = this.size() - 1; i >= maxplus1 - this.minIndex; --i) {
            this.list.remove(i);
        }
        this.list.trimToSize();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.list == null ? 0 : this.list.hashCode());
        result = 31 * result + this.minIndex;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FlexibleArray other = (FlexibleArray)obj;
        if (this.minIndex != other.minIndex) {
            return false;
        }
        return !(this.list == null ? other.list != null : !this.list.equals(other.list));
    }

    private void checkRange(int index) {
        if (index < this.minIndex) {
            throw new ArrayIndexOutOfBoundsException("index=" + index + ", minIndex=" + this.minIndex);
        }
    }

    public String toString() {
        return this.list.toString();
    }

    public List<T> getAll() {
        return (List)this.list.clone();
    }

    public static void main(String[] args) {
        FlexibleArray<String> a = new FlexibleArray<String>(-1);
        a.set(3, "D");
        a.set(2, "C");
        a.set(1, "B");
        a.set(0, "A");
        a.set(5, "F");
        a.set(-1, "@");
        System.out.println(a);
        System.out.println(a.size());
        for (int i = a.minIndex(); i < a.maxIndexPlus1(); ++i) {
            System.out.println(i + ": " + (String)a.get(i));
        }
    }
}

