/*
 * Decompiled with CFR 0.152.
 */
package org.piax.gtrans.ov.ring.rq;

import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import org.piax.common.Endpoint;
import org.piax.common.PeerId;
import org.piax.gtrans.RemoteValue;
import org.piax.gtrans.ov.ring.rq.QueryId;

public class QueryStore {
    int storedCount = 0;
    int expiredCount = 0;
    int readCount = 0;
    ConcurrentHashMap<QueryId, QueryStoreEntry> store = new ConcurrentHashMap();

    public RemoteValue<?> get(QueryId qid) {
        QueryStoreEntry entry = this.store.get(qid);
        if (entry != null) {
            ++this.readCount;
        }
        return entry != null ? entry.rval : null;
    }

    public void put(QueryId qid, RemoteValue<?> rval) {
        this.store.put(qid, new QueryStoreEntry(qid, rval));
        ++this.storedCount;
    }

    public void removeExpired(long expireTime) {
        long threshold = System.currentTimeMillis() - expireTime;
        Iterator it = ((ConcurrentHashMap.KeySetView)this.store.keySet()).iterator();
        while (it.hasNext()) {
            QueryId qid = (QueryId)it.next();
            QueryStoreEntry entry = this.store.get(qid);
            if (entry.timestamp >= threshold) continue;
            it.remove();
            ++this.expiredCount;
        }
    }

    public int getStoredCount() {
        return this.storedCount;
    }

    public int getExpiredCount() {
        return this.expiredCount;
    }

    public int getReadCount() {
        return this.readCount;
    }

    public static void main(String[] args) {
        final long start = System.currentTimeMillis();
        QueryStore store = new QueryStore();
        class Writer
        extends Thread {
            QueryStore store;

            public Writer(QueryStore store) {
                this.store = store;
            }

            @Override
            public void run() {
                int i = 0;
                int p = 0;
                while (System.currentTimeMillis() - start < 2000L) {
                    PeerId pid = new PeerId("p" + p++);
                    this.store.put(new QueryId(pid, i++), new RemoteValue((Endpoint)pid, null));
                }
            }
        }
        new Writer(store).start();
        class Reader
        extends Thread {
            QueryStore store;

            public Reader(QueryStore store) {
                this.store = store;
            }

            @Override
            public void run() {
                int i = 0;
                int p = 0;
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                while (System.currentTimeMillis() - start < 2000L) {
                    PeerId pid = new PeerId("p" + p++);
                    this.store.get(new QueryId(pid, i++));
                }
            }
        }
        new Reader(store).start();
        class Expirer
        extends Thread {
            QueryStore store;

            public Expirer(QueryStore store) {
                this.store = store;
            }

            @Override
            public void run() {
                while (System.currentTimeMillis() - start < 2000L) {
                    this.store.removeExpired(1000L);
                }
            }
        }
        new Expirer(store).start();
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        System.out.println("Stored:" + store.getStoredCount() + ", Expired:" + store.getExpiredCount() + ", Read: " + store.getReadCount());
    }

    class QueryStoreEntry {
        public QueryId qid;
        public long timestamp;
        public RemoteValue<?> rval;

        public QueryStoreEntry(QueryId qid, RemoteValue<?> rval) {
            this.qid = qid;
            this.rval = rval;
            this.timestamp = System.currentTimeMillis();
        }
    }
}

