/*
 * Decompiled with CFR 0.152.
 */
package org.piax.gtrans.ov.ring.rq;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.piax.common.Endpoint;
import org.piax.gtrans.TransOptions;
import org.piax.gtrans.ov.ring.MessagingFramework;
import org.piax.gtrans.ov.ring.ReplyMessage;
import org.piax.gtrans.ov.ring.RequestMessage;
import org.piax.gtrans.ov.ring.rq.DKRangeRValue;
import org.piax.gtrans.ov.ring.rq.MessagePath;
import org.piax.gtrans.ov.ring.rq.QueryId;
import org.piax.gtrans.ov.ring.rq.RQAlgorithm;
import org.piax.gtrans.ov.ring.rq.RQReplyMessage;
import org.piax.gtrans.ov.ring.rq.RQReturn;
import org.piax.gtrans.ov.ring.rq.SubRange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RQMessage
extends RequestMessage {
    private static final Logger logger = LoggerFactory.getLogger(RQMessage.class);
    private static final long serialVersionUID = 1L;
    protected final Collection<SubRange> targetRanges;
    public Collection<SubRange> subRanges;
    public final QueryId qid;
    public final Object query;
    public final int hops;
    public transient RQReturn rqRet;
    public final Set<Endpoint> failedLinks;

    protected RQMessage(MessagingFramework msgframe, boolean isRoot, Endpoint replyTo, int replyId, Collection<SubRange> subRanges, QueryId qid, Object query, int hops, TransOptions opts) {
        super(msgframe, isRoot, replyTo, replyId, opts);
        this.targetRanges = Collections.unmodifiableCollection(subRanges);
        this.subRanges = Collections.unmodifiableCollection(subRanges);
        this.qid = qid;
        this.query = query;
        this.hops = hops;
        this.failedLinks = new HashSet<Endpoint>();
    }

    protected abstract RQMessage createInstance(MessagingFramework var1, boolean var2, Endpoint var3, int var4, Collection<SubRange> var5, TransOptions var6);

    private RQMessage(RQMessage msgSrc, Collection<SubRange> newSubRanges) {
        super(msgSrc);
        this.targetRanges = msgSrc.targetRanges;
        this.subRanges = newSubRanges;
        this.qid = msgSrc.qid;
        this.query = msgSrc.query;
        this.hops = msgSrc.hops;
        this.failedLinks = new HashSet<Endpoint>(msgSrc.failedLinks);
    }

    public abstract RQAlgorithm getRangeQueryAlgorithm();

    public RQMessage newChildInstance(Collection<SubRange> newSubRange) {
        return this.newChildInstance(newSubRange, false);
    }

    public RQMessage newChildInstance(Collection<SubRange> newSubRange, boolean newIsRoot) {
        RQMessage newMsg = this.createInstance(this.msgframe, newIsRoot, TransOptions.responseType(this.opts) == TransOptions.ResponseType.DIRECT ? this.replyTo : null, TransOptions.responseType(this.opts) == TransOptions.ResponseType.DIRECT ? this.replyId : 0, newSubRange, this.opts);
        newMsg.rqRet = this.rqRet;
        assert (this.rqRet != null);
        newMsg.addFailedLinks(this.failedLinks);
        return newMsg;
    }

    public String shortName() {
        return "RQMsg";
    }

    public String toString() {
        return this.shortName() + "[Opts=" + this.opts + ", isRoot=" + this.isRoot + ", sender=" + this.sender + ", receiver=" + this.receiver + ", msgId=" + this.msgId + ", replyTo=" + this.replyTo + ", replyId=" + this.replyId + ", subRanges=" + this.subRanges + ", rqRet=" + this.rqRet + ", hops=" + this.hops + ", failedLinks=" + this.failedLinks + "]";
    }

    public void addFailedLinks(Collection<Endpoint> links) {
        this.failedLinks.addAll(links);
    }

    public Collection<SubRange> getTargetRanges() {
        return this.targetRanges;
    }

    public Object getQuery() {
        return this.query;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean onReceivingReply(ReplyMessage reply0) {
        assert (TransOptions.responseType(this.opts) != TransOptions.ResponseType.NO_RESPONSE);
        RQReplyMessage reply = (RQReplyMessage)reply0;
        logger.debug("onReceivingReply: reply={}, this={}", (Object)reply, (Object)this);
        this.getManager().rtLockW();
        try {
            this.rqRet.setReturnValue(reply);
            boolean bl = this.rqRet.isCompleted();
            return bl;
        }
        finally {
            this.getManager().rtUnlockW();
        }
    }

    @Override
    public synchronized void onResponseTimeout() {
        logger.debug("onResponseTimeout: {}", (Object)this);
    }

    public Collection<SubRange> adjustSubRangesForRetrans(Collection<SubRange> subRanges) {
        return subRanges;
    }

    public abstract RQReplyMessage newRQReplyMessage(Collection<DKRangeRValue<?>> var1, boolean var2, Collection<MessagePath> var3, int var4);
}

