/*
 * Decompiled with CFR 0.152.
 */
package org.piax.gtrans.ov.ring.rq;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.piax.common.subspace.CircularRange;
import org.piax.common.subspace.Range;
import org.piax.gtrans.ov.ddll.DdllKey;
import org.piax.gtrans.ov.ddll.Node;
import org.piax.util.KeyComparator;

public class RangeUtils {
    private static KeyComparator keyComp = KeyComparator.getInstance();

    public static <K extends Comparable<K>> CircularRange<K> retainRange(CircularRange<K> r, K a, K b) {
        if (r.contains(a) && keyComp.compare(a, r.from) != 0) {
            throw new Error("a is in r");
        }
        if (Node.isOrdered(a, r.from, b) && keyComp.compare(r.from, b) != 0) {
            if (Node.isOrdered(a, r.to, b) && !r.contains(b)) {
                return null;
            }
            return new CircularRange<Comparable>(b, true, r.to, r.toInclusive);
        }
        return r;
    }

    public static <K extends Comparable<K>> Range<K> removedRange(Range<K> r, K a, K b) {
        if (r.contains(a) && keyComp.compare(a, (Comparable<?>)r.from) != 0) {
            throw new Error("a is in r");
        }
        if (Node.isOrdered(a, r.from, b) && keyComp.compare((Comparable<?>)r.from, b) != 0) {
            if (Node.isOrdered(a, r.to, b) && !r.contains(b)) {
                return r;
            }
            return new Range(r.from, r.fromInclusive, b, true);
        }
        return null;
    }

    public static List<CircularRange<DdllKey>> concatAdjacentRanges(List<CircularRange<DdllKey>> ranges) {
        Collections.sort(ranges, new Comparator<Range<?>>(){

            @Override
            public int compare(Range<?> o1, Range<?> o2) {
                return keyComp.compare((Comparable<?>)o1.from, (Comparable<?>)o2.from);
            }
        });
        ArrayList<CircularRange<DdllKey>> merged = new ArrayList<CircularRange<DdllKey>>();
        CircularRange<Comparable<DdllKey>> prev = null;
        for (CircularRange<DdllKey> r : ranges) {
            if (prev == null) {
                prev = r;
                continue;
            }
            if (((DdllKey)prev.to).compareTo((DdllKey)r.from) == 0) {
                prev = new CircularRange<Comparable>(prev.from, prev.fromInclusive, r.to, r.toInclusive);
                continue;
            }
            merged.add(prev);
            prev = r;
        }
        if (prev != null) {
            merged.add(prev);
        }
        return merged;
    }

    public static <K extends Comparable<K>> boolean hasCommon(Range<K> range, K from, K to) {
        return Node.isOrdered(from, range.from, to) || Node.isOrdered(from, range.to, to);
    }
}

