/*
 * Decompiled with CFR 0.152.
 */
package org.piax.gtrans.ov.ring.rq;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import org.piax.common.subspace.CircularRange;
import org.piax.common.subspace.Range;
import org.piax.gtrans.ov.ddll.DdllKey;
import org.piax.gtrans.ov.ddll.Link;
import org.piax.gtrans.ov.ring.rq.DKRangeLink;

public class SubRange
extends DKRangeLink {
    private static final long serialVersionUID = 1L;
    public static final int MAXID = 100000;
    public Integer[] ids;

    public SubRange(DdllKey from, boolean fromInclusive, DdllKey to, boolean toInclusive) {
        this(null, from, fromInclusive, to, toInclusive);
    }

    public SubRange(Link aux, DdllKey from, boolean fromInclusive, DdllKey to, boolean toInclusive) {
        this(aux, from, fromInclusive, to, toInclusive, null);
    }

    public SubRange(Link aux, Range<DdllKey> subRange) {
        this(aux, subRange, null);
    }

    public SubRange(Link aux, Range<DdllKey> subRange, Integer[] ids) {
        super(aux, subRange);
        this.ids = ids;
    }

    public SubRange(Link aux, DdllKey from, boolean fromInclusive, DdllKey to, boolean toInclusive, Integer[] ids) {
        super(aux, from, fromInclusive, to, toInclusive);
        this.ids = ids;
    }

    @Override
    public String toString() {
        return this.rangeString() + (this.getLink() != null ? "&link=" + this.getLink() : "") + (this.ids != null ? "&ids=" + Arrays.toString((Object[])this.ids) : "");
    }

    protected SubRange newInstance(DdllKey from, boolean fromInclusive, DdllKey to, boolean toInclusive) {
        return new SubRange(from, fromInclusive, to, toInclusive);
    }

    public SubRange[] split(DdllKey k) {
        CircularRange<DdllKey>[] s = super.split(k);
        SubRange[] ret = new SubRange[s.length];
        System.arraycopy(s, 0, ret, 0, s.length);
        return ret;
    }

    public List<SubRange> split(NavigableMap<DdllKey, Link> ents) {
        SubRange r = this;
        ArrayList<SubRange> ranges = new ArrayList<SubRange>();
        Link aux = null;
        if (ents.containsKey(this.from)) {
            aux = (Link)ents.get(this.from);
        }
        for (Map.Entry ent : ents.entrySet()) {
            SubRange[] split = this.split((DdllKey)ent.getKey());
            if (split.length == 2) {
                ranges.add(new SubRange(aux, split[0]));
                aux = (Link)ent.getValue();
            }
            r = split[split.length - 1];
        }
        ranges.add(new SubRange(aux, r));
        return ranges;
    }

    public SubRange[] retainRanges(DdllKey a, DdllKey b) {
        if (keyComp.compare(a, b) != 0 && keyComp.isOrdered(this.from, b, a) && keyComp.compare(this.from, a) != 0 && keyComp.isOrdered(b, a, this.to) && keyComp.compare(this.to, b) != 0) {
            return new SubRange[]{new SubRange(b, false, a, false)};
        }
        ArrayList<SubRange> retains = new ArrayList<SubRange>();
        if (this.contains(a) && keyComp.compare(a, this.from) != 0) {
            retains.add(new SubRange((DdllKey)this.from, this.fromInclusive, a, false));
        }
        if (this.contains(b) && keyComp.compare(b, this.to) != 0) {
            retains.add(new SubRange(b, true, (DdllKey)this.to, this.toInclusive));
        }
        if (retains.isEmpty()) {
            return null;
        }
        return retains.toArray(new SubRange[retains.size()]);
    }

    public SubRange concatenate(SubRange another, boolean auxRight) {
        if (((DdllKey)this.to).compareTo((DdllKey)another.from) != 0) {
            throw new IllegalArgumentException("not continuous: " + this + " and " + another);
        }
        SubRange kr = new SubRange(auxRight ? another.getLink() : this.getLink(), (DdllKey)this.from, this.fromInclusive, (DdllKey)another.to, another.toInclusive);
        return kr;
    }

    public void assignId() {
        if (this.ids == null) {
            this.ids = new Integer[1];
            this.ids[0] = (int)(Math.random() * 100000.0);
        }
    }

    public void assignSubId(SubRange parent) {
        if (!this.isSameRange(parent)) {
            Integer[] ids = new Integer[parent.ids.length + 1];
            System.arraycopy(parent.ids, 0, ids, 0, parent.ids.length);
            ids[ids.length - 1] = (int)(Math.random() * 100000.0);
            this.ids = ids;
        } else {
            this.ids = parent.ids;
        }
    }
}

