/*
 * Decompiled with CFR 0.152.
 */
package org.piax.gtrans.ov.sg;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.piax.common.ComparableKey;
import org.piax.common.Destination;
import org.piax.common.Endpoint;
import org.piax.common.ObjectId;
import org.piax.common.TransportId;
import org.piax.common.subspace.KeyRange;
import org.piax.common.subspace.KeyRanges;
import org.piax.common.subspace.LowerUpper;
import org.piax.gtrans.ChannelTransport;
import org.piax.gtrans.FutureQueue;
import org.piax.gtrans.IdConflictException;
import org.piax.gtrans.ProtocolUnsupportedException;
import org.piax.gtrans.RemoteValue;
import org.piax.gtrans.RequestTransportListener;
import org.piax.gtrans.ReturnValue;
import org.piax.gtrans.TransOptions;
import org.piax.gtrans.TransportListener;
import org.piax.gtrans.impl.NestedMessage;
import org.piax.gtrans.ov.OverlayListener;
import org.piax.gtrans.ov.OverlayReceivedMessage;
import org.piax.gtrans.ov.RoutingTableAccessor;
import org.piax.gtrans.ov.compound.CompoundOverlay;
import org.piax.gtrans.ov.ddll.Link;
import org.piax.gtrans.ov.impl.OverlayImpl;
import org.piax.gtrans.ov.sg.SGExecQueryCallback;
import org.piax.gtrans.ov.sg.SkipGraph;
import org.piax.gtrans.ov.sg.UnavailableException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MSkipGraph<D extends Destination, K extends ComparableKey<?>>
extends OverlayImpl<D, K>
implements RoutingTableAccessor,
SGExecQueryCallback {
    private static final Logger logger = LoggerFactory.getLogger(MSkipGraph.class);
    public static TransportId DEFAULT_TRANSPORT_ID = new TransportId("sg");
    SkipGraph<Endpoint> ddllSG;

    public MSkipGraph(ChannelTransport<?> lowerTrans) throws IdConflictException, IOException {
        this(DEFAULT_TRANSPORT_ID, lowerTrans);
    }

    public MSkipGraph(TransportId transId, ChannelTransport<?> lowerTrans) throws IdConflictException, IOException {
        super(lowerTrans.getPeer(), transId, lowerTrans);
        this.peer.registerBaseOverlay(this.transIdPath);
        this.ddllSG = new SkipGraph(new TransportId(transId + "x"), lowerTrans, this);
    }

    @Override
    public synchronized void fin() {
        this.ddllSG.fin();
        super.fin();
    }

    @Override
    public Endpoint getEndpoint() {
        return this.peerId;
    }

    public FutureQueue<?> request1(ObjectId sender, ObjectId receiver, K dst, Object msg, TransOptions opts) throws ProtocolUnsupportedException, IOException {
        return this.request3(sender, receiver, new KeyRanges<K>(dst), msg, opts);
    }

    public FutureQueue<?> request2(ObjectId sender, ObjectId receiver, KeyRange<K> dst, Object msg, TransOptions opts) throws ProtocolUnsupportedException, IOException {
        return this.request3(sender, receiver, new KeyRanges<K>(dst), msg, opts);
    }

    public FutureQueue<?> request3(ObjectId sender, ObjectId receiver, KeyRanges<K> dst, Object msg, TransOptions opts) throws ProtocolUnsupportedException, IOException {
        Collection<KeyRange<K>> ranges = dst.getRanges();
        if (msg != null && msg instanceof NestedMessage && ((NestedMessage)msg).passthrough == CompoundOverlay.SpecialKey.WILDCARD) {
            ranges.add(new KeyRange<CompoundOverlay.SpecialKey>(CompoundOverlay.SpecialKey.WILDCARD));
        }
        NestedMessage nmsg = new NestedMessage(sender, receiver, null, this.peerId, msg);
        return this.ddllSG.scalableRangeQuery(ranges, nmsg, opts);
    }

    @Override
    public FutureQueue<?> request(ObjectId sender, ObjectId receiver, Destination dst, Object msg, TransOptions opts) throws ProtocolUnsupportedException, IOException {
        logger.trace("ENTRY:");
        logger.debug("peer:{} dst:{} msg:{}", new Object[]{this.peerId, dst, msg});
        if (dst instanceof KeyRanges) {
            return this.request3(sender, receiver, (KeyRanges)dst, msg, opts);
        }
        if (dst instanceof KeyRange) {
            return this.request2(sender, receiver, (KeyRange)dst, msg, opts);
        }
        if (dst instanceof ComparableKey) {
            return this.request1(sender, receiver, (ComparableKey)dst, msg, opts);
        }
        if (dst instanceof LowerUpper) {
            return this.forwardQueryToMaxLessThan(sender, receiver, (LowerUpper)dst, msg);
        }
        throw new ProtocolUnsupportedException("skip graph only supports ranges");
    }

    public FutureQueue<?> forwardQueryToMaxLessThan(ObjectId sender, ObjectId receiver, LowerUpper lu, Object msg) throws IllegalStateException {
        logger.trace("ENTRY:");
        NestedMessage nmsg = new NestedMessage(sender, receiver, null, this.peerId, msg);
        List<RemoteValue<?>> ret = this.ddllSG.forwardQuery(lu.isPlusDir(), lu.getRange(), lu.getMaxNum(), nmsg);
        ArrayList<RemoteValue> ret2 = new ArrayList<RemoteValue>();
        if (ret != null) {
            for (RemoteValue remoteValue : ret) {
                if (remoteValue != null && remoteValue.getValue() instanceof MVal) {
                    MVal mval = (MVal)remoteValue.getValue();
                    for (ReturnValue<Object> o : mval.vals) {
                        ret2.add(new RemoteValue<Object>(remoteValue.getPeer(), o.getValue(), o.getException()));
                    }
                    continue;
                }
                ret2.add(remoteValue);
            }
        }
        FutureQueue fq = new FutureQueue(ret2);
        fq.setEOFuture();
        return fq;
    }

    @Override
    public RemoteValue<?> sgExecQuery(Comparable<?> key, Object msg) {
        logger.trace("ENTRY:");
        FutureQueue<?> rets = this.onReceiveRequest(Collections.singleton((ComparableKey)key), (NestedMessage)msg);
        MVal mval = new MVal();
        for (RemoteValue<?> x : rets) {
            mval.vals.add(new ReturnValue(x.getValue(), x.getException()));
        }
        return new RemoteValue<MVal>((Endpoint)this.peerId, mval);
    }

    public FutureQueue<?> onReceiveRequest(Collection<K> matchedKeys, NestedMessage nmsg) {
        logger.trace("ENTRY:");
        logger.debug("matchedKeys:{} nmsg:{}", matchedKeys, (Object)nmsg);
        if (matchedKeys.contains(CompoundOverlay.SpecialKey.WILDCARD)) {
            nmsg.setPassthrough(CompoundOverlay.SpecialKey.WILDCARD);
        } else {
            nmsg.setPassthrough(null);
        }
        Set<K> keys = this.getKeys(nmsg.receiver);
        keys.retainAll(matchedKeys);
        if (keys.isEmpty() && nmsg.passthrough != CompoundOverlay.SpecialKey.WILDCARD) {
            return FutureQueue.emptyQueue();
        }
        OverlayReceivedMessage<K> rcvMsg = new OverlayReceivedMessage<K>(nmsg.sender, nmsg.src, keys, nmsg.getInner());
        TransportListener listener = this.getListener0(nmsg.receiver);
        if (listener == null) {
            logger.info("onReceiveRequest data purged as no such listener {}", (Object)nmsg.receiver);
            return FutureQueue.emptyQueue();
        }
        if (listener instanceof OverlayListener) {
            return this.selectOnReceive((OverlayListener)listener, this, rcvMsg);
        }
        if (listener instanceof RequestTransportListener) {
            return this.selectOnReceive((RequestTransportListener)listener, this, rcvMsg);
        }
        Object inn = this.checkAndClearIsEasySend(rcvMsg.getMessage());
        rcvMsg.setMessage(inn);
        listener.onReceive(this, rcvMsg);
        return FutureQueue.emptyQueue();
    }

    private boolean meansRoot(Endpoint seed) {
        return this.getEndpoint().equals(seed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean join(Collection<? extends Endpoint> seeds) throws IOException {
        Map map = this.keyRegister;
        synchronized (map) {
            logger.trace("ENTRY:");
            if (this.isJoined) {
                return false;
            }
            if (seeds == null || seeds.size() == 0) {
                throw new IllegalArgumentException("invalied specified seeds");
            }
            this.registerKey(this.peerId);
            if (seeds.size() == 1) {
                for (Endpoint endpoint : seeds) {
                    if (!this.meansRoot(endpoint)) continue;
                    for (ComparableKey comparableKey : this.keyRegister.keySet()) {
                        this.sgAddKey(null, comparableKey);
                    }
                    this.isJoined = true;
                    return true;
                }
            }
            Iterator it = this.keyRegister.keySet().iterator();
            ComparableKey comparableKey = (ComparableKey)it.next();
            for (Endpoint endpoint : seeds) {
                if (this.meansRoot(endpoint)) continue;
                this.sgAddKey(endpoint, comparableKey);
                break;
            }
            while (it.hasNext()) {
                ComparableKey key = (ComparableKey)it.next();
                this.sgAddKey(null, key);
            }
            this.isJoined = true;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean leave() throws IOException {
        Map map = this.keyRegister;
        synchronized (map) {
            logger.trace("ENTRY:");
            if (!this.isJoined) {
                return false;
            }
            for (ComparableKey key : this.keyRegister.keySet()) {
                this.sgRemoveKey(key);
            }
            this.isJoined = false;
            return true;
        }
    }

    @Override
    public Class<?> getAvailableKeyType() {
        return Comparable.class;
    }

    private void sgAddKey(Endpoint seed, K key) throws IOException {
        logger.trace("ENTRY:");
        try {
            this.ddllSG.addKey(seed, (Comparable<?>)key);
        }
        catch (UnavailableException e) {
            logger.error("", (Throwable)e);
            throw new IOException(e);
        }
    }

    @Override
    protected void lowerAddKey(K key) throws IOException {
        if (!this.isJoined) {
            return;
        }
        this.sgAddKey(null, key);
    }

    @Override
    public boolean addKey(ObjectId upper, K key) throws IOException {
        logger.trace("ENTRY:");
        logger.debug("upper:{} key:{}", (Object)upper, key);
        if (key == null) {
            throw new IllegalArgumentException("null key specified");
        }
        return super.addKey(upper, key);
    }

    private void sgRemoveKey(K key) throws IOException {
        logger.trace("ENTRY:");
        this.ddllSG.removeKey((Comparable<?>)key);
    }

    @Override
    protected void lowerRemoveKey(K key) throws IOException {
        if (!this.isJoined) {
            return;
        }
        this.sgRemoveKey(key);
    }

    @Override
    public boolean removeKey(ObjectId upper, K key) throws IOException {
        logger.trace("ENTRY:");
        logger.debug("upper:{} key:{}", (Object)upper, key);
        if (key == null) {
            throw new IllegalArgumentException("null key specified");
        }
        return super.removeKey(upper, key);
    }

    @Override
    public Set<K> getKeys(ObjectId upper) {
        Set keys = super.getKeys(upper);
        keys.add(this.peerId);
        return keys;
    }

    @Override
    public FutureQueue<?> request(ObjectId sender, ObjectId receiver, D dst, Object msg, int timeout) throws ProtocolUnsupportedException, IOException {
        return this.request(sender, receiver, (Destination)dst, msg, new TransOptions(timeout));
    }

    @Override
    public Link[] getAll() {
        return this.ddllSG.getNeighbors(null, false, 0);
    }

    @Override
    public Link getLocal(Comparable<?> key) {
        return this.ddllSG.getLocal(key);
    }

    @Override
    public Link getRight(Comparable<?> key) {
        return this.getRight(key, 0);
    }

    @Override
    public Link getLeft(Comparable<?> key) {
        return this.getLeft(key, 0);
    }

    @Override
    public Link getRight(Comparable<?> key, int level) {
        return this.getRights(key, level)[0];
    }

    @Override
    public Link getLeft(Comparable<?> key, int level) {
        return this.getLefts(key, level)[0];
    }

    @Override
    public Link[] getRights(Comparable<?> key) {
        return this.getRights(key, 0);
    }

    @Override
    public Link[] getLefts(Comparable<?> key) {
        return this.getLefts(key, 0);
    }

    @Override
    public Link[] getRights(Comparable<?> key, int level) {
        return this.ddllSG.getNeighbors(key, true, level);
    }

    @Override
    public Link[] getLefts(Comparable<?> key, int level) {
        return this.ddllSG.getNeighbors(key, false, level);
    }

    @Override
    public int getHeight(Comparable<?> key) {
        return this.ddllSG.getHeight(key);
    }

    static class MVal
    implements Serializable {
        private static final long serialVersionUID = 1L;
        List<ReturnValue<Object>> vals = new ArrayList<ReturnValue<Object>>();

        MVal() {
        }
    }
}

