/*
 * Decompiled with CFR 0.152.
 */
package org.piax.gtrans.ov.sg;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.NavigableMap;
import org.piax.common.Endpoint;
import org.piax.common.PeerId;
import org.piax.common.subspace.Range;
import org.piax.gtrans.RemoteValue;
import org.piax.gtrans.TransOptions;
import org.piax.gtrans.ov.ddll.DdllKey;
import org.piax.gtrans.ov.ddll.Link;
import org.piax.gtrans.ov.sg.DdllKeyRange;
import org.piax.gtrans.ov.sg.RQReturn;
import org.piax.gtrans.ov.sg.SGMessagingFramework;
import org.piax.gtrans.ov.sg.SkipGraph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RQMessage<E extends Endpoint>
extends SGMessagingFramework.SGRequestMessage<E> {
    private static final Logger logger = LoggerFactory.getLogger(RQMessage.class);
    private static final long serialVersionUID = 1L;
    public static final boolean TRACE = true;
    final Collection<Range<DdllKey>> subRanges;
    final SkipGraph.QueryId qid;
    final Object query;
    final int hops;
    transient RQReturn<E> rqRet;
    final List<Link> failedLinks;
    transient NavigableMap<DdllKey, Link> cachedAllLinks;
    List<String> trace;

    public static <E extends Endpoint> RQMessage<E> newRQMessage4Root(SGMessagingFramework<E> sgmf, Collection<Range<DdllKey>> subRanges, SkipGraph.QueryId qid, Object query, int expire, TransOptions opts) {
        RQMessage<Object> msg = TransOptions.responseType(opts) != TransOptions.ResponseType.DIRECT ? new RQMessage<Object>(sgmf, true, false, null, 0, subRanges, qid, query, expire, 0) : new RQMessage<E>(sgmf, true, true, sgmf.myLocator, 0, subRanges, qid, query, expire, 0);
        return msg;
    }

    private RQMessage(SGMessagingFramework<E> sgmf, boolean isRoot, boolean isDirectReturn, E replyTo, int replyId, Collection<Range<DdllKey>> subRanges, SkipGraph.QueryId qid, Object query, int expire, int hops) {
        super(sgmf, isRoot, isDirectReturn, replyTo, replyId, expire);
        this.subRanges = subRanges;
        this.qid = qid;
        this.query = query;
        this.hops = hops;
        this.failedLinks = new ArrayList<Link>();
        this.trace = new ArrayList<String>();
    }

    public RQMessage<E> newInstanceSubrangesChanged(Collection<Range<DdllKey>> newSubRanges) {
        RQMessage<E> newMsg = new RQMessage<E>(this, newSubRanges);
        newMsg.rqRet = this.rqRet;
        return newMsg;
    }

    private RQMessage(RQMessage<E> msgSrc, Collection<Range<DdllKey>> newSubRanges) {
        super(msgSrc);
        this.subRanges = newSubRanges;
        this.qid = msgSrc.qid;
        this.query = msgSrc.query;
        this.hops = msgSrc.hops;
        this.failedLinks = new ArrayList<Link>(msgSrc.failedLinks);
        this.trace = new ArrayList<String>(msgSrc.trace);
    }

    public RQMessage<E> newChildInstance(Collection<Range<DdllKey>> newSubRange, String reason) {
        RQMessage<Object> newMsg = this.isDirectReturn ? new RQMessage<Endpoint>(this.sgmf, false, true, this.replyTo, this.replyId, newSubRange, this.qid, this.query, this.expire, this.hops + 1) : new RQMessage<Object>(this.sgmf, false, false, null, 0, newSubRange, this.qid, this.query, this.expire, this.hops + 1);
        newMsg.rqRet = this.rqRet;
        assert (this.rqRet != null);
        newMsg.addFailedLinks(this.failedLinks);
        newMsg.addTrace(this.trace);
        newMsg.addTrace(reason);
        return newMsg;
    }

    public String toString() {
        return "RQMsg[sender=" + this.sender + ", receiver=" + this.receiver + ", msgId=" + this.msgId + ", replyTo=" + this.replyTo + ", replyId=" + this.replyId + ", subRanges=" + this.subRanges + ", rqRet=" + this.rqRet + ", failedLinks=" + this.failedLinks + "]";
    }

    void addFailedLinks(Collection<Link> links) {
        this.failedLinks.addAll(links);
    }

    void addTrace(Collection<String> locs) {
        this.trace.addAll(locs);
    }

    void addTrace(String loc) {
        this.trace.add(loc);
    }

    @Override
    public void execute(SkipGraph<E> sg) {
        sg.rqDisseminate(this);
    }

    @Override
    public boolean onReceivingReply(SkipGraph<E> sg, SGMessagingFramework.SGReplyMessage<E> reply0) {
        RQReplyMessage reply = (RQReplyMessage)reply0;
        logger.debug("onReceivingReply: reply={}, this={}", (Object)reply, (Object)this);
        sg.rqSetReturnValue(this.rqRet, reply.senderId, reply.vals, reply.hops);
        if (this.isDirectReturn) {
            assert (this.isRoot);
            return this.rqRet.isCompleted();
        }
        return reply.isFinal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void onTimeOut(SkipGraph<E> sg) {
        logger.debug("onTimeout: {}, {}", (Object)sg.toStringShort(), (Object)this);
        RQReturn<E> rQReturn = this.rqRet;
        synchronized (rQReturn) {
            HashSet<Link> failedNodes = new HashSet<Link>();
            HashSet<Range<DdllKey>> ranges = new HashSet<Range<DdllKey>>();
            for (RQMessage msg : this.rqRet.childMsgs.values()) {
                if (!msg.isAckTimedOut()) continue;
                msg.ackReceived = true;
                failedNodes.add(msg.receiver);
                ranges.addAll(msg.subRanges);
            }
            logger.debug("onTimeout: failedNodes = {}", failedNodes);
            if (!failedNodes.isEmpty()) {
                sg.fixRoutingTables(failedNodes, this.rqRet.parentMsg, ranges);
            }
        }
    }

    public static class RQReplyMessage<E extends Endpoint>
    extends SGMessagingFramework.SGReplyMessage<E> {
        private static final long serialVersionUID = 1L;
        final PeerId senderId;
        final Collection<DdllKeyRange<RemoteValue<?>>> vals;
        final boolean isFinal;
        final int hops;

        public RQReplyMessage(SkipGraph<E> sg, RQMessage<E> replyTo, Collection<DdllKeyRange<RemoteValue<?>>> vals, boolean isFinal, int hops) {
            super(sg, replyTo);
            this.senderId = sg.peerId;
            this.vals = vals;
            this.isFinal = isFinal;
            this.hops = hops;
        }
    }
}

