/*
 * Decompiled with CFR 0.152.
 */
package org.piax.gtrans.ov.sg;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentSkipListMap;
import org.piax.common.Endpoint;
import org.piax.common.PeerId;
import org.piax.common.subspace.Range;
import org.piax.gtrans.FutureQueue;
import org.piax.gtrans.RemoteValue;
import org.piax.gtrans.ReturnValue;
import org.piax.gtrans.ov.ddll.DdllKey;
import org.piax.gtrans.ov.ddll.Link;
import org.piax.gtrans.ov.sg.DdllKeyRange;
import org.piax.gtrans.ov.sg.MSkipGraph;
import org.piax.gtrans.ov.sg.RQMessage;
import org.piax.gtrans.ov.sg.SkipGraph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RQReturn<E extends Endpoint>
extends TimerTask {
    private static final Logger logger = LoggerFactory.getLogger(RQReturn.class);
    final SkipGraph<E> sg;
    final RQMessage<E> parentMsg;
    final FutureQueue<Object> fq;
    final NavigableMap<DdllKey, DdllKeyRange<RemoteValue<?>>> rvals;
    final transient boolean isRoot;
    final Map<Link, RQMessage<E>> childMsgs = new HashMap<Link, RQMessage<E>>();
    final NavigableMap<DdllKey, Range<DdllKey>> gaps;
    private transient boolean disposed = false;
    int rcvCount = 0;
    int maxHops = 0;
    int retransCount = 0;
    TimerTask expirationTask;

    RQReturn(SkipGraph<E> sg, RQMessage<E> msg, long expire, boolean isRoot) {
        this.sg = sg;
        this.isRoot = isRoot;
        this.parentMsg = msg;
        this.rvals = new ConcurrentSkipListMap();
        this.gaps = new ConcurrentSkipListMap<DdllKey, Range<DdllKey>>();
        for (Range<DdllKey> range : msg.subRanges) {
            this.gaps.put((DdllKey)range.from, range);
        }
        this.fq = isRoot ? new FutureQueue() : null;
        if (expire != 0L) {
            this.expirationTask = new TimerTask(){

                @Override
                public void run() {
                    RQReturn.this.dispose();
                    if (RQReturn.this.fq != null) {
                        RQReturn.this.fq.setEOFuture();
                    }
                }
            };
            sg.timer.schedule(this.expirationTask, expire);
            logger.debug("schedule expiration {} after {}", (Object)this, (Object)expire);
        }
    }

    public synchronized String toString() {
        return "[ID=0x" + Integer.toHexString(System.identityHashCode(this)) + ", rvals=" + this.rvals + ", gaps=" + this.gaps + ", childMsgs.keys=" + this.childMsgs.keySet() + ", rcvCount=" + this.rcvCount + ", maxHops=" + this.maxHops + ", retrans=" + this.retransCount + "]";
    }

    synchronized void dispose() {
        logger.debug("dispose: {}", (Object)this);
        this.cancel();
        if (this.expirationTask != null) {
            this.expirationTask.cancel();
        }
        this.disposed = true;
    }

    synchronized void addRemoteValue(RemoteValue<?> rval, Range<DdllKey> r) {
        if (this.rvals.containsKey(r.from)) {
            return;
        }
        Map.Entry<DdllKey, Range<DdllKey>> ent = this.gaps.floorEntry((DdllKey)r.from);
        if (ent == null) {
            logger.info("no gap instance: {} in {}", r.from, (Object)this);
            return;
        }
        Range<DdllKey> gap = ent.getValue();
        this.gaps.remove(ent.getKey());
        if (!r.isSingleton()) {
            Range<DdllKey>[] sp;
            if (((DdllKey)r.from).compareTo((DdllKey)gap.from) == 0) {
                if (((DdllKey)r.to).compareTo((DdllKey)gap.to) < 0) {
                    sp = gap.split((DdllKey)r.to);
                    this.gaps.put((DdllKey)sp[1].from, sp[1]);
                }
            } else if (((DdllKey)r.from).compareTo((DdllKey)gap.to) < 0) {
                sp = gap.split((DdllKey)r.from);
                this.gaps.put(ent.getKey(), sp[0]);
                if (((DdllKey)r.to).compareTo((DdllKey)sp[1].to) < 0) {
                    Range<DdllKey>[] sp2 = sp[1].split((DdllKey)r.to);
                    this.gaps.put((DdllKey)sp2[1].from, sp2[1]);
                }
            }
        }
        this.rvals.put((DdllKey)r.from, new DdllKeyRange(rval, r));
        if (this.fq != null) {
            try {
                Object v = rval.get();
                if (v != null) {
                    RemoteValue<?> rv = rval;
                    if (rv.getValue() instanceof MSkipGraph.MVal) {
                        MSkipGraph.MVal mval = (MSkipGraph.MVal)rv.getValue();
                        for (ReturnValue<Object> o : mval.vals) {
                            this.fq.put(new RemoteValue<Object>(rv.getPeer(), o.getValue(), o.getException()));
                        }
                    } else {
                        this.fq.put(rv);
                    }
                }
            }
            catch (IllegalStateException e) {
                logger.warn("", (Throwable)e);
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.isCompleted()) {
            this.flush();
            this.notifyAll();
            this.dispose();
            if (this.fq != null) {
                logger.debug("call noMoreFutures");
                this.fq.setEOFuture();
            }
        }
    }

    synchronized void flush() {
        if (this.isRoot) {
            return;
        }
        if (this.rvals.size() == 0) {
            return;
        }
        logger.debug("{}: flush(): {}", (Object)this.sg.toStringShort(), (Object)this);
        ArrayList vals = new ArrayList(this.rvals.values());
        logger.debug("{}: send reply. vals={}, hops = {}", new Object[]{this.sg.toStringShort(), vals, this.maxHops + 1});
        RQMessage.RQReplyMessage<E> rep = new RQMessage.RQReplyMessage<E>(this.sg, this.parentMsg, vals, this.isCompleted(), this.maxHops + 1);
        rep.reply();
        if (this.isCompleted()) {
            this.rvals.clear();
        }
    }

    synchronized boolean confirmResponseFromChildNode(PeerId child) {
        boolean rc = false;
        for (Link l : this.childMsgs.keySet()) {
            if (!l.key.getUniqId().equals(child)) continue;
            this.childMsgs.remove(l);
            rc = true;
            break;
        }
        return rc;
    }

    synchronized void incrementRcvCount() {
        ++this.rcvCount;
    }

    synchronized void updateHops(int hops) {
        this.maxHops = Math.max(this.maxHops, hops);
    }

    boolean isCompleted() {
        return this.gaps.size() == 0;
    }

    synchronized Collection<RemoteValue<?>> get(long timeout) throws InterruptedException {
        if (this.isCompleted()) {
            return this.getResults();
        }
        try {
            this.wait(timeout);
            Collection<RemoteValue<?>> collection = this.getResults();
            return collection;
        }
        catch (InterruptedException e) {
            throw e;
        }
        finally {
            this.cancel();
        }
    }

    private Collection<RemoteValue<?>> getResults() {
        ArrayList list = new ArrayList();
        for (DdllKeyRange rval : this.rvals.values()) {
            try {
                Object v = ((RemoteValue)rval.aux).get();
                if (v == null) continue;
                list.add((RemoteValue<?>)rval.aux);
            }
            catch (InvocationTargetException invocationTargetException) {}
        }
        return list;
    }

    synchronized void scheduleTask(Timer timer, int retransPeriod) {
        if (!this.disposed) {
            try {
                timer.schedule((TimerTask)this, retransPeriod, (long)retransPeriod);
            }
            catch (IllegalStateException e) {
                logger.info("RQReturn task already canceled");
                logger.info("", (Throwable)e);
            }
        }
    }

    @Override
    public void run() {
        if (this.isRoot) {
            this.retransmit();
        } else {
            this.flush();
        }
    }

    private synchronized void retransmit() {
        if (this.isCompleted()) {
            return;
        }
        Collection<Range<DdllKey>> subRanges = this.gaps.values();
        RQMessage<E> m = this.parentMsg.newChildInstance(subRanges, "retrans@root");
        logger.debug("retransmit: retrans {}, {}", (Object)this, m);
        if (this.parentMsg.cachedAllLinks != null) {
            this.sg.rqDisseminate(m, this.parentMsg.cachedAllLinks);
        } else {
            this.sg.rqDisseminate(m);
        }
        ++this.retransCount;
    }
}

